/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.GenQueryInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSGenQueryTranslator;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSGenQueryExecutorImpl
extends IRODSGenericAO
implements IRODSGenQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(IRODSGenQueryExecutorImpl.class);

    public IRODSGenQueryExecutorImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQuery(IRODSGenQuery irodsQuery, int continueIndex) throws JargonException, JargonQueryException {
        log.info("executeIRODSQuery()");
        return this.executeIRODSQueryInZone(irodsQuery, continueIndex, null);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryInZone(IRODSGenQuery irodsQuery, int continueIndex, String zoneName) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryInZone()");
        if (irodsQuery == null) {
            throw new IllegalArgumentException("null irodsQuery");
        }
        if (continueIndex < 0) {
            throw new IllegalArgumentException("continue index must be > 0");
        }
        log.info("query: {}", (Object)irodsQuery.getQueryString());
        IRODSGenQueryTranslator irodsQueryTranslator = new IRODSGenQueryTranslator(this.getIRODSServerProperties());
        TranslatedIRODSGenQuery translatedIRODSQuery = irodsQueryTranslator.getTranslatedQuery(irodsQuery);
        return this.executeTranslatedIRODSQuery(translatedIRODSQuery, 0, 0, QueryCloseBehavior.MANUAL_CLOSE, zoneName);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryAndCloseResult(IRODSGenQuery irodsQuery, int continueIndex) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryAndCloseResult()");
        return this.executeIRODSQueryAndCloseResultInZone(irodsQuery, continueIndex, null);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryAndCloseResultInZone(IRODSGenQuery irodsQuery, int continueIndex, String zoneName) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryAndCloseResultInZone()");
        if (irodsQuery == null) {
            throw new IllegalArgumentException("null irodsQuery");
        }
        if (continueIndex < 0) {
            throw new IllegalArgumentException("continueIndex is < 0");
        }
        log.info("query: {}", (Object)irodsQuery.getQueryString());
        IRODSGenQueryTranslator irodsQueryTranslator = new IRODSGenQueryTranslator(this.getIRODSServerProperties());
        TranslatedIRODSGenQuery translatedIRODSQuery = irodsQueryTranslator.getTranslatedQuery(irodsQuery);
        return this.executeTranslatedIRODSQuery(translatedIRODSQuery, 0, 0, QueryCloseBehavior.AUTO_CLOSE, zoneName);
    }

    @Override
    public IRODSQueryResultSetInterface executeIRODSQueryWithPaging(IRODSGenQuery irodsQuery, int partialStartIndex) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryWithPaging()");
        return this.executeIRODSQueryWithPagingInZone(irodsQuery, partialStartIndex, null);
    }

    @Override
    public IRODSQueryResultSetInterface executeIRODSQueryWithPagingInZone(IRODSGenQuery irodsQuery, int partialStartIndex, String zoneName) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryWithPagingInZone()");
        if (irodsQuery == null) {
            throw new IllegalArgumentException("null irodsQuery");
        }
        log.info("query: {}", (Object)irodsQuery.getQueryString());
        IRODSGenQueryTranslator irodsQueryTranslator = new IRODSGenQueryTranslator(this.getIRODSServerProperties());
        TranslatedIRODSGenQuery translatedIRODSQuery = irodsQueryTranslator.getTranslatedQuery(irodsQuery);
        return this.executeTranslatedIRODSQuery(translatedIRODSQuery, 0, partialStartIndex, QueryCloseBehavior.AUTO_CLOSE, zoneName);
    }

    private IRODSQueryResultSet executeTranslatedIRODSQuery(TranslatedIRODSGenQuery translatedIRODSQuery, int continueIndex, int partialStartIndex, QueryCloseBehavior queryCloseBehavior, String zoneName) throws JargonException {
        Tag response;
        if (continueIndex < 0) {
            throw new JargonException("continue index must be >= 0");
        }
        if (partialStartIndex < 0) {
            throw new JargonException("partial start index cannot be less than zero");
        }
        GenQueryInp genQueryInp = partialStartIndex == 0 ? GenQueryInp.instance(translatedIRODSQuery, continueIndex, zoneName) : GenQueryInp.instanceWithPartialStart(translatedIRODSQuery, partialStartIndex, zoneName);
        try {
            response = this.sendGenQueryAndReturnResponse(genQueryInp);
        }
        catch (DataNotFoundException dnf) {
            log.info("response from IRODS call indicates no rows found");
            ArrayList<IRODSQueryResultRow> result = new ArrayList<IRODSQueryResultRow>();
            IRODSQueryResultSet resultSet = IRODSQueryResultSet.instance(translatedIRODSQuery, result, 0);
            return resultSet;
        }
        int continuation = response.getTag("continueInx").getIntValue();
        log.info("continuation value: {}", continuation);
        ArrayList<String> columnNames = new ArrayList<String>();
        for (GenQuerySelectField selectField : translatedIRODSQuery.getSelectFields()) {
            columnNames.add(selectField.getSelectFieldColumnName());
        }
        List<IRODSQueryResultRow> result = this.translateResponseIntoResultSet(response, translatedIRODSQuery, columnNames, continuation);
        IRODSQueryResultSet resultSet = IRODSQueryResultSet.instance(translatedIRODSQuery, result, continuation);
        if (resultSet.isHasMoreRecords() && queryCloseBehavior == QueryCloseBehavior.AUTO_CLOSE) {
            log.info("auto closing result set");
            this.closeResults(resultSet);
        }
        return resultSet;
    }

    private Tag sendGenQueryAndReturnResponse(GenQueryInp genQueryInp) throws JargonException, DataNotFoundException {
        Tag response = this.getIRODSProtocol().irodsFunction("GenQueryInp_PI", genQueryInp.getParsedTags(), 702);
        return response;
    }

    private List<IRODSQueryResultRow> translateResponseIntoResultSet(Tag queryResponse, TranslatedIRODSGenQuery translatedIRODSQuery, List<String> columnNames, int continuation) throws JargonException {
        ArrayList<IRODSQueryResultRow> resultSet = new ArrayList<IRODSQueryResultRow>();
        int recordCount = 1;
        boolean lastRecord = continuation == 0;
        log.debug("are there more records? {}", lastRecord);
        if (queryResponse == null) {
            log.info("empty result set from query, returning as an empty result set ( no rows found)");
            return resultSet;
        }
        int rows = queryResponse.getTag("rowCnt").getIntValue();
        log.info("rows returned from iRODS for GenQuery: {}", rows);
        int attributes = queryResponse.getTag("attriCnt").getIntValue();
        for (int i = 0; i < rows; ++i) {
            ArrayList<String> row = new ArrayList<String>();
            for (int j = 0; j < attributes; ++j) {
                row.add(queryResponse.getTags()[4 + j].getTags()[2 + i].getStringValue());
            }
            resultSet.add(IRODSQueryResultRow.instance(row, columnNames, recordCount++, lastRecord));
        }
        return resultSet;
    }

    @Override
    public IRODSQueryResultSet getMoreResults(IRODSQueryResultSet irodsQueryResultSet) throws JargonException, JargonQueryException {
        log.info("getting more results for query");
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        if (!irodsQueryResultSet.isHasMoreRecords()) {
            throw new JargonQueryException("no more results");
        }
        return this.executeTranslatedIRODSQuery(irodsQueryResultSet.getTranslatedIRODSQuery(), irodsQueryResultSet.getContinuationIndex(), 0, QueryCloseBehavior.MANUAL_CLOSE, null);
    }

    @Override
    public IRODSQueryResultSet getMoreResultsInZone(IRODSQueryResultSet irodsQueryResultSet, String zoneName) throws JargonException, JargonQueryException {
        log.info("getting more results for query");
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        if (!irodsQueryResultSet.isHasMoreRecords()) {
            throw new JargonQueryException("no more results");
        }
        return this.executeTranslatedIRODSQuery(irodsQueryResultSet.getTranslatedIRODSQuery(), irodsQueryResultSet.getContinuationIndex(), 0, QueryCloseBehavior.MANUAL_CLOSE, zoneName);
    }

    @Override
    public void closeResults(IRODSQueryResultSetInterface irodsQueryResultSet) throws JargonException {
        log.info("getting more results for query");
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        if (!irodsQueryResultSet.isHasMoreRecords()) {
            log.info("no results to close, ignore");
            return;
        }
        IRODSQueryResultSet genQueryResult = (IRODSQueryResultSet)irodsQueryResultSet;
        GenQueryInp genQueryInp = GenQueryInp.instanceForCloseQuery(genQueryResult.getTranslatedIRODSQuery(), genQueryResult.getContinuationIndex());
        this.sendGenQueryAndReturnResponse(genQueryInp);
    }

    public static enum QueryCloseBehavior {
        AUTO_CLOSE,
        MANUAL_CLOSE;

    }
}

