/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.ResourceAO;
import org.irods.jargon.core.pub.ResourceAOHelper;
import org.irods.jargon.core.pub.domain.AvuData;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.AccessObjectQueryProcessingUtils;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceAOImpl
extends IRODSGenericAO
implements ResourceAO {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ERROR_IN_RESOURCE_QUERY = "error in resource query";
    private final transient ResourceAOHelper resourceAOHelper;

    public ResourceAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.getIRODSAccessObjectFactory().getZoneAO(this.getIRODSAccount());
        this.resourceAOHelper = new ResourceAOHelper(this.getIRODSAccount(), this.getIRODSAccessObjectFactory());
    }

    @Override
    public Resource findByName(String resourceName) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder sb = new StringBuilder();
        sb.append(this.resourceAOHelper.buildResourceSelects());
        sb.append(" WHERE ");
        sb.append(RodsGenQueryEnum.COL_R_RESC_NAME.getName());
        sb.append(" = '");
        sb.append(resourceName.trim());
        sb.append("'");
        String queryString = sb.toString();
        if (this.log.isInfoEnabled()) {
            this.log.info("query:" + queryString);
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 500);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:{}", (Object)queryString, (Object)e);
            throw new JargonException(ERROR_IN_RESOURCE_QUERY);
        }
        if (resultSet.getResults().size() == 0) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("resource not found for name:");
            messageBuilder.append(resourceName);
            String message = messageBuilder.toString();
            this.log.warn(message);
            throw new DataNotFoundException(message);
        }
        if (resultSet.getResults().size() > 1) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("more than one resource found for name:");
            messageBuilder.append(resourceName);
            String message = messageBuilder.toString();
            this.log.error(message);
            throw new JargonException(message);
        }
        IRODSQueryResultRow row = resultSet.getFirstResult();
        Resource resource = this.resourceAOHelper.buildResourceFromResultSetRow(row);
        return resource;
    }

    @Override
    public Resource findById(String resourceId) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder sb = new StringBuilder();
        sb.append(this.resourceAOHelper.buildResourceSelects());
        sb.append(" where ");
        sb.append(RodsGenQueryEnum.COL_R_RESC_ID.getName());
        sb.append(" = '");
        sb.append(resourceId.trim());
        sb.append("'");
        String queryString = sb.toString();
        if (this.log.isInfoEnabled()) {
            this.log.info("query:{}", (Object)queryString);
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 500);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:" + queryString, e);
            throw new JargonException(ERROR_IN_RESOURCE_QUERY);
        }
        if (resultSet.getResults().size() == 0) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("resource not found for id:");
            messageBuilder.append(resourceId);
            String message = messageBuilder.toString();
            this.log.warn(message);
            throw new DataNotFoundException(message);
        }
        if (resultSet.getResults().size() > 1) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("more than one resource found for id:");
            messageBuilder.append(resourceId);
            String message = messageBuilder.toString();
            this.log.error(message);
            throw new JargonException(message);
        }
        IRODSQueryResultRow row = resultSet.getFirstResult();
        Resource resource = this.resourceAOHelper.buildResourceFromResultSetRow(row);
        return resource;
    }

    @Override
    public List<Resource> findAll() throws JargonException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder userQuery = new StringBuilder();
        userQuery.append(this.resourceAOHelper.buildResourceSelects());
        String queryString = userQuery.toString();
        if (this.log.isInfoEnabled()) {
            this.log.info("user query:{}", (Object)queryString);
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for:{}", (Object)queryString, (Object)e);
            throw new JargonException(ERROR_IN_RESOURCE_QUERY);
        }
        return this.resourceAOHelper.buildResourceListFromResultSet(resultSet);
    }

    @Override
    public Resource getFirstResourceForIRODSFile(IRODSFile irodsFile) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        if (irodsFile == null) {
            throw new JargonException("irods file is null");
        }
        StringBuilder query = new StringBuilder();
        query.append(this.resourceAOHelper.buildResourceSelects());
        query.append(" where ");
        if (!irodsFile.isFile()) {
            String msg = "looking for a resource for an IRODSFileImpl, but I the file is a collection:" + irodsFile.getAbsolutePath();
            this.log.error(msg);
            throw new JargonException(msg);
        }
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsFile.getParent()));
        query.append("'");
        query.append(" AND ");
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsFile.getName()));
        query.append("'");
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        String queryString = query.toString();
        if (this.log.isInfoEnabled()) {
            this.log.info("resource query:{}", (Object)this.toString());
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for:{}", (Object)queryString, (Object)e);
            throw new JargonException("error in query");
        }
        List<Resource> resources = this.resourceAOHelper.buildResourceListFromResultSet(resultSet);
        if (resources.isEmpty()) {
            this.log.warn("no data found");
            throw new DataNotFoundException("no resources found for file:" + irodsFile.getAbsolutePath());
        }
        return resources.get(0);
    }

    @Override
    public List<Resource> listResourcesInZone(String zoneName) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (zoneName == null || zoneName.length() == 0) {
            throw new JargonException("zone name is null or blank");
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder query = new StringBuilder();
        query.append(this.resourceAOHelper.buildResourceSelects());
        query.append(" where ");
        query.append(RodsGenQueryEnum.COL_R_ZONE_NAME.getName());
        query.append(" = '");
        query.append(zoneName);
        query.append("'");
        String queryString = query.toString();
        if (this.log.isInfoEnabled()) {
            this.log.info("resource query:" + this.toString());
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for:{}", (Object)queryString, (Object)e);
            throw new JargonException("error in query");
        }
        return this.resourceAOHelper.buildResourceListFromResultSet(resultSet);
    }

    @Override
    public List<AvuData> listResourceMetadata(String resourceName) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (resourceName == null || resourceName.isEmpty()) {
            throw new JargonException("null or empty resourceName");
        }
        this.log.info("list resource metadata for {}", (Object)resourceName);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(RodsGenQueryEnum.COL_META_RESC_ATTR_NAME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_RESC_ATTR_VALUE.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_RESC_ATTR_UNITS.getName());
        sb.append(" WHERE ");
        sb.append(RodsGenQueryEnum.COL_R_RESC_NAME.getName());
        sb.append(" = '");
        sb.append(resourceName);
        sb.append("'");
        this.log.debug("resource avu list query: {}", (Object)sb.toString());
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(sb.toString(), 500);
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query: " + sb.toString(), e);
            throw new JargonException(ERROR_IN_RESOURCE_QUERY);
        }
        return AccessObjectQueryProcessingUtils.buildAvuDataListFromResultSet(resultSet);
    }

    @Override
    public List<Resource> findWhere(String whereStatement) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (whereStatement == null) {
            throw new JargonException("null where statement");
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder sb = new StringBuilder();
        sb.append(this.resourceAOHelper.buildResourceSelects());
        if (whereStatement.isEmpty()) {
            this.log.debug("no where statement given, so will do plain select");
        } else {
            sb.append(" WHERE ");
            sb.append(whereStatement);
        }
        String queryString = sb.toString();
        if (this.log.isInfoEnabled()) {
            this.log.info("query: " + queryString);
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query:" + queryString, e);
            throw new JargonException(ERROR_IN_RESOURCE_QUERY);
        }
        return this.resourceAOHelper.buildResourceListFromResultSet(resultSet);
    }

    public List<Resource> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements) throws JargonQueryException, JargonException {
        return null;
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null || avuQuery.isEmpty()) {
            throw new JargonException("null or empty query");
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        this.log.info("building a metadata query for: {}", avuQuery);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_R_RESC_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_RESC_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_RESC_ATTR_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_RESC_ATTR_VALUE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_RESC_ATTR_UNITS.getName());
        query.append(" WHERE ");
        boolean previousElement = false;
        StringBuilder queryCondition = null;
        for (AVUQueryElement queryElement : avuQuery) {
            queryCondition = new StringBuilder();
            if (previousElement) {
                queryCondition.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)this.buildConditionPart(queryElement));
        }
        String queryString = query.toString();
        this.log.debug("query string for AVU query: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query:" + queryString, e);
            throw new JargonException(ERROR_IN_RESOURCE_QUERY);
        }
        return AccessObjectQueryProcessingUtils.buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain.RESOURCE, resultSet);
    }

    private StringBuilder buildConditionPart(AVUQueryElement queryElement) {
        StringBuilder queryCondition = new StringBuilder();
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.ATTRIBUTE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_RESC_ATTR_NAME.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.VALUE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_RESC_ATTR_VALUE.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.UNITS) {
            queryCondition.append(RodsGenQueryEnum.COL_META_RESC_ATTR_UNITS.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        return queryCondition;
    }
}

