/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.SimpleQueryInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.SimpleQueryExecutorAO;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.IRODSSimpleQueryResultSet;
import org.irods.jargon.core.query.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryExecutorAOImpl
extends IRODSGenericAO
implements SimpleQueryExecutorAO {
    private static final Logger log = LoggerFactory.getLogger(SimpleQueryExecutorAOImpl.class);
    public static final String OUT_BUF = "outBuf";

    protected SimpleQueryExecutorAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSQueryResultSetInterface executeSimpleQuery(SimpleQuery simpleQuery) throws JargonException {
        IRODSQueryResultRow irodsQueryResultRow;
        String thisCol;
        int i;
        String firstColName;
        int idx;
        if (simpleQuery == null) {
            throw new IllegalArgumentException("null simpleQuery");
        }
        log.info("executeSimpleQuery:{}", simpleQuery);
        SimpleQueryInp simpleQueryInp = SimpleQueryInp.instance(simpleQuery);
        Tag response = null;
        try {
            response = this.getIRODSProtocol().irodsFunction(simpleQueryInp);
        }
        catch (DataNotFoundException dnf) {
            log.info("no data found");
        }
        if (response == null) {
            log.info("response from IRODS call indicates no rows found");
            ArrayList<IRODSQueryResultRow> result = new ArrayList<IRODSQueryResultRow>();
            IRODSSimpleQueryResultSet resultSet = IRODSSimpleQueryResultSet.instance(simpleQuery, result, new ArrayList<String>(), false);
            return resultSet;
        }
        String rawResponse = response.getTag(OUT_BUF).getStringValue();
        ArrayList<IRODSQueryResultRow> result = new ArrayList<IRODSQueryResultRow>();
        String[] rows = rawResponse.split("\n");
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> colValues = new ArrayList<String>();
        if (rows.length >= 0) {
            idx = rows[0].indexOf(58);
            firstColName = rows[0].substring(0, idx);
            colNames.add(firstColName.trim());
            for (i = 1; i < rows.length && !(thisCol = rows[i].substring(0, idx = rows[i].indexOf(58)).trim()).equals(firstColName); ++i) {
                colNames.add(thisCol.trim());
            }
        }
        if (rows.length >= 0) {
            idx = rows[0].indexOf(58);
            firstColName = rows[0].substring(idx + 1).trim();
            colValues.add(rows[0].substring(idx + 1).trim());
            for (i = 1; i < rows.length; ++i) {
                idx = rows[i].indexOf(58);
                thisCol = rows[i].substring(0, idx).trim();
                if (thisCol.equals(firstColName) && colValues.size() > 0) {
                    irodsQueryResultRow = IRODSQueryResultRow.instance(colValues, colNames);
                    result.add(irodsQueryResultRow);
                    irodsQueryResultRow = null;
                    colValues = new ArrayList();
                }
                colValues.add(rows[i].substring(idx + 1).trim());
            }
        }
        if (!colValues.isEmpty()) {
            irodsQueryResultRow = IRODSQueryResultRow.instance(colValues, colNames);
            result.add(irodsQueryResultRow);
        }
        IRODSSimpleQueryResultSet resultSet = IRODSSimpleQueryResultSet.instance(simpleQuery, result, colNames, false);
        return resultSet;
    }
}

