/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.Stream2StreamAO;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileInputStream;
import org.irods.jargon.core.pub.io.IRODSFileOutputStream;
import org.irods.jargon.core.utils.ChannelTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stream2StreamAOImpl
extends IRODSGenericAO
implements Stream2StreamAO {
    private static final int bufferSize = 32768;
    public static final Logger log = LoggerFactory.getLogger(Stream2StreamAOImpl.class);

    public Stream2StreamAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public void streamBytesToIRODSFile(byte[] bytesToStream, IRODSFile irodsTargetFile) throws JargonException {
        if (bytesToStream == null || bytesToStream.length == 0) {
            throw new IllegalArgumentException("null or empty bytesToStream");
        }
        if (irodsTargetFile == null) {
            throw new IllegalArgumentException("null irodsTargetFile");
        }
        log.info("streamBytesToIRODSFile(), irodsFile:{}", irodsTargetFile);
        log.info("bytesToStream length:{}", bytesToStream.length);
        IRODSFileOutputStream ifOs = this.getIRODSFileFactory().instanceIRODSFileOutputStream(irodsTargetFile);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytesToStream);
        ReadableByteChannel inputChannel = Channels.newChannel(bis);
        WritableByteChannel outputChannel = Channels.newChannel(ifOs);
        try {
            ChannelTools.fastChannelCopy(inputChannel, outputChannel, 32768);
        }
        catch (IOException e) {
            log.error("IO Exception copying buffers", e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                inputChannel.close();
                outputChannel.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void transferStreamToFileUsingIOStreams(InputStream inputStream, File targetFile, long length, int readBuffSize) throws JargonException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null or empty inputStream");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        log.info("transferStreamToFile(), inputStream:{}", inputStream);
        log.info("targetFile:{}", targetFile);
        OutputStream fileOutputStream = null;
        try {
            int outputBufferSize = this.getJargonProperties().getLocalFileOutputStreamBufferSize();
            if (targetFile instanceof IRODSFile) {
                log.info("target file is an iRODS file");
                fileOutputStream = this.getIRODSFileFactory().instanceIRODSFileOutputStreamWithRerouting((IRODSFile)((Object)targetFile));
            } else {
                log.info("target file is a normal file");
                fileOutputStream = new FileOutputStream(targetFile);
            }
            log.debug("output buffer size for file output stream in copy:{}", outputBufferSize);
            if (outputBufferSize == -1) {
                log.info("no buffer on file output stream to local file");
            } else if (outputBufferSize == 0) {
                log.info("default buffered io to file output stream to local file");
                fileOutputStream = new BufferedOutputStream(fileOutputStream);
            } else {
                log.info("buffer io to file output stream to local file with size of: {}", outputBufferSize);
                fileOutputStream = new BufferedOutputStream(fileOutputStream, outputBufferSize);
            }
            int myBuffSize = readBuffSize;
            if (myBuffSize <= 0) {
                myBuffSize = this.getJargonProperties().getInputToOutputCopyBufferByteSize();
            }
            if (myBuffSize <= 0) {
                throw new JargonException("invalid stream to stream copy buffer size of {}", myBuffSize);
            }
            log.debug("using {} as copy buffer size", myBuffSize);
            int doneCnt = -1;
            byte[] buf = new byte[myBuffSize];
            while ((doneCnt = inputStream.read(buf, 0, myBuffSize)) >= 0) {
                if (doneCnt == 0) {
                    Thread.yield();
                    continue;
                }
                fileOutputStream.write(buf, 0, doneCnt);
            }
            fileOutputStream.flush();
        }
        catch (FileNotFoundException e) {
            log.error("File not found exception copying buffers", e);
            throw new JargonException("file not found exception copying buffers", e);
        }
        catch (IOException e) {
            log.error("IOException exception copying buffers", e);
            throw new JargonException("IOException copying buffers", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void streamToStreamCopy(InputStream inputStream, OutputStream outputStream) throws JargonException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null inputStream");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("null outputStream");
        }
        log.info("streamToStreamCopy()");
        ReadableByteChannel inputChannel = Channels.newChannel(inputStream);
        WritableByteChannel outputChannel = Channels.newChannel(outputStream);
        try {
            ChannelTools.fastChannelCopy(inputChannel, outputChannel, 32768);
        }
        catch (IOException e) {
            log.error("IO Exception copying buffers", e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                inputChannel.close();
                outputChannel.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public byte[] streamFileToByte(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsTargetFile");
        }
        log.info("streamFileToByte() file:{}", irodsFile);
        if (!irodsFile.exists() || !irodsFile.isFile()) {
            throw new JargonException("cannot stream, does not exist or is not a file");
        }
        log.info("verified as an existing data object");
        IRODSFileInputStream is = this.getIRODSFileFactory().instanceIRODSFileInputStream(irodsFile);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ReadableByteChannel inputChannel = Channels.newChannel(is);
        WritableByteChannel outputChannel = Channels.newChannel(bos);
        try {
            ChannelTools.fastChannelCopy(inputChannel, outputChannel, 32768);
        }
        catch (IOException e) {
            log.error("IO Exception copying buffers", e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                inputChannel.close();
                outputChannel.close();
            }
            catch (Exception e) {}
        }
        return bos.toByteArray();
    }

    @Override
    public void streamClasspathResourceToIRODSFile(String resourcePath, String irodsFileAbsolutePath) throws JargonException {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourcePath");
        }
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsFileAbsolutePath");
        }
        IRODSFile irodsTarget = this.getIRODSFileFactory().instanceIRODSFile(irodsFileAbsolutePath);
        irodsTarget.getParentFile().mkdirs();
        irodsTarget.delete();
        BufferedInputStream inputStream = new BufferedInputStream(this.getClass().getResourceAsStream(resourcePath));
        IRODSFileOutputStream irodsFileOutputStream = this.getIRODSFileFactory().instanceIRODSFileOutputStream(irodsFileAbsolutePath);
        byte[] buff = new byte[4096];
        try {
            int i = 0;
            while ((i = ((InputStream)inputStream).read(buff)) > -1) {
                irodsFileOutputStream.write(buff, 0, i);
            }
        }
        catch (IOException ioe) {
            log.error("io exception reading rule data from resource", ioe);
            throw new JargonException("error reading rule from resource", ioe);
        }
        finally {
            try {
                irodsFileOutputStream.close();
            }
            catch (IOException e) {}
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {}
        }
    }
}

