/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.OverwriteException;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.CollectionAOImpl;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.DataObjectAOImpl;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.Stream2StreamAO;
import org.irods.jargon.core.pub.Stream2StreamAOImpl;
import org.irods.jargon.core.pub.io.ByteCountingCallbackInputStreamWrapper;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileImpl;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransferOperationsHelper {
    static Logger log = LoggerFactory.getLogger(TransferOperationsHelper.class);
    private final DataObjectAO dataObjectAO;
    private final CollectionAO collectionAO;
    private final Stream2StreamAO stream2StreamAO;

    protected static final TransferOperationsHelper instance(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        return new TransferOperationsHelper(irodsSession, irodsAccount);
    }

    private TransferOperationsHelper(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        if (irodsSession == null || irodsAccount == null) {
            throw new JargonException("null irodsSession or irodsAccount");
        }
        this.dataObjectAO = new DataObjectAOImpl(irodsSession, irodsAccount);
        this.collectionAO = new CollectionAOImpl(irodsSession, irodsAccount);
        this.stream2StreamAO = new Stream2StreamAOImpl(irodsSession, irodsAccount);
    }

    protected void recursivelyGet(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        log.info("recursively getting source file: {}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("    into iRODS file: {}", (Object)targetLocalFile.getAbsolutePath());
        for (File fileInSourceCollection : irodsSourceFile.listFiles()) {
            ((IRODSFile)((Object)fileInSourceCollection)).setResource(irodsSourceFile.getResource());
            if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                log.info("transfer cancelled or paused");
                if (transferStatusCallbackListener != null) {
                    TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.GET, fileInSourceCollection.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", fileInSourceCollection.length(), fileInSourceCollection.length(), 0, 0, interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
            }
            if (fileInSourceCollection.isDirectory()) {
                StringBuilder sb = new StringBuilder();
                sb.append(targetLocalFile.getAbsolutePath());
                sb.append('/');
                sb.append(fileInSourceCollection.getName());
                log.info("recursively creating parent directory in local file system at: {}", (Object)sb.toString());
                File newSubCollection = new File(sb.toString());
                boolean success = newSubCollection.mkdirs();
                if (!success) {
                    log.warn("unable to make directories in local file system, log and proceed");
                }
                this.recursivelyGet((IRODSFileImpl)fileInSourceCollection, newSubCollection, transferStatusCallbackListener, transferControlBlock);
                continue;
            }
            this.processGetOfSingleFile((IRODSFileImpl)fileInSourceCollection, targetLocalFile, transferStatusCallbackListener, transferControlBlock);
        }
    }

    protected void processGetOfSingleFile(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        log.info("get of single file...filtered?");
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        totalFilesSoFar = transferControlBlock.incrementFilesTransferredSoFar();
        totalFiles = transferControlBlock.getTotalFilesToTransfer();
        if (!transferControlBlock.filter(irodsSourceFile.getAbsolutePath())) {
            log.info("file is filtered and discarded: {}", (Object)irodsSourceFile.getAbsolutePath());
            if (transferStatusCallbackListener != null) {
                TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", 0L, 0L, totalFilesSoFar, totalFiles, TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            return;
        }
        log.info("filter passed, process...");
        try {
            TransferStatus status;
            long sourceFileLength;
            if (transferStatusCallbackListener != null) {
                sourceFileLength = irodsSourceFile.length();
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", sourceFileLength, sourceFileLength, totalFilesSoFar, totalFiles, TransferStatus.TransferState.IN_PROGRESS_START_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            this.dataObjectAO.getDataObjectFromIrods(irodsSourceFile, targetLocalFile, transferControlBlock, transferStatusCallbackListener);
            if (transferStatusCallbackListener != null) {
                sourceFileLength = irodsSourceFile.length();
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", sourceFileLength, sourceFileLength, totalFilesSoFar, totalFiles, TransferStatus.TransferState.IN_PROGRESS_COMPLETE_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
        }
        catch (JargonException je) {
            log.error("exception in transfer", je);
            if (transferControlBlock != null) {
                transferControlBlock.reportErrorInTransfer();
                totalFiles = transferControlBlock.getTotalFilesToTransfer();
                totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
            }
            if (transferStatusCallbackListener != null) {
                log.warn("exception will be passed back to existing callback listener");
                TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", targetLocalFile.length(), targetLocalFile.length(), totalFilesSoFar, totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
    }

    protected void recursivelyPut(File sourceFile, IRODSFile targetIrodsCollection, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (!sourceFile.isDirectory()) {
            throw new JargonException("source file is not a directory, cannot recursively put");
        }
        log.info("recursively putting source file: {}", (Object)sourceFile.getAbsolutePath());
        log.info("    into iRODS file: {}", (Object)targetIrodsCollection.getAbsolutePath());
        log.info("     to resource:{}", (Object)targetIrodsCollection.getResource());
        for (File fileInSourceCollection : sourceFile.listFiles()) {
            if (transferControlBlock != null && (transferControlBlock.isCancelled() || transferControlBlock.isPaused())) {
                log.info("will notify pause or cancel for this put");
                this.notifyPauseOrCancelCallbackForPut(targetIrodsCollection, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection);
                break;
            }
            if (fileInSourceCollection.isDirectory()) {
                this.recursivelyPutACollection(targetIrodsCollection, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection);
                continue;
            }
            this.processPutOfSingleFile(fileInSourceCollection, targetIrodsCollection, transferStatusCallbackListener, transferControlBlock);
        }
    }

    private void notifyPauseOrCancelCallbackForPut(IRODSFile targetIrodsCollection, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection) throws JargonException {
        log.info("transfer cancelled or paused, signal with a callback");
        if (transferStatusCallbackListener != null) {
            TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
            TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.PUT, fileInSourceCollection.getAbsolutePath(), targetIrodsCollection.getAbsolutePath(), "", fileInSourceCollection.length(), fileInSourceCollection.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesToTransfer(), interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
            log.info("status callback for cancel:{}", status);
            transferStatusCallbackListener.statusCallback(status);
        }
    }

    private void processRecursivePutException(File fileInSourceCollection, TransferStatusCallbackListener transferStatusCallbackListener, IRODSFile newIrodsFile, TransferControlBlock transferControlBlock, JargonException je) throws JargonException {
        int totalFilesSoFar;
        int totalFiles;
        log.error("exception in transfer", je);
        if (transferStatusCallbackListener != null) {
            log.warn("exception will be passed back to existing callback listener");
            totalFiles = 0;
            totalFilesSoFar = 0;
            if (transferControlBlock != null) {
                transferControlBlock.reportErrorInTransfer();
                totalFiles = transferControlBlock.getTotalFilesToTransfer();
                totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
            }
        } else {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, fileInSourceCollection.getAbsolutePath(), newIrodsFile.getAbsolutePath(), "", fileInSourceCollection.length(), fileInSourceCollection.length(), totalFilesSoFar, totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
        log.info("status callback to be sent for error:{}", status);
        transferStatusCallbackListener.statusCallback(status);
    }

    private void recursivelyPutACollection(IRODSFile targetIrodsCollection, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection) throws OverwriteException, DataNotFoundException, JargonException {
        StringBuilder sb = new StringBuilder();
        sb.append(targetIrodsCollection.getAbsolutePath());
        sb.append('/');
        sb.append(fileInSourceCollection.getName());
        log.info("recursively creating parent directory in irods at: {}", (Object)sb.toString());
        IRODSFile newSubCollection = this.collectionAO.instanceIRODSFileForCollectionPath(sb.toString());
        newSubCollection.setResource(targetIrodsCollection.getResource());
        try {
            newSubCollection.mkdirs();
            this.recursivelyPut(fileInSourceCollection, newSubCollection, transferStatusCallbackListener, transferControlBlock);
        }
        catch (JargonException je) {
            this.processRecursivePutException(fileInSourceCollection, transferStatusCallbackListener, newSubCollection, transferControlBlock, je);
        }
    }

    protected void recursivelyReplicate(IRODSFile sourceFile, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        if (!sourceFile.isDirectory()) {
            throw new JargonException("source file is not a directory, cannot recursively replicate");
        }
        log.info("recursively replicating source file: {}", (Object)sourceFile.getAbsolutePath());
        log.info("    into resource: {}", (Object)targetResource);
        for (File fileInSourceCollection : sourceFile.listFiles()) {
            if (transferControlBlock != null && (transferControlBlock.isCancelled() || transferControlBlock.isPaused())) {
                log.info("transfer cancelled or paused");
                if (transferStatusCallbackListener != null) {
                    TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, fileInSourceCollection.getAbsolutePath(), "", targetResource, fileInSourceCollection.length(), fileInSourceCollection.length(), 0, 0, interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
            }
            if (fileInSourceCollection.isDirectory()) {
                this.replicateWhenADirectory(targetResource, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection);
                if (transferControlBlock == null || !transferControlBlock.isCancelled() && !transferControlBlock.isPaused()) continue;
                log.info("returning, is paused or cancelled");
                break;
            }
            this.processReplicationOfSingleFile(fileInSourceCollection.getAbsolutePath(), targetResource, transferStatusCallbackListener, transferControlBlock);
        }
    }

    private void replicateWhenADirectory(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection) throws JargonException {
        try {
            this.recursivelyReplicate((IRODSFile)((Object)fileInSourceCollection), targetResource, transferStatusCallbackListener, transferControlBlock);
        }
        catch (Exception je) {
            this.notifyReplicationTransferException(targetResource, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection, je);
        }
    }

    private void notifyReplicationTransferException(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection, Exception je) throws JargonException {
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        if (transferControlBlock != null) {
            transferControlBlock.reportErrorInTransfer();
            totalFiles = transferControlBlock.getTotalFilesToTransfer();
            totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
        }
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.REPLICATE, fileInSourceCollection.getAbsolutePath(), "", targetResource, fileInSourceCollection.length(), fileInSourceCollection.length(), totalFilesSoFar, totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
        transferStatusCallbackListener.statusCallback(status);
    }

    protected void processPutOfSingleFile(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        log.info("put of single file");
        if (sourceFile == null) {
            throw new IllegalArgumentException("null sourceFile");
        }
        if (targetIrodsFile == null) {
            throw new IllegalArgumentException("null targetIrodsFile");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        try {
            TransferStatus status;
            int totalFiles = transferControlBlock.getTotalFilesToTransfer();
            int totalFilesSoFar = transferControlBlock.incrementFilesTransferredSoFar();
            if (!transferControlBlock.filter(sourceFile.getAbsolutePath())) {
                log.debug("file filtered and not transferred");
                TransferStatus status2 = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetIrodsFile.getAbsolutePath(), "", 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status2);
                return;
            }
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource(), sourceFile.length(), sourceFile.length(), totalFilesSoFar, totalFiles, TransferStatus.TransferState.IN_PROGRESS_START_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            this.dataObjectAO.putLocalDataObjectToIRODS(sourceFile, targetIrodsFile, transferControlBlock, transferStatusCallbackListener);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource(), sourceFile.length(), sourceFile.length(), totalFilesSoFar, totalFiles, TransferStatus.TransferState.IN_PROGRESS_COMPLETE_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
        }
        catch (JargonException je) {
            log.error("exception in transfer", je);
            int totalFiles = 0;
            int totalFilesSoFar = 0;
            if (transferControlBlock != null) {
                transferControlBlock.reportErrorInTransfer();
                totalFiles = transferControlBlock.getTotalFilesToTransfer();
                totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
            }
            if (transferStatusCallbackListener != null) {
                log.warn("exception will be passed back to existing callback listener");
                TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource(), sourceFile.length(), targetIrodsFile.length(), totalFilesSoFar, totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
    }

    protected void processReplicationOfSingleFile(String irodsFileAbsolutePath, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        log.info("replicate single file");
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        if (transferControlBlock != null) {
            totalFilesSoFar = transferControlBlock.incrementFilesTransferredSoFar();
            totalFiles = transferControlBlock.getTotalFilesToTransfer();
            if (!transferControlBlock.filter(irodsFileAbsolutePath)) {
                log.info("file is filtered and discarded: {}", (Object)irodsFileAbsolutePath);
                TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, irodsFileAbsolutePath, "", targetResource, 0L, 0L, totalFilesSoFar, totalFiles, TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
                return;
            }
        }
        log.info("filter passed, process...");
        try {
            this.dataObjectAO.replicateIrodsDataObject(irodsFileAbsolutePath, targetResource);
            log.info("replicate successful for file: {}", (Object)irodsFileAbsolutePath);
            if (transferStatusCallbackListener != null) {
                TransferStatus transferStatus = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, irodsFileAbsolutePath, "", targetResource, 0L, 0L, totalFilesSoFar, totalFiles, TransferStatus.TransferState.SUCCESS, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(transferStatus);
            }
        }
        catch (JargonException e) {
            log.error("exception in transfer", e);
            if (transferControlBlock != null) {
                transferControlBlock.reportErrorInTransfer();
            }
            if (transferStatusCallbackListener != null) {
                log.warn("exception will be passed back to existing callback listener");
                TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.REPLICATE, irodsFileAbsolutePath, "", targetResource, 0L, 0L, totalFilesSoFar, totalFiles, e, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw e;
        }
    }

    protected void recursivelyCopy(IRODSFile irodsSourceFile, String targetResource, String targetIrodsFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (!irodsSourceFile.isDirectory()) {
            throw new JargonException("source file is not a directory, cannot recursively copy");
        }
        log.info("recursively copying source file: {}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("to target file: {}", (Object)targetIrodsFileAbsolutePath);
        log.info("resource: {}", (Object)targetResource);
        IRODSFile childTargetFile = null;
        for (File fileInSourceCollection : irodsSourceFile.listFiles()) {
            if (transferControlBlock != null && (transferControlBlock.isCancelled() || transferControlBlock.isPaused())) {
                log.info("transfer cancelled or paused");
                if (transferStatusCallbackListener != null) {
                    TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.COPY, fileInSourceCollection.getAbsolutePath(), targetIrodsFileAbsolutePath, targetResource, fileInSourceCollection.length(), fileInSourceCollection.length(), 0, 0, interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
            }
            if (fileInSourceCollection.isDirectory()) {
                log.debug("source is a collection, create the target");
                StringBuilder targetCollectionName = new StringBuilder(targetIrodsFileAbsolutePath);
                targetCollectionName.append("/");
                targetCollectionName.append(fileInSourceCollection.getName());
                String targetCollection = targetCollectionName.toString();
                childTargetFile = this.collectionAO.instanceIRODSFileForCollectionPath(targetCollection);
                childTargetFile.mkdirs();
                this.recursivelyCopy((IRODSFileImpl)fileInSourceCollection, targetResource, targetCollection, transferStatusCallbackListener, transferControlBlock);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(targetIrodsFileAbsolutePath);
            sb.append("/");
            sb.append(fileInSourceCollection.getName());
            this.processCopyOfSingleFile(fileInSourceCollection.getAbsolutePath(), targetResource, sb.toString(), transferStatusCallbackListener, transferControlBlock);
        }
    }

    protected void processCopyOfSingleFile(String irodsSourceFileAbsolutePath, String targetResource, String irodsTargetFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        log.info("copy single file");
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        try {
            if (transferControlBlock != null) {
                totalFilesSoFar = transferControlBlock.incrementFilesTransferredSoFar();
                totalFiles = transferControlBlock.getTotalFilesToTransfer();
                if (!transferControlBlock.filter(irodsSourceFileAbsolutePath)) {
                    log.info("file is filtered and discarded: {}", (Object)irodsTargetFileAbsolutePath);
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.COPY, irodsSourceFileAbsolutePath, irodsTargetFileAbsolutePath, targetResource, 0L, 0L, totalFilesSoFar, totalFiles, TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
            }
            log.info("filter passed, process...");
            IRODSFile irodsSourceFile = this.dataObjectAO.getIRODSFileFactory().instanceIRODSFile(irodsSourceFileAbsolutePath);
            IRODSFile irodsTargetFile = this.dataObjectAO.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
            irodsTargetFile.setResource(targetResource);
            this.dataObjectAO.copyIRODSDataObject(irodsSourceFile, irodsTargetFile, transferControlBlock, transferStatusCallbackListener);
            log.info("copy successful for file: {}", (Object)irodsSourceFileAbsolutePath);
            if (transferStatusCallbackListener != null) {
                TransferStatus transferStatus = TransferStatus.instance(TransferStatus.TransferType.COPY, irodsSourceFileAbsolutePath, irodsTargetFileAbsolutePath, targetResource, 0L, 0L, totalFilesSoFar, totalFiles, TransferStatus.TransferState.SUCCESS, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(transferStatus);
            }
        }
        catch (JargonException e) {
            log.error("exception in transfer", e);
            if (transferControlBlock != null) {
                transferControlBlock.reportErrorInTransfer();
            }
            if (transferStatusCallbackListener != null) {
                log.warn("exception will be passed back to existing callback listener");
                TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.COPY, irodsSourceFileAbsolutePath, irodsTargetFileAbsolutePath, targetResource, 0L, 0L, totalFilesSoFar, totalFiles, e, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw e;
        }
    }

    protected void processPutOfURL(String sourceURL, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        log.info("put of an url");
        if (sourceURL == null) {
            throw new IllegalArgumentException("null sourceURL");
        }
        if (targetIrodsFile == null) {
            throw new IllegalArgumentException("null targetIrodsFile");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        URL url = null;
        URLConnection connection = null;
        BufferedInputStream inStream = null;
        int urlSize = 0;
        try {
            url = new URL(sourceURL);
            connection = url.openConnection();
            urlSize = connection.getContentLength();
            inStream = new BufferedInputStream(url.openStream());
        }
        catch (MalformedURLException e) {
            log.error("Cannot get size of specified URL: {}", (Object)sourceURL);
            e.printStackTrace();
            throw new IllegalArgumentException("invalid URL");
        }
        catch (IOException e) {
            log.error("Cannot get size of specified URL: {}", (Object)sourceURL);
            e.printStackTrace();
            throw new IllegalArgumentException("invalid URL");
        }
        try {
            int totalFiles = 0;
            int totalFilesSoFar = 0;
            totalFilesSoFar = transferControlBlock.incrementFilesTransferredSoFar();
            totalFiles = transferControlBlock.getTotalFilesToTransfer();
            if (transferStatusCallbackListener != null) {
                TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceURL, targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource(), urlSize, urlSize, totalFilesSoFar, totalFiles, TransferStatus.TransferState.IN_PROGRESS_START_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            InputStream transferStream = inStream;
            if (transferStatusCallbackListener != null) {
                log.info("setting up a callback listener for within stream progress");
                ConnectionProgressStatusListener listener = DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.PUT, urlSize, transferControlBlock, transferStatusCallbackListener);
                transferStream = new ByteCountingCallbackInputStreamWrapper(listener, transferStream);
            }
            this.stream2StreamAO.transferStreamToFileUsingIOStreams(transferStream, (File)((Object)targetIrodsFile), urlSize, 0);
            if (transferStatusCallbackListener != null) {
                TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceURL, targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource(), urlSize, urlSize, totalFilesSoFar, totalFiles, TransferStatus.TransferState.IN_PROGRESS_COMPLETE_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
        }
        catch (Exception je) {
            log.error("exception in transfer", je);
            int totalFiles = 0;
            int totalFilesSoFar = 0;
            if (transferControlBlock != null) {
                transferControlBlock.reportErrorInTransfer();
                totalFiles = transferControlBlock.getTotalFilesToTransfer();
                totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
            }
            if (transferStatusCallbackListener != null) {
                log.error("exception will be passed back to existing callback listener");
                TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, sourceURL, targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource(), urlSize, targetIrodsFile.length(), totalFilesSoFar, totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
            }
            log.error("exception will be re-thrown, as there is no status callback listener");
            throw new JargonException("exception thrown in transfer process, no callback listener supplied", je);
        }
    }
}

