/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.aohelper;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;

public class UserAOHelper {
    private static final char COMMA = ',';

    public static String buildUserSelects() {
        StringBuilder userQuery = new StringBuilder();
        userQuery.append("select ");
        userQuery.append(RodsGenQueryEnum.COL_USER_ZONE.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_ID.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_TYPE.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_INFO.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_COMMENT.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_CREATE_TIME.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_MODIFY_TIME.getName());
        return userQuery.toString();
    }

    public static User buildUserFromResultSet(IRODSQueryResultRow row, IRODSGenQueryExecutor irodsGenQueryExecutor, boolean retrieveDN) throws JargonException {
        String userDn;
        String homeZone = irodsGenQueryExecutor.getIRODSAccount().getZone();
        User user = new User();
        user.setId(row.getColumn(2));
        user.setName(row.getColumn(1));
        user.setUserType(UserTypeEnum.findTypeByString(row.getColumn(3)));
        user.setZone(row.getColumn(0));
        user.setInfo(row.getColumn(4));
        user.setComment(row.getColumn(5));
        user.setCreateTime(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(6)));
        user.setModifyTime(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(7)));
        if (user.getZone().equals(homeZone)) {
            user.setNameWithZone(user.getName());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(user.getName());
            sb.append('#');
            sb.append(user.getZone());
            user.setNameWithZone(sb.toString());
        }
        if (retrieveDN && (userDn = UserAOHelper.findUserDnIfExists(user.getId(), irodsGenQueryExecutor)) != null) {
            user.setUserDN(userDn);
        }
        return user;
    }

    public static String findUserDnIfExists(String userId, IRODSGenQueryExecutor irodsGenQueryExecutor) throws JargonException {
        IRODSQueryResultSet resultSet;
        String dn = null;
        StringBuilder userQuery = new StringBuilder();
        userQuery.append("select ");
        userQuery.append(RodsGenQueryEnum.COL_USER_ID.getName());
        userQuery.append(',');
        userQuery.append(RodsGenQueryEnum.COL_USER_DN.getName());
        userQuery.append(" where ");
        userQuery.append(RodsGenQueryEnum.COL_USER_ID.getName());
        userQuery.append(" = '");
        userQuery.append(userId);
        userQuery.append("'");
        String userQueryString = userQuery.toString();
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(userQueryString, 500);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 500);
        }
        catch (JargonQueryException e) {
            throw new JargonException(e);
        }
        if (resultSet.getResults().size() == 0) {
            return null;
        }
        if (resultSet.getResults().size() > 1) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("more than one user dn found for id:");
            messageBuilder.append(userId);
            String message = messageBuilder.toString();
            throw new JargonException(message);
        }
        IRODSQueryResultRow row = resultSet.getResults().get(0);
        dn = row.getColumn(1);
        return dn;
    }

    public static String getUserNameFromUserPoundZone(String userName) {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        int poundIdx = userName.indexOf("#");
        if (poundIdx > -1) {
            return userName.substring(0, poundIdx);
        }
        return userName;
    }

    public static String getZoneFromUserPoundZone(String userName) {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        int poundIdx = userName.indexOf("#");
        if (poundIdx > -1) {
            return userName.substring(poundIdx + 1);
        }
        return "";
    }
}

