/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.domain;

import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.protovalues.UserTypeEnum;

public class UserFilePermission {
    private String userName = "";
    private String userZone = "";
    private String userId = "";
    private UserTypeEnum userType = UserTypeEnum.RODS_UNKNOWN;
    private FilePermissionEnum filePermissionEnum;

    public UserFilePermission(String userName, String userId, FilePermissionEnum filePermissionEnum, UserTypeEnum userType) {
        this(userName, userId, filePermissionEnum, userType, "");
    }

    public UserFilePermission(String userName, String userId, FilePermissionEnum filePermissionEnum, UserTypeEnum userType, String userZone) {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("null or empty userId");
        }
        if (filePermissionEnum == null) {
            throw new IllegalArgumentException("null filePermissionEnum");
        }
        if (userType == null) {
            throw new IllegalArgumentException("null userType");
        }
        if (userZone == null) {
            throw new IllegalArgumentException("null userZone");
        }
        this.userName = userName;
        this.userId = userId;
        this.filePermissionEnum = filePermissionEnum;
        this.userType = userType;
        this.userZone = userZone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nUserFilePermission");
        sb.append("\n    userName:");
        sb.append(this.userName);
        sb.append("\n    userId:");
        sb.append(this.userId);
        sb.append("\n    filePermissionEnum:");
        sb.append((Object)this.filePermissionEnum);
        sb.append("\n   userType:");
        sb.append((Object)this.userType);
        sb.append("\n   userZone:");
        sb.append(this.userZone);
        return sb.toString();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public FilePermissionEnum getFilePermissionEnum() {
        return this.filePermissionEnum;
    }

    public void setFilePermissionEnum(FilePermissionEnum filePermissionEnum) {
        this.filePermissionEnum = filePermissionEnum;
    }

    public synchronized UserTypeEnum getUserType() {
        return this.userType;
    }

    public synchronized void setUserType(UserTypeEnum userType) {
        this.userType = userType;
    }

    public String getUserZone() {
        return this.userZone;
    }

    public void setUserZone(String userZone) {
        this.userZone = userZone;
    }

    public String getConcatenatedUserAndZone(String homeZoneName) {
        StringBuilder sb = new StringBuilder(this.userName);
        if (!this.userZone.isEmpty()) {
            if (homeZoneName == null || homeZoneName.isEmpty()) {
                sb.append('#');
                sb.append(this.userZone);
            } else if (!homeZoneName.equals(this.userZone)) {
                sb.append('#');
                sb.append(this.userZone);
            }
        }
        return sb.toString();
    }
}

