/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.domain.ObjStat;

public interface IRODSFile {
    public static final char PATH_SEPARATOR_CHAR = '/';
    public static final String PATH_SEPARATOR = "/";
    public static final int PATH_IS_UNKNOWN = 0;
    public static final int PATH_IS_FILE = 1;
    public static final int PATH_IS_DIRECTORY = 2;
    public static final int READ_PERMISSIONS = 1050;
    public static final int WRITE_PERMISSIONS = 1120;
    public static final int OWN_PERMISSIONS = 1200;
    public static final String IRODS_ROOT = "/";

    public boolean canRead();

    public boolean canWrite();

    public boolean canExecute();

    public boolean createNewFile() throws IOException;

    public boolean delete();

    public void deleteOnExit();

    public boolean equals(Object var1);

    public boolean exists();

    public File getAbsoluteFile();

    public String getAbsolutePath();

    public File getCanonicalFile() throws IOException;

    public String getCanonicalPath() throws IOException;

    public long getFreeSpace();

    public File getParentFile();

    public long getTotalSpace();

    public long getUsableSpace();

    public int hashCode();

    public boolean isAbsolute();

    public boolean isDirectory();

    public boolean isFile();

    public String getPath();

    public boolean isHidden();

    public long lastModified();

    public long length();

    public String[] list();

    public String[] list(FilenameFilter var1);

    public File[] listFiles();

    public File[] listFiles(FileFilter var1);

    public File[] listFiles(FilenameFilter var1);

    public boolean mkdir();

    public boolean mkdirs();

    public boolean setExecutable(boolean var1, boolean var2);

    public boolean setExecutable(boolean var1);

    public boolean setLastModified(long var1);

    public boolean setReadable(boolean var1, boolean var2);

    public boolean setReadable(boolean var1);

    public boolean setReadOnly();

    public boolean setWritable(boolean var1, boolean var2);

    public boolean setWritable(boolean var1);

    public String toString();

    public URI toURI();

    public String getResource() throws JargonException;

    public void setResource(String var1);

    public String getName();

    public String getParent();

    public int getFileDescriptor();

    public int open() throws JargonException;

    public int openReadOnly() throws JargonException;

    public void close() throws JargonException;

    public int compareTo(IRODSFile var1);

    public boolean renameTo(IRODSFile var1);

    public boolean deleteWithForceOption();

    public void reset();

    public void closeGivenDescriptor(int var1) throws JargonException;

    public ObjStat initializeObjStatForFile() throws FileNotFoundException, JargonException;
}

