/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.pub.io.FileIOOperations;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSFileOutputStream
extends OutputStream {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final IRODSFile irodsFile;
    private final FileIOOperations fileIOOperations;

    protected FileIOOperations getFileIOOperations() {
        return this.fileIOOperations;
    }

    protected IRODSFileOutputStream(IRODSFile irodsFile, FileIOOperations fileIOOperations) throws FileNotFoundException, JargonException {
        this.checkFileParameter(irodsFile);
        if (fileIOOperations == null) {
            throw new JargonRuntimeException("fileIOOperations is null");
        }
        this.irodsFile = irodsFile;
        this.openIRODSFile();
        this.fileIOOperations = fileIOOperations;
    }

    private int openIRODSFile() throws JargonException {
        int fileDescriptor = -1;
        if (!this.irodsFile.exists()) {
            try {
                this.irodsFile.createNewFile();
                if (this.irodsFile.getFileDescriptor() == -1) {
                    String msg = "no file descriptor returned from file creation";
                    this.log.error(msg);
                    throw new JargonException(msg);
                }
                fileDescriptor = this.irodsFile.getFileDescriptor();
            }
            catch (IOException e) {
                this.log.error("error creating file: {}", this, (Object)e);
                throw new JargonException("IOException rethrown as Jargon exception when creating file:" + this.irodsFile, e);
            }
        } else {
            this.log.info("opening the file");
            fileDescriptor = this.irodsFile.open();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("file descriptor from open/create operation = {}", fileDescriptor);
        }
        this.irodsFile.reset();
        return fileDescriptor;
    }

    private void checkFileParameter(IRODSFile file) throws JargonRuntimeException {
        if (file == null) {
            String msg = "file is null";
            this.log.error(msg);
            throw new JargonRuntimeException(msg);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.irodsFile.close();
        }
        catch (JargonException e) {
            String msg = "JargonException caught in constructor, rethrow as IOException";
            this.log.error(msg, e);
            throw new IOException(msg, e);
        }
    }

    private void checkIfOpen() throws IOException {
        if (this.irodsFile.getFileDescriptor() == -1) {
            this.log.debug("this file is not open, will throw an IOException");
            throw new IOException("operation attempted on unopened file:" + this.irodsFile.getAbsolutePath());
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkIfOpen();
        try {
            this.fileIOOperations.write(this.getFileDescriptor(), b, off, len);
        }
        catch (JargonException e) {
            this.log.error("rethrowing JargonException as IO exception for write operation", e);
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkIfOpen();
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIfOpen();
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer, 0, buffer.length);
    }

    public int getFileDescriptor() {
        return this.irodsFile.getFileDescriptor();
    }
}

