/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSFileReader
extends Reader {
    private final transient IRODSFileInputStream irodsFileInputStream;
    public static Logger log = LoggerFactory.getLogger(IRODSFileReader.class);
    private final String connectionEncoding;

    public IRODSFileReader(IRODSFile irodsFile, IRODSFileFactory irodsFileFactory) throws IOException {
        if (irodsFile == null) {
            throw new JargonRuntimeException("irodsFile Is null");
        }
        if (irodsFileFactory == null) {
            throw new JargonRuntimeException("irodsFileFactory is null");
        }
        try {
            this.irodsFileInputStream = irodsFileFactory.instanceIRODSFileInputStream(irodsFile);
        }
        catch (JargonException e) {
            throw new IOException("unable to open IRODSFileInputStream for:" + irodsFile.getAbsolutePath());
        }
        this.connectionEncoding = this.irodsFileInputStream.getFileIOOperations().getIRODSSession().buildPipelineConfigurationBasedOnJargonProperties().getDefaultEncoding();
    }

    @Override
    public void close() throws IOException {
        log.info("closing irodsFileReader");
        this.irodsFileInputStream.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        byte[] b = new byte[cbuf.length];
        int lenFromIrods = this.irodsFileInputStream.read(b, 0, len);
        log.debug("reader acutally read {} bytes from iRODS", lenFromIrods);
        if (lenFromIrods == -1) {
            return -1;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(b, 0, lenFromIrods);
        InputStreamReader isr = new InputStreamReader((InputStream)bais, this.connectionEncoding);
        int dataRead = isr.read(cbuf, off, len);
        log.debug("after decoding returning length {}", dataRead);
        return dataRead;
    }
}

