/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.aohelper.AOHelper;
import org.irods.jargon.core.pub.aohelper.CollectionAOHelper;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSFileSystemAOHelper
extends AOHelper {
    static Logger log = LoggerFactory.getLogger(IRODSFileSystemAOHelper.class);

    public static String buildQueryListAllCollections(String path) throws JargonException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(CollectionAOHelper.buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_PARENT_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(path));
        query.append("'");
        if (log.isDebugEnabled()) {
            log.debug("query for dirs:" + query.toString());
        }
        return query.toString();
    }

    public static String buildQueryListAllDataObjectsWithSizeAndDateInfo(String path) throws JargonException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT DISTINCT ");
        query.append(IRODSFileSystemAOHelper.buildDataObjectQuerySelects());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(path));
        query.append("'");
        if (log.isDebugEnabled()) {
            log.debug("query for files:" + query.toString());
        }
        return query.toString();
    }

    public static String buildQueryListAllDataObjectsWithUserAccessInfo(String path) throws JargonException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT DISTINCT ");
        query.append(IRODSFileSystemAOHelper.buildDataObjectQuerySelects());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_ACCESS_USER_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_ACCESS_TYPE.getName());
        query.append(",");
        query.append(RodsGenQueryEnum.COL_USER_TYPE.getName());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(path));
        query.append("'");
        if (log.isDebugEnabled()) {
            log.debug("query for files:" + query.toString());
        }
        return query.toString();
    }

    public static String buildDataObjectQuerySelects() {
        StringBuilder query = new StringBuilder();
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_CREATE_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_MODIFY_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_DATA_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_SIZE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_REPL_NUM.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_OWNER_NAME.getName());
        return query.toString();
    }

    public static String buildQueryListAllFiles(String path) throws JargonException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT DISTINCT ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(path));
        query.append("'");
        log.debug("query for files:{}", (Object)query.toString());
        return query.toString();
    }

    public static String buildQueryListAllDirsWithUserAccessInfo(String path) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(CollectionAOHelper.buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_TYPE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ZONE.getName());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_PARENT_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(path));
        query.append("'");
        log.debug("query for dirs:{}", (Object)query.toString());
        return query.toString();
    }
}

