/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.io.FileIOOperations;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileImpl;
import org.irods.jargon.core.utils.BinaryDataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSRandomAccessFile
implements DataInput,
DataOutput {
    private static Logger log = LoggerFactory.getLogger(IRODSFileImpl.class);
    private final FileIOOperations fileIOOperations;
    private final IRODSFile irodsFile;
    private long filePointer = 0L;
    private BinaryDataFormat fileFormat = new BinaryDataFormat();

    protected IRODSRandomAccessFile(IRODSFile irodsFile, FileIOOperations fileIOOperations) throws JargonException {
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        if (!irodsFile.exists()) {
            throw new JargonException("the file does not exist:" + irodsFile.getAbsolutePath());
        }
        if (!irodsFile.isFile()) {
            throw new JargonException("this is not a file:" + irodsFile.getAbsolutePath());
        }
        if (fileIOOperations == null) {
            throw new JargonException("fileIOOperations is null");
        }
        this.irodsFile = irodsFile;
        this.fileIOOperations = fileIOOperations;
    }

    public void readBooleans(boolean[] values, int nValues) throws EOFException, IOException {
        byte[] bytes = new byte[nValues];
        this.readFully(bytes, 0, nValues);
        for (int i = 0; i < nValues; ++i) {
            values[i] = bytes[i] != 0;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public char readChar() throws IOException {
        int t;
        int s = this.read();
        if ((s | (t = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((s << 8) + (t << 0));
    }

    @Override
    public double readDouble() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getDoubleSize());
        return this.fileFormat.doubleValue(bytes);
    }

    @Override
    public float readFloat() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getFloatSize());
        return this.fileFormat.floatValue(bytes);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int offset, int len) throws IOException {
        int count;
        int inc = 0;
        do {
            if ((count = this.read(b, offset + inc, len - inc)) >= 0) continue;
            throw new EOFException();
        } while ((inc += count) < len);
    }

    @Override
    public int readInt() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getIntSize());
        return this.fileFormat.intValue(bytes);
    }

    @Override
    public String readLine() throws IOException {
        char ch = (char)this.read();
        StringBuffer line = new StringBuffer();
        while (ch != '\n' && ch != '\r' && ch != '\uffff') {
            line.append(ch);
            ch = (char)this.read();
        }
        if (ch == '\r' && this.read() != 10) {
            this.seek(this.getFilePointer(), null);
        } else if (line.length() == 0) {
            return null;
        }
        return line.toString();
    }

    @Override
    public long readLong() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getLongSize());
        return this.fileFormat.longValue(bytes);
    }

    @Override
    public short readShort() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getShortSize());
        return this.fileFormat.shortValue(bytes);
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int value = this.read();
        if (value < 0) {
            throw new EOFException();
        }
        return value;
    }

    @Override
    public int readUnsignedShort() throws IOException, EOFException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getShortSize());
        return this.fileFormat.unsignedShortValue(bytes);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long length;
        if (n <= 0) {
            return 0;
        }
        long position = this.getFilePointer();
        long newPosition = position + (long)n;
        if (newPosition > (length = this.length())) {
            newPosition = length;
        }
        this.seek(newPosition, FileIOOperations.SeekWhenceType.SEEK_CURRENT);
        return (int)(newPosition - position);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.writeBytes(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.writeBytes(b, offset, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writeBytes(s.getBytes(), 0, s.length());
    }

    @Override
    public void writeChar(int v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeShort(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] chars = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(chars[i]);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeDouble(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeFloat(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    @Override
    public void writeInt(int v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeInt(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    @Override
    public void writeLong(long v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeLong(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    @Override
    public void writeShort(int v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeShort(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        byte[] buffer = null;
        int i = 0;
        char n = '\u0000';
        int m = 0;
        int length = str.length();
        int utflength = 0;
        for (i = 0; i < length; ++i) {
            n = str.charAt(i);
            if (n >= '\u0001' && n <= '\u007f') {
                ++utflength;
                continue;
            }
            if (n > '\u07ff') {
                utflength += 3;
                continue;
            }
            utflength += 2;
        }
        if (utflength > 65535) {
            throw new UTFDataFormatException("UTF string is " + utflength + " bytes; max 65535.");
        }
        buffer = new byte[utflength + 2];
        buffer[m++] = (byte)(utflength >>> 8 & 0xFF);
        buffer[m++] = (byte)(utflength >>> 0 & 0xFF);
        while (i < length) {
            n = str.charAt(i);
            if (n >= '\u0001' && n <= '\u007f') {
                buffer[m++] = (byte)n;
            } else if (n > '\u07ff') {
                buffer[m++] = (byte)(0xE0 | n >> 12 & 0xF);
                buffer[m++] = (byte)(0x80 | n >> 6 & 0x3F);
                buffer[m++] = (byte)(0x80 | n >> 0 & 0x3F);
            } else {
                buffer[m++] = (byte)(0xC0 | n >> 6 & 0x1F);
                buffer[m++] = (byte)(0x80 | n >> 0 & 0x3F);
            }
            ++i;
        }
        this.write(buffer, 0, utflength + 2);
    }

    public int read() throws IOException {
        int read;
        byte[] buffer = new byte[1];
        int offset = 0;
        try {
            read = this.fileIOOperations.fileRead(this.irodsFile.getFileDescriptor(), buffer, offset, 1);
        }
        catch (JargonException e) {
            log.error("JargonException reading file", e);
            throw new IOException(e);
        }
        if (read == 1 && buffer != null) {
            ++this.filePointer;
            return buffer[0];
        }
        return -1;
    }

    protected int readBytes(byte[] buffer, int offset, int len) throws IOException {
        int read;
        try {
            read = this.fileIOOperations.fileRead(this.irodsFile.getFileDescriptor(), buffer, offset, len);
        }
        catch (JargonException e) {
            log.error("JargonException reading file", e);
            throw new IOException(e);
        }
        this.filePointer += (long)read;
        return read;
    }

    protected void writeBytes(byte[] buffer, int offset, int len) throws IOException {
        try {
            this.filePointer += (long)this.fileIOOperations.write(this.irodsFile.getFileDescriptor(), buffer, offset, len);
        }
        catch (JargonException e) {
            log.error("JargonException reading file", e);
            throw new IOException(e);
        }
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long position, FileIOOperations.SeekWhenceType origin) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        try {
            this.fileIOOperations.seek(this.irodsFile.getFileDescriptor(), position, origin);
        }
        catch (JargonException e) {
            log.error("JargonException reading file", e);
            throw new IOException(e);
        }
        this.filePointer = position;
    }

    public int read(byte[] b, int offset, int len) throws IOException {
        return this.readBytes(b, offset, len);
    }

    public long length() throws IOException {
        return this.irodsFile.length();
    }

    @Override
    public boolean readBoolean() throws IOException {
        int value = this.read();
        if (value < 0) {
            throw new EOFException();
        }
        return value != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int value = this.read();
        if (value < 0) {
            throw new EOFException();
        }
        return (byte)value;
    }

    public void close() throws IOException {
        try {
            log.debug("closing: {}", (Object)this.irodsFile.getAbsolutePath());
            this.irodsFile.close();
        }
        catch (JargonException e) {
            log.error("JargonException reading file", e);
            throw new IOException(e);
        }
    }
}

