/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.domain.IRODSDomainObject;
import org.irods.jargon.core.pub.domain.UserFilePermission;

public class CollectionAndDataObjectListingEntry
extends IRODSDomainObject
implements Comparable<CollectionAndDataObjectListingEntry> {
    private String parentPath = "";
    private String pathOrName = "";
    private ObjectType objectType = null;
    private Date createdAt = null;
    private Date modifiedAt = null;
    private long dataSize = 0L;
    private String ownerName = "";
    private String ownerZone = "";
    private List<UserFilePermission> userFilePermission = new ArrayList<UserFilePermission>();
    private int id;

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public String getLastPathComponentForCollectionName() throws JargonException {
        if (this.objectType != ObjectType.COLLECTION) {
            throw new JargonException("this is not a collection, cannot get last component for collection name");
        }
        String[] paths = this.pathOrName.split("/");
        if (paths.length == 0) {
            return "";
        }
        return paths[paths.length - 1];
    }

    public String getPathOrName() {
        return this.pathOrName;
    }

    public void setPathOrName(String pathOrName) {
        this.pathOrName = pathOrName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CollectionAndDataObjectListingEntry)) {
            return false;
        }
        CollectionAndDataObjectListingEntry otherEntry = (CollectionAndDataObjectListingEntry)obj;
        return otherEntry.parentPath.equals(this.parentPath) && otherEntry.pathOrName.equals(this.pathOrName);
    }

    public int hashCode() {
        return this.parentPath.hashCode() + this.pathOrName.hashCode();
    }

    public String toString() {
        String thisPath = this.pathOrName.substring(this.pathOrName.lastIndexOf(47) + 1);
        if (thisPath.isEmpty()) {
            thisPath = "/";
        }
        return thisPath;
    }

    public String getFormattedAbsolutePath() {
        StringBuilder sb = new StringBuilder();
        if (this.objectType == ObjectType.COLLECTION) {
            sb.append(this.pathOrName);
        } else {
            sb.append(this.parentPath);
            sb.append('/');
            sb.append(this.pathOrName);
        }
        return sb.toString();
    }

    public String getNodeLabelDisplayValue() {
        String nodeVal;
        if (this.objectType == ObjectType.COLLECTION) {
            try {
                nodeVal = this.getLastPathComponentForCollectionName();
            }
            catch (JargonException e) {
                nodeVal = this.toString();
            }
        } else {
            nodeVal = this.pathOrName;
        }
        return nodeVal;
    }

    public boolean isCollection() {
        return this.objectType == ObjectType.COLLECTION;
    }

    public boolean isDataObject() {
        return this.objectType == ObjectType.DATA_OBJECT;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public List<UserFilePermission> getUserFilePermission() {
        return this.userFilePermission;
    }

    public void setUserFilePermission(List<UserFilePermission> userFilePermission) {
        this.userFilePermission = userFilePermission;
    }

    @Override
    public int compareTo(CollectionAndDataObjectListingEntry obj) {
        return this.getFormattedAbsolutePath().compareTo(obj.getFormattedAbsolutePath());
    }

    public String getOwnerZone() {
        return this.ownerZone;
    }

    public void setOwnerZone(String ownerZone) {
        this.ownerZone = ownerZone;
    }

    public static enum ObjectType {
        UNKNOWN,
        DATA_OBJECT,
        COLLECTION,
        UNKNOWN_FILE,
        LOCAL_FILE,
        LOCAL_DIR,
        NO_INPUT;

    }
}

