/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.RodsGenQueryEnum;

public class GenQuerySelectField {
    private final String selectFieldColumnName;
    private final SelectFieldTypes selectFieldType;
    private final SelectFieldSource selectFieldSource;
    private final String selectFieldNumericTranslation;

    public static GenQuerySelectField instance(RodsGenQueryEnum selectField, SelectFieldTypes selectFieldType, SelectFieldSource selectFieldSource) throws JargonException {
        if (selectField == null) {
            throw new JargonException("select field was null");
        }
        return new GenQuerySelectField(selectField.getName(), String.valueOf(selectField.getNumericValue()), selectFieldType, selectFieldSource);
    }

    public static GenQuerySelectField instance(String selectFieldName, String selectFieldNumericTranslation, SelectFieldTypes selectFieldType, SelectFieldSource selectFieldSource) throws JargonException {
        return new GenQuerySelectField(selectFieldName, selectFieldNumericTranslation, selectFieldType, selectFieldSource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Select field");
        sb.append("\n   selectFieldColumnName:");
        sb.append(this.selectFieldColumnName);
        sb.append("\n   selectFieldNumericTranslation:");
        sb.append(this.selectFieldNumericTranslation);
        sb.append("\n   selectFieldType:");
        sb.append((Object)this.selectFieldType);
        sb.append("\n   selectFieldSource:");
        sb.append((Object)this.selectFieldSource);
        return sb.toString();
    }

    private GenQuerySelectField(String selectFieldColumnName, String selectFieldNumericTranslation, SelectFieldTypes selectFieldType, SelectFieldSource selectFieldSource) throws JargonException {
        if (selectFieldColumnName == null || selectFieldColumnName.length() == 0) {
            throw new JargonException("select field was or missing");
        }
        if (selectFieldType == null) {
            throw new JargonException("field type was null");
        }
        if (selectFieldSource == null) {
            throw new JargonException("field source was null");
        }
        if (selectFieldNumericTranslation == null || selectFieldNumericTranslation.length() == 0) {
            throw new JargonException("field translation is null or blank");
        }
        this.selectFieldColumnName = selectFieldColumnName;
        this.selectFieldType = selectFieldType;
        this.selectFieldSource = selectFieldSource;
        this.selectFieldNumericTranslation = selectFieldNumericTranslation;
    }

    public String getSelectFieldColumnName() {
        return this.selectFieldColumnName;
    }

    public SelectFieldTypes getSelectFieldType() {
        return this.selectFieldType;
    }

    public SelectFieldSource getSelectFieldSource() {
        return this.selectFieldSource;
    }

    public String getSelectFieldNumericTranslation() {
        return this.selectFieldNumericTranslation;
    }

    public static enum SelectFieldSource {
        UNKNOWN,
        DEFINED_QUERY_FIELD,
        AVU,
        EXTENSIBLE_METADATA;

    }

    public static enum SelectFieldTypes {
        FIELD,
        SUM,
        MIN,
        MAX,
        AVG,
        COUNT,
        FILE_ACCESS;

    }
}

