/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.ExtensibleMetaDataMapping;
import org.irods.jargon.core.query.GenQueryCondition;
import org.irods.jargon.core.query.GenQueryConditionToken;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.query.TranslatedGenQueryCondition;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSGenQueryTranslator {
    private IRODSServerProperties irodsServerProperties;
    private static Logger log = LoggerFactory.getLogger(IRODSGenQueryTranslator.class);
    private ExtensibleMetaDataMapping extensibleMetaDataMapping = null;
    public static final String[] operatorStrings = new String[]{"<>", "<=", ">=", "not in", "not between", "not like", "sounds like", "sounds not like", "TABLE", "num<", "num>", "num<=", "num>=", "=", "<", ">", "in", "between", "like"};
    public static final String ORDER_BY = "ORDER BY";
    private static final String GROUP_BY = "GROUP BY";

    public IRODSGenQueryTranslator(IRODSServerProperties irodsServerProperties) throws JargonException {
        if (irodsServerProperties == null) {
            throw new JargonException("server properties is null");
        }
        this.irodsServerProperties = irodsServerProperties;
    }

    public IRODSGenQueryTranslator(IRODSServerProperties irodsServerProperties, ExtensibleMetaDataMapping extensibleMetaDataMapping) throws JargonException {
        this(irodsServerProperties);
        this.extensibleMetaDataMapping = extensibleMetaDataMapping;
    }

    public TranslatedIRODSGenQuery getTranslatedQuery(IRODSGenQuery irodsQuery) throws JargonQueryException, JargonException {
        List<String> selects = this.parseSelectsIntoListOfNames(irodsQuery.getQueryString());
        boolean isDistinct = true;
        if (this.doesQueryFlagNonDistinct(irodsQuery.getQueryString())) {
            isDistinct = false;
        }
        List<GenQuerySelectField> translatedSelects = this.translateSelects(selects);
        List<TranslatedGenQueryCondition> translatedConditions = this.translateConditions(irodsQuery);
        this.reviewTranslationBeforeReturningQuery(translatedSelects, translatedConditions);
        return TranslatedIRODSGenQuery.instance(translatedSelects, translatedConditions, irodsQuery, isDistinct);
    }

    private void reviewTranslationBeforeReturningQuery(List<GenQuerySelectField> translatedSelects, List<TranslatedGenQueryCondition> translatedConditions) throws JargonQueryException {
        if (translatedSelects.isEmpty()) {
            throw new JargonQueryException("no selects found in query");
        }
        int i = 0;
        for (GenQuerySelectField selectField : translatedSelects) {
            if (selectField == null) {
                throw new JargonQueryException("untranslated select field in position:" + i);
            }
            if (selectField.getSelectFieldNumericTranslation() == null) {
                throw new JargonQueryException("untranslated select field in position:" + i);
            }
            ++i;
        }
        i = 0;
        for (TranslatedGenQueryCondition condition : translatedConditions) {
            if (condition.getColumnNumericTranslation() == null) {
                throw new JargonQueryException("untranslated condition field in position:" + i + " after the WHERE");
            }
            ++i;
        }
    }

    protected List<TranslatedGenQueryCondition> translateConditions(IRODSGenQuery irodsQuery) throws JargonQueryException, JargonException {
        List<GenQueryCondition> conditions = this.parseConditionsIntoList(irodsQuery.getQueryString());
        ArrayList<TranslatedGenQueryCondition> translatedConditions = new ArrayList<TranslatedGenQueryCondition>();
        int i = 0;
        for (GenQueryCondition queryCondition : conditions) {
            String extensibleMetaDataTranslationValue;
            TranslatedGenQueryCondition translatedCondition;
            RodsGenQueryEnum conditionEnumVal;
            if (log.isDebugEnabled()) {
                log.debug("translating condition:" + queryCondition);
            }
            if ((conditionEnumVal = RodsGenQueryEnum.getAttributeBasedOnName(queryCondition.getFieldName())) != null) {
                translatedCondition = TranslatedGenQueryCondition.instance(conditionEnumVal, queryCondition.getOperator(), queryCondition.getValue());
                translatedConditions.add(translatedCondition);
                if (log.isDebugEnabled()) {
                    log.debug("added query condition:");
                    log.debug(translatedCondition.toString());
                }
                ++i;
                continue;
            }
            if (this.extensibleMetaDataMapping != null && (extensibleMetaDataTranslationValue = this.extensibleMetaDataMapping.getIndexFromColumnName(queryCondition.getFieldName())) != null) {
                translatedCondition = TranslatedGenQueryCondition.instanceForExtensibleMetaData(queryCondition.getFieldName(), queryCondition.getOperator(), queryCondition.getValue(), extensibleMetaDataTranslationValue);
                translatedConditions.add(translatedCondition);
                if (log.isDebugEnabled()) {
                    log.debug("added query condition as extensible metadata:");
                    log.debug(translatedCondition.toString());
                }
                ++i;
                continue;
            }
            throw new JargonQueryException("untranslatable condition in position:" + i + " after the where");
        }
        return translatedConditions;
    }

    protected List<GenQuerySelectField> translateSelects(List<String> selects) throws JargonException, JargonQueryException {
        ArrayList<GenQuerySelectField> translatedSelects = new ArrayList<GenQuerySelectField>();
        int i = 0;
        GenQuerySelectField translated = null;
        for (String select : selects) {
            translated = this.translateSelectFieldAsIRODSQueryValue(select.toUpperCase());
            if (translated != null) {
                translatedSelects.add(translated);
                ++i;
                continue;
            }
            translated = this.translateSelectAsMetadataSelectField(select);
            if (translated != null) {
                translatedSelects.add(translated);
                ++i;
                continue;
            }
            log.error("did not translate select field:{}", (Object)select);
            throw new JargonQueryException("untranslatable select in position:" + i);
        }
        return translatedSelects;
    }

    protected GenQuerySelectField translateSelectFieldAsIRODSQueryValue(String originalSelectField) throws JargonException, JargonQueryException {
        String rawField;
        RodsGenQueryEnum field;
        if (log.isDebugEnabled()) {
            log.debug("translating select field:" + originalSelectField);
        }
        if ((field = RodsGenQueryEnum.getAttributeBasedOnName(rawField = this.extractRawFieldFromSelectValue(originalSelectField))) == null) {
            log.debug("retuning null, this is not an IRODS query field");
            return null;
        }
        log.debug("field translated as iRODS GenQuery value");
        GenQuerySelectField.SelectFieldTypes selectFieldType = this.extractSelectFieldTypeFromSelectValue(originalSelectField);
        return GenQuerySelectField.instance(field, selectFieldType, GenQuerySelectField.SelectFieldSource.DEFINED_QUERY_FIELD);
    }

    protected GenQuerySelectField translateSelectAsMetadataSelectField(String originalSelectField) throws JargonException, JargonQueryException {
        String rawField;
        RodsGenQueryEnum field;
        if (log.isDebugEnabled()) {
            log.debug("translating select field:" + originalSelectField);
        }
        if ((field = RodsGenQueryEnum.getAttributeBasedOnName(rawField = this.extractRawFieldFromSelectValue(originalSelectField))) == null) {
            log.debug("retuning null, this is not an IRODS extensible metadata field");
            return null;
        }
        log.debug("translating as iRODS extensbile metadata field?");
        GenQuerySelectField.SelectFieldTypes selectFieldType = this.extractSelectFieldTypeFromSelectValue(originalSelectField);
        return GenQuerySelectField.instance(field, selectFieldType, GenQuerySelectField.SelectFieldSource.EXTENSIBLE_METADATA);
    }

    protected boolean doesQueryFlagNonDistinct(String query) {
        return query.toUpperCase().indexOf("NON-DISTINCT") > -1;
    }

    private String extractRawFieldFromSelectValue(String selectField) throws JargonQueryException {
        String rawField;
        int parenOpen = selectField.indexOf(40);
        int parenClose = -1;
        if (parenOpen > -1) {
            parenClose = selectField.indexOf(41);
            if (parenClose == -1) {
                throw new JargonQueryException("malformed select field:" + selectField);
            }
            rawField = selectField.substring(parenOpen + 1, parenClose);
            if (rawField.length() == 0) {
                throw new JargonQueryException("malformed select, aggregation but no field name specified in between ( and )");
            }
        } else {
            rawField = selectField;
        }
        return rawField;
    }

    private GenQuerySelectField.SelectFieldTypes extractSelectFieldTypeFromSelectValue(String selectField) throws JargonQueryException {
        GenQuerySelectField.SelectFieldTypes selectFieldType;
        int parenOpen = selectField.indexOf(40);
        if (parenOpen == -1) {
            selectFieldType = GenQuerySelectField.SelectFieldTypes.FIELD;
        } else {
            String aggregationComponent = selectField.substring(0, parenOpen);
            if (aggregationComponent.equals("SUM")) {
                selectFieldType = GenQuerySelectField.SelectFieldTypes.SUM;
            } else if (aggregationComponent.equals("AVG")) {
                selectFieldType = GenQuerySelectField.SelectFieldTypes.AVG;
            } else if (aggregationComponent.equals("COUNT")) {
                selectFieldType = GenQuerySelectField.SelectFieldTypes.COUNT;
            } else if (aggregationComponent.equals("MIN")) {
                selectFieldType = GenQuerySelectField.SelectFieldTypes.MIN;
            } else if (aggregationComponent.equals("MAX")) {
                selectFieldType = GenQuerySelectField.SelectFieldTypes.MAX;
            } else {
                throw new JargonQueryException("malformed select, unknown aggregation type of " + aggregationComponent + " in field:" + selectField);
            }
        }
        return selectFieldType;
    }

    protected List<String> parseSelectsIntoListOfNames(String query) throws JargonQueryException {
        String queryDelimited = query.toUpperCase();
        queryDelimited = queryDelimited.replaceAll("  ", " ");
        queryDelimited = queryDelimited.replaceAll(ORDER_BY, "ORDERBY");
        queryDelimited = queryDelimited.replaceAll(GROUP_BY, "GROUPBY");
        ArrayList<String> selectFieldNames = new ArrayList<String>();
        boolean readPastSelect = false;
        boolean haveNotHitEndOfSelects = true;
        String queryNoCommas = queryDelimited.replaceAll(",", " ");
        StringTokenizer tokenizer = new StringTokenizer(queryNoCommas, " ");
        int tokenCtr = 0;
        while (tokenizer.hasMoreElements() && haveNotHitEndOfSelects) {
            JargonQueryException qe;
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase("select")) {
                readPastSelect = true;
                continue;
            }
            if (!readPastSelect) {
                qe = new JargonQueryException("error in query, no select detected");
                qe.setQuery(query);
                throw qe;
            }
            if (token.equalsIgnoreCase("where") || token.equalsIgnoreCase("ORDERBY") || token.equalsIgnoreCase("GROUPBY")) {
                haveNotHitEndOfSelects = false;
                continue;
            }
            if (token.equalsIgnoreCase("distinct") || token.equalsIgnoreCase("non-distinct")) {
                if (tokenCtr == true) continue;
                qe = new JargonQueryException("distinct/non-distinct must be second token after select");
                qe.setQuery(query);
                continue;
            }
            selectFieldNames.add(token.trim());
            ++tokenCtr;
        }
        return selectFieldNames;
    }

    protected List<GenQueryCondition> parseConditionsIntoList(String query) throws JargonQueryException {
        int indexOfOrderBy;
        String testQuery = query;
        ArrayList<GenQueryCondition> conditions = new ArrayList<GenQueryCondition>();
        int idxOfWhere = -1;
        int indexOfWhereUC = testQuery.indexOf(" WHERE ");
        int indexOfWhereLC = testQuery.indexOf(" where ");
        if (indexOfWhereUC != -1) {
            idxOfWhere = indexOfWhereUC;
        } else if (indexOfWhereLC != -1) {
            idxOfWhere = indexOfWhereLC;
        }
        if (idxOfWhere == -1) {
            log.debug("no where conditions, returning");
            return conditions;
        }
        int conditionOffset = idxOfWhere + 7;
        String findGroupByInStringMakingItAllUpperCase = testQuery.substring(conditionOffset).toUpperCase();
        int indexOfGroupBy = findGroupByInStringMakingItAllUpperCase.indexOf(GROUP_BY);
        if (indexOfGroupBy != -1) {
            log.debug("found group by in query {}", (Object)findGroupByInStringMakingItAllUpperCase);
            testQuery = testQuery.substring(0, testQuery.length() - indexOfGroupBy - 8);
        }
        if ((indexOfOrderBy = findGroupByInStringMakingItAllUpperCase.indexOf(ORDER_BY)) != -1) {
            log.debug("found order by in query {}", (Object)findGroupByInStringMakingItAllUpperCase);
            testQuery = testQuery.substring(0, testQuery.length() - indexOfOrderBy - 8);
        }
        List<GenQueryConditionToken> tokens = this.tokenizeConditions(testQuery, conditionOffset);
        log.debug("query condition tokens were: {}", tokens);
        return this.buildListOfQueryConditionsFromParsedTokens(tokens);
    }

    protected List<String> parseOrderByFieldsIntoList(String query) throws JargonQueryException {
        ArrayList<String> orderByVals = new ArrayList<String>();
        String upperCaseVersionOfQuery = query.toUpperCase();
        int indexOfOrderBy = upperCaseVersionOfQuery.indexOf(ORDER_BY);
        if (indexOfOrderBy == -1) {
            log.debug("no order by in query");
            return orderByVals;
        }
        String orderBySectionOfQueryToParse = upperCaseVersionOfQuery.substring(indexOfOrderBy + 8);
        log.debug("order by section of query:{}", (Object)orderBySectionOfQueryToParse);
        String queryNoCommas = orderBySectionOfQueryToParse.replaceAll(",", " ");
        StringTokenizer tokenizer = new StringTokenizer(queryNoCommas, " ");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            orderByVals.add(token);
        }
        return orderByVals;
    }

    private List<GenQueryCondition> buildListOfQueryConditionsFromParsedTokens(List<GenQueryConditionToken> tokens) throws JargonQueryException {
        ArrayList<GenQueryCondition> queryConditions = new ArrayList<GenQueryCondition>();
        int i = 0;
        int tokenCtr = 0;
        String parsedField = "";
        String parsedValue = "";
        String parsedOperator = "";
        boolean negation = false;
        for (GenQueryConditionToken token : tokens) {
            if (token.getValue().equalsIgnoreCase("where")) {
                throw new JargonQueryException("multiple where statements?, encountered at the " + tokenCtr + " token after the WHERE");
            }
            if (token.getValue().equalsIgnoreCase("and")) {
                if (i <= 0) continue;
                throw new JargonQueryException("I found an AND operator after an incomplete condition at token " + tokenCtr + " after the where");
            }
            if (i == 0) {
                negation = false;
                parsedField = token.getValue().trim();
                ++i;
            } else if (i == 1) {
                if (token.getValue().trim().equalsIgnoreCase("NOT")) {
                    if (negation) {
                        throw new JargonQueryException("multiple NOT in condition operator,  around token after the where " + tokenCtr);
                    }
                    negation = true;
                    parsedOperator = "NOT ";
                    ++tokenCtr;
                    continue;
                }
                parsedOperator = parsedOperator + token.getValue().trim();
                this.validateOperatorAgainstPossibilities(parsedOperator);
                negation = false;
                ++i;
            } else if (i >= 2) {
                parsedValue = token.getValue().trim();
                if (parsedField.isEmpty() || parsedOperator.isEmpty() || parsedValue.isEmpty()) {
                    throw new JargonQueryException("query attribute/value/condition malformed around element:" + tokenCtr);
                }
                GenQueryCondition queryCondition = GenQueryCondition.instance(parsedField, parsedOperator, parsedValue);
                parsedOperator = "";
                queryConditions.add(queryCondition);
                i = 0;
            }
            ++tokenCtr;
        }
        if (i > 0) {
            throw new JargonQueryException("the last query condition is incomplete");
        }
        return queryConditions;
    }

    private void validateOperatorAgainstPossibilities(String parsedOperator) throws JargonQueryException {
        boolean matched = false;
        for (String opr : operatorStrings) {
            if (!opr.equalsIgnoreCase(parsedOperator.trim())) continue;
            matched = true;
        }
        if (!matched) {
            throw new JargonQueryException("unexpected query operator:" + parsedOperator);
        }
    }

    private List<GenQueryConditionToken> tokenizeConditions(String query, int conditionOffset) throws JargonQueryException {
        String conditionString = query.substring(conditionOffset);
        log.debug("conditions in string: {}", (Object)conditionString);
        ArrayList<GenQueryConditionToken> queryTokens = new ArrayList<GenQueryConditionToken>();
        StringBuilder tokenAccum = new StringBuilder();
        GenQueryConditionToken token = null;
        boolean accumulatingQuotedLiteral = false;
        boolean escaped = false;
        char nextChar = ' ';
        for (int i = 0; i < conditionString.length(); ++i) {
            nextChar = conditionString.charAt(i);
            if (escaped) {
                tokenAccum.append(nextChar);
                escaped = false;
                continue;
            }
            if (nextChar == '\\') {
                if (escaped) {
                    tokenAccum.append(nextChar);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (nextChar == ' ') {
                if (accumulatingQuotedLiteral) {
                    tokenAccum.append(nextChar);
                    continue;
                }
                if (tokenAccum.length() <= 0) continue;
                token = new GenQueryConditionToken();
                token.setValue(tokenAccum.toString());
                queryTokens.add(token);
                tokenAccum = new StringBuilder();
                continue;
            }
            if (nextChar == '\'') {
                if (accumulatingQuotedLiteral) {
                    tokenAccum.append(nextChar);
                    accumulatingQuotedLiteral = false;
                    continue;
                }
                if (tokenAccum.length() > 0) {
                    throw new JargonQueryException("error in condition at position " + (conditionOffset + i) + " an invalid quote character was encountered");
                }
                accumulatingQuotedLiteral = true;
                tokenAccum.append(nextChar);
                continue;
            }
            tokenAccum.append(nextChar);
        }
        if (accumulatingQuotedLiteral) {
            throw new JargonQueryException("unclosed quoted literal found in condition");
        }
        if (tokenAccum.length() > 0) {
            token = new GenQueryConditionToken();
            token.setValue(tokenAccum.toString());
            queryTokens.add(token);
        }
        return queryTokens;
    }

    public IRODSServerProperties getIrodsServerProperties() {
        return this.irodsServerProperties;
    }

    public void setIrodsServerProperties(IRODSServerProperties irodsServerProperties) {
        this.irodsServerProperties = irodsServerProperties;
    }

    public ExtensibleMetaDataMapping getExtensibleMetaDataMapping() {
        return this.extensibleMetaDataMapping;
    }

    public void setExtensibleMetaDataMapping(ExtensibleMetaDataMapping extensibleMetaDataMapping) {
        this.extensibleMetaDataMapping = extensibleMetaDataMapping;
    }
}

