/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.List;
import org.irods.jargon.core.exception.JargonException;

public class IRODSQueryResultRow {
    private final List<String> queryResultColumns;
    private final int recordCount;
    private final boolean lastResult;
    private final List<String> columnNames;

    public static IRODSQueryResultRow instance(List<String> queryResultColumns, List<String> columnNames) throws JargonException {
        return new IRODSQueryResultRow(queryResultColumns, columnNames, 0, false);
    }

    public static IRODSQueryResultRow instance(List<String> queryResultColumns, List<String> columnNames, int recordCount, boolean lastResult) throws JargonException {
        return new IRODSQueryResultRow(queryResultColumns, columnNames, recordCount, lastResult);
    }

    private IRODSQueryResultRow(List<String> queryResultColumns, List<String> columnNames, int recordCount, boolean lastResult) throws JargonException {
        if (queryResultColumns == null) {
            throw new JargonException("queryResultColumns is null");
        }
        if (columnNames == null) {
            throw new JargonException("columnNames is null");
        }
        this.queryResultColumns = queryResultColumns;
        this.lastResult = lastResult;
        this.recordCount = recordCount;
        this.columnNames = columnNames;
    }

    public String getColumn(int columnNumber) throws JargonException {
        if (columnNumber < 0 || columnNumber >= this.queryResultColumns.size()) {
            throw new JargonException("column out of range");
        }
        return this.queryResultColumns.get(columnNumber);
    }

    public String getColumn(String columnName) throws JargonException {
        if (columnName == null || columnName.length() == 0) {
            throw new JargonException("columnName is null or empty");
        }
        int idx = this.getColumnNamePosition(columnName);
        if (idx == -1) {
            throw new JargonException("column name not found in result set:" + columnName);
        }
        return this.queryResultColumns.get(idx);
    }

    protected int getColumnNamePosition(String columnName) {
        int colPos = -1;
        int i = 0;
        for (String colNameInList : this.columnNames) {
            if (columnName.equals(colNameInList)) {
                colPos = i;
                break;
            }
            ++i;
        }
        return colPos;
    }

    public List<String> getColumnsAsList() {
        return this.queryResultColumns;
    }

    public List<String> getQueryResultColumns() {
        return this.queryResultColumns;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public boolean isLastResult() {
        return this.lastResult;
    }
}

