/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.AbstractIRODSQueryResultSet;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;

public class IRODSQueryResultSet
extends AbstractIRODSQueryResultSet {
    private final TranslatedIRODSGenQuery translatedIRODSQuery;
    private final int continuationIndex;

    public static IRODSQueryResultSet instance(TranslatedIRODSGenQuery translatedIRODSQuery, List<IRODSQueryResultRow> results, int continuationIndex) throws JargonException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (GenQuerySelectField selectField : translatedIRODSQuery.getSelectFields()) {
            columnNames.add(selectField.getSelectFieldColumnName());
        }
        return new IRODSQueryResultSet(translatedIRODSQuery, results, columnNames, continuationIndex);
    }

    private IRODSQueryResultSet(TranslatedIRODSGenQuery translatedIRODSQuery, List<IRODSQueryResultRow> results, List<String> columnNames, int continuationIndex) throws JargonException {
        super(results, Collections.unmodifiableList(columnNames), continuationIndex > 0);
        if (translatedIRODSQuery == null) {
            throw new JargonException("translated IRODS query is null");
        }
        this.translatedIRODSQuery = translatedIRODSQuery;
        this.continuationIndex = continuationIndex;
    }

    public TranslatedIRODSGenQuery getTranslatedIRODSQuery() {
        return this.translatedIRODSQuery;
    }

    @Override
    public int getNumberOfResultColumns() {
        return this.translatedIRODSQuery.getSelectFields().size();
    }

    public int getContinuationIndex() {
        return this.continuationIndex;
    }
}

