/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleQuery {
    private final String queryString;
    private final List<String> arguments;
    private final int continuationValue;

    public static SimpleQuery instance(String queryString, List<String> arguments, int continuationValue) {
        return new SimpleQuery(queryString, arguments, continuationValue);
    }

    public static SimpleQuery instanceWithNoArguments(String queryString, int continuationValue) {
        ArrayList<String> args = new ArrayList<String>();
        return new SimpleQuery(queryString, args, continuationValue);
    }

    public static SimpleQuery instanceWithOneArgument(String queryString, String arg, int continuationValue) {
        if (arg == null) {
            throw new IllegalArgumentException("arg is null");
        }
        ArrayList<String> args = new ArrayList<String>();
        if (!arg.isEmpty()) {
            args.add(arg);
        }
        return new SimpleQuery(queryString, args, continuationValue);
    }

    public static SimpleQuery instanceWithTwoArguments(String queryString, String arg1, String arg2, int continuationValue) {
        if (arg1 == null || arg1.isEmpty()) {
            throw new IllegalArgumentException("arg1 is null or empty");
        }
        if (arg2 == null || arg2.isEmpty()) {
            throw new IllegalArgumentException("arg2 is null or empty");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(arg1);
        args.add(arg2);
        return new SimpleQuery(queryString, args, continuationValue);
    }

    private SimpleQuery(String queryString, List<String> arguments, int continuationValue) {
        if (queryString == null || queryString.isEmpty()) {
            throw new IllegalArgumentException("empty or null queryString");
        }
        if (continuationValue < 0) {
            throw new IllegalArgumentException("continuation value is less than zero");
        }
        this.queryString = queryString;
        this.continuationValue = continuationValue;
        if (arguments == null) {
            this.arguments = Collections.unmodifiableList(new ArrayList());
        } else {
            if (arguments.size() > 4) {
                throw new IllegalArgumentException("limit of 4 arguments");
            }
            this.arguments = Collections.unmodifiableList(arguments);
        }
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("simpleQuery:");
        sb.append("\n   queryString:");
        sb.append(this.queryString);
        sb.append("\n   arguments:");
        sb.append(this.arguments);
        sb.append("\n  continuationValue:");
        sb.append(this.continuationValue);
        return sb.toString();
    }

    public int getContinuationValue() {
        return this.continuationValue;
    }

    public List<String> getArguments() {
        return this.arguments;
    }
}

