/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.TranslatedGenQueryCondition;

public class TranslatedIRODSGenQuery {
    private final List<GenQuerySelectField> selectFields;
    private final List<TranslatedGenQueryCondition> translatedQueryConditions;
    private final IRODSGenQuery irodsQuery;
    private final boolean distinct;

    public static TranslatedIRODSGenQuery instance(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, IRODSGenQuery irodsQuery, boolean distinct) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, new ArrayList<GenQuerySelectField>(), irodsQuery, distinct);
    }

    public static TranslatedIRODSGenQuery instanceWithGroupBy(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, List<GenQuerySelectField> groupByFields, IRODSGenQuery irodsQuery, boolean distinct) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, groupByFields, irodsQuery, distinct);
    }

    public static TranslatedIRODSGenQuery instance(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, IRODSGenQuery irodsQuery) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, new ArrayList<GenQuerySelectField>(), irodsQuery, true);
    }

    private TranslatedIRODSGenQuery(List<GenQuerySelectField> selectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, List<GenQuerySelectField> groupByFields, IRODSGenQuery irodsQuery, boolean distinct) throws JargonException {
        if (translatedQueryConditions == null) {
            throw new JargonException("conditions are null");
        }
        if (selectFields == null) {
            throw new JargonException("no select column names");
        }
        if (groupByFields == null) {
            throw new JargonException("null groupByFields");
        }
        if (selectFields.isEmpty()) {
            throw new JargonException("no select column names");
        }
        if (irodsQuery == null) {
            throw new JargonException("irodsQuery is null");
        }
        this.translatedQueryConditions = translatedQueryConditions;
        this.selectFields = selectFields;
        this.irodsQuery = irodsQuery;
        this.distinct = distinct;
    }

    public List<GenQuerySelectField> getSelectFields() {
        return this.selectFields;
    }

    public List<TranslatedGenQueryCondition> getTranslatedQueryConditions() {
        return this.translatedQueryConditions;
    }

    public IRODSGenQuery getIrodsQuery() {
        return this.irodsQuery;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("translatedIRODSQuery:");
        sb.append("\n   selectFields:");
        sb.append(this.selectFields);
        sb.append("\n   translatedQueryConditions:");
        sb.append(this.translatedQueryConditions);
        sb.append("\n   irodsQuery:");
        sb.append(this.irodsQuery);
        sb.append("\n   distinct:");
        sb.append(this.distinct);
        return sb.toString();
    }
}

