/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSPasswordUtilities {
    public static final int WHEEL_LENGTH;
    public static final int VAL_0 = 48;
    public static final int VAL_A = 65;
    public static final int VAL_LC_A = 97;
    public static final int VAL_BANG = 33;
    public static final List<Integer> WHEEL;
    public static final String RAND_STRING = "1gCBizHWbwIYyWLoysGzTe6SyzqFKMniZX05faZHWAwQKXf6Fs";
    public static final int MAX_PWD_LENGTH = 50;
    static final Logger log;

    public static String obfuscateIRODSPassword(String newPassword, String oldPassword) throws JargonException {
        MessageDigest messageDigest;
        if (newPassword == null || newPassword.isEmpty()) {
            throw new JargonException("newPassword is null or empty");
        }
        if (oldPassword == null || oldPassword.isEmpty()) {
            throw new JargonException("oldPassword is null or empty");
        }
        int lCopy = 40 - newPassword.length();
        StringBuilder pwdBuf = new StringBuilder();
        pwdBuf.append(newPassword);
        if (lCopy > 15) {
            pwdBuf.append(RAND_STRING.substring(0, lCopy));
        }
        String randPaddedNewPassword = pwdBuf.toString();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("error getting MD5 MessageDigest", e);
        }
        byte[] oldPwdBuffer = new byte[100];
        byte[] oldPwdAsBytes = oldPassword.getBytes();
        for (int i = 0; i < oldPassword.length(); ++i) {
            oldPwdBuffer[i] = oldPwdAsBytes[i];
        }
        messageDigest.update(oldPwdBuffer);
        byte[] digestRound1 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound1:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound1));
        }
        messageDigest.reset();
        messageDigest.update(digestRound1);
        byte[] digestRound2 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound2:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound2));
        }
        byte[] concatRound1AndRound2 = new byte[digestRound1.length + digestRound2.length];
        int concatI = 0;
        for (byte element : digestRound1) {
            concatRound1AndRound2[concatI++] = element;
        }
        for (byte element : digestRound2) {
            concatRound1AndRound2[concatI++] = element;
        }
        messageDigest.reset();
        messageDigest.update(concatRound1AndRound2);
        byte[] digestRound3 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound3:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound3));
        }
        byte[] concatRound1AndRound2AndRound3 = new byte[digestRound1.length + digestRound2.length + digestRound3.length];
        concatI = 0;
        for (byte element : digestRound1) {
            concatRound1AndRound2AndRound3[concatI++] = element;
        }
        for (byte element : digestRound2) {
            concatRound1AndRound2AndRound3[concatI++] = element;
        }
        for (byte element : digestRound3) {
            concatRound1AndRound2AndRound3[concatI++] = element;
        }
        messageDigest.reset();
        messageDigest.update(concatRound1AndRound2);
        byte[] digestRound4 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound4:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound4));
        }
        byte[] cpKeyArray = new byte[digestRound1.length + digestRound2.length + digestRound3.length + digestRound4.length];
        concatI = 0;
        for (byte element : digestRound1) {
            cpKeyArray[concatI++] = element;
        }
        for (byte element : digestRound2) {
            cpKeyArray[concatI++] = element;
        }
        for (byte element : digestRound3) {
            cpKeyArray[concatI++] = element;
        }
        for (byte element : digestRound4) {
            cpKeyArray[concatI++] = element;
        }
        if (log.isDebugEnabled()) {
            log.debug("cpKeyArray:{}", (Object)IRODSPasswordUtilities.getHexString(cpKeyArray));
        }
        int cpKeyArrayIdx = 0;
        String cpInArray = randPaddedNewPassword;
        int k = 0;
        boolean found = false;
        StringBuilder cpOut = new StringBuilder();
        for (int cpInIdx = 0; cpInIdx < cpInArray.length(); ++cpInIdx) {
            k = 0;
            found = false;
            byte b = cpKeyArray[cpKeyArrayIdx++];
            k = IRODSPasswordUtilities.unsignedByteToInt(b);
            if (cpKeyArrayIdx > 60) {
                cpKeyArrayIdx = 0;
            }
            for (int i = 0; i < WHEEL_LENGTH; ++i) {
                int wheelVal;
                int cpInVal = IRODSPasswordUtilities.unsignedByteToInt(cpInArray.getBytes()[cpInIdx]);
                if (cpInVal != (wheelVal = WHEEL.get(i).intValue())) continue;
                int j = i + k;
                wheelVal = WHEEL.get(j %= WHEEL_LENGTH);
                char wheelChr = (char)wheelVal;
                cpOut.append(wheelChr);
                found = true;
                break;
            }
            if (found) continue;
            if (cpInIdx == cpInArray.length()) break;
            cpOut.append(cpInArray.charAt(cpInIdx));
        }
        return cpOut.toString();
    }

    public static String getHexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte element : b) {
            result.append(Integer.toString((element & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static String getHashedPassword(String passwordHashValue, IRODSAccount irodsAccount) throws JargonException {
        MessageDigest messageDigest;
        StringBuilder sb = new StringBuilder();
        sb.append(passwordHashValue);
        sb.append(irodsAccount.getPassword());
        String hashBuff = IRODSPasswordUtilities.pad(sb.toString(), 100, '\u0000');
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("error getting MD5 MessageDigest", e);
        }
        byte[] hashBytes = hashBuff.getBytes();
        messageDigest.update(hashBytes);
        byte[] digestRound1 = messageDigest.digest();
        String hexString = IRODSPasswordUtilities.getHexString(digestRound1);
        return hexString;
    }

    public static String pad(String str, int size, char padChar) {
        if (str.length() < size) {
            int i;
            char[] temp = new char[size];
            for (i = 0; i < str.length(); ++i) {
                temp[i] = str.charAt(i);
            }
            while (i < size) {
                temp[i] = padChar;
                ++i;
            }
            str = new String(temp);
        }
        return str;
    }

    static {
        int i;
        log = LoggerFactory.getLogger(IRODSPasswordUtilities.class);
        WHEEL = new ArrayList<Integer>();
        for (i = 0; i < 10; ++i) {
            WHEEL.add(48 + i);
        }
        for (i = 0; i < 26; ++i) {
            WHEEL.add(65 + i);
        }
        for (i = 0; i < 26; ++i) {
            WHEEL.add(97 + i);
        }
        for (i = 0; i < 15; ++i) {
            WHEEL.add(33 + i);
        }
        WHEEL_LENGTH = WHEEL.size();
    }
}

