/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractParallelTransferThread {
    protected static final String IO_EXCEPTION_OCCURRED_DURING_PARALLEL_FILE_TRANSFER = "IOException occurred during parallel file transfer";
    protected static final String IO_EXEPTION_IN_PARALLEL_TRANSFER = "IOExeption in parallel transfer";
    private Socket s;
    private InputStream in;
    private OutputStream out;
    private Exception exceptionInTransfer = null;
    public static final int DONE_OPR = 9999;
    public static final int PUT_OPR = 1;
    public static final int GET_OPR = 2;
    public static final Logger log = LoggerFactory.getLogger(AbstractParallelTransferThread.class);

    protected AbstractParallelTransferThread() {
    }

    protected int readInt() throws JargonException {
        int read;
        byte[] b = new byte[4];
        try {
            read = this.in.read(b);
        }
        catch (IOException e) {
            log.error(IO_EXEPTION_IN_PARALLEL_TRANSFER, e);
            throw new JargonException(IO_EXCEPTION_OCCURRED_DURING_PARALLEL_FILE_TRANSFER, e);
        }
        if (read != 4) {
            log.error("unexpected length read when reading int");
            throw new JargonException("unexpected length read when reading int");
        }
        return Host.castToInt(b);
    }

    protected long readLong() throws JargonException {
        int read;
        byte[] b = new byte[8];
        try {
            read = this.in.read(b);
        }
        catch (IOException e) {
            log.error(IO_EXEPTION_IN_PARALLEL_TRANSFER);
            throw new JargonRuntimeException(IO_EXCEPTION_OCCURRED_DURING_PARALLEL_FILE_TRANSFER, e);
        }
        if (read != 8) {
            log.error("did not read 8 bytes for long");
            throw new RuntimeException("unable to read all the bytes for an expected long value");
        }
        return Host.castToLong(b);
    }

    public void close() throws JargonException {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                log.warn("IOException on close - LOG and ignore");
            }
            this.out = null;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                log.warn("IOException on close - LOG and ignore");
            }
            this.in = null;
        }
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (IOException e) {
                log.warn("IOException on close - LOG and ignore");
            }
            this.s = null;
        }
    }

    protected final Socket getS() {
        return this.s;
    }

    protected final void setS(Socket s) {
        this.s = s;
    }

    protected final InputStream getIn() {
        return this.in;
    }

    protected final void setIn(InputStream in) {
        this.in = in;
    }

    protected final OutputStream getOut() {
        return this.out;
    }

    protected final void setOut(OutputStream out) {
        this.out = out;
    }

    public Exception getExceptionInTransfer() {
        return this.exceptionInTransfer;
    }

    protected void setExceptionInTransfer(Exception exceptionInTransfer) {
        this.exceptionInTransfer = exceptionInTransfer;
    }
}

