/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.transfer.AbstractParallelFileTransferStrategy;
import org.irods.jargon.core.transfer.ParallelPutTransferThread;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelPutFileTransferStrategy
extends AbstractParallelFileTransferStrategy {
    public static final Logger log = LoggerFactory.getLogger(ParallelPutFileTransferStrategy.class);

    public static ParallelPutFileTransferStrategy instance(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        return new ParallelPutFileTransferStrategy(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParallelPutFileTransferStrategy");
        sb.append("\n   host:");
        sb.append(this.getHost());
        sb.append("\n   port:");
        sb.append(this.getPort());
        sb.append("\n   numberOfThreads:");
        sb.append(this.getNumberOfThreads());
        sb.append("\n   localFile:");
        sb.append(this.localFile.getAbsolutePath());
        sb.append("\n   transferLength:");
        sb.append(this.transferLength);
        return sb.toString();
    }

    private ParallelPutFileTransferStrategy(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        super(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener);
        if (transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && transferStatusCallbackListener != null) {
            log.info("will do intra-file status callbacks from transfer");
            this.setConnectionProgressStatusListener(DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.PUT, transferLength, transferControlBlock, transferStatusCallbackListener));
        }
    }

    @Override
    public void transfer() throws JargonException {
        log.info("initiating transfer for: {}", (Object)this.toString());
        ExecutorService executor = this.getIrodsAccessObjectFactory().getIrodsSession().getParallelTransferThreadPool();
        if (executor == null) {
            log.info("no pool available, transfer using standard Threads");
            this.transferWithoutExecutor();
        } else {
            log.info("transfer via executor");
            this.transferWithExecutor(executor);
        }
    }

    private void transferWithExecutor(ExecutorService executor) throws JargonException {
        log.info("initiating transfer for: {} without executor", (Object)this.toString());
        ArrayList<ParallelPutTransferThread> parallelPutTransferThreads = new ArrayList<ParallelPutTransferThread>();
        this.localFile.length();
        for (int i = 0; i < this.numberOfThreads; ++i) {
            ParallelPutTransferThread parallelTransferThread = ParallelPutTransferThread.instance(this);
            parallelPutTransferThreads.add(parallelTransferThread);
            log.info("created transfer thread:{}", parallelTransferThread);
        }
        try {
            log.info("invoking executor threads for put");
            List transferThreadStates = executor.invokeAll(parallelPutTransferThreads);
            if (log.isInfoEnabled()) {
                for (Future transferState : transferThreadStates) {
                    log.info("transfer state:{}", transferState);
                }
            }
            log.info("executor completed");
        }
        catch (InterruptedException e) {
            log.error("interrupted exception in thread", e);
            throw new JargonException(e);
        }
        catch (Exception e) {
            log.error("an error occurred in a parallel get", e);
            throw new JargonException(e);
        }
    }

    public void transferWithoutExecutor() throws JargonException {
        log.info("initiating transfer for: {} without executor", (Object)this.toString());
        ArrayList<Thread> transferRunningThreads = new ArrayList<Thread>();
        ArrayList<ParallelPutTransferThread> parallelPutTransferThreads = new ArrayList<ParallelPutTransferThread>();
        for (int i = 0; i < this.numberOfThreads; ++i) {
            ParallelPutTransferThread parallelTransferThread = ParallelPutTransferThread.instance(this);
            transferRunningThreads.add(new Thread(parallelTransferThread));
            parallelPutTransferThreads.add(parallelTransferThread);
            log.info("creating transfer thread:{}", parallelTransferThread);
        }
        for (Thread parallelTransferThreadToStart : transferRunningThreads) {
            parallelTransferThreadToStart.start();
            log.info("started parallel transfer thread for thread: {}", (Object)parallelTransferThreadToStart.getName());
        }
        for (Thread parallelTransferThreadToJoin : transferRunningThreads) {
            try {
                parallelTransferThreadToJoin.join();
            }
            catch (InterruptedException e) {
                log.error("parallel transfer thread {} was interrupted when attempting to join", (Object)parallelTransferThreadToJoin.getName(), (Object)e);
                throw new JargonException("parallel transfer thread interrupted when attempting to join");
            }
        }
        log.info("parallel transfer complete...checking for any exceptions that occurred in each thread");
        for (ParallelPutTransferThread parallelPutTransferThread : parallelPutTransferThreads) {
            if (parallelPutTransferThread.getExceptionInTransfer() == null) continue;
            log.error("exeption detected in file transfer thread:{}", parallelPutTransferThread.getExceptionInTransfer());
            throw new JargonException("exception caught in transfer thread", parallelPutTransferThread.getExceptionInTransfer());
        }
    }
}

