/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import org.irods.jargon.core.exception.JargonException;

public final class TransferStatus {
    private final TransferState transferState;
    private final TransferType transferType;
    private final TransferType transferEnclosingType;
    private final String sourceFileAbsolutePath;
    private final String targetFileAbsolutePath;
    private final String transferHost;
    private final String transferZone;
    private final String targetResource;
    private final long totalSize;
    private final long bytesTransfered;
    private final int totalFilesTransferredSoFar;
    private final int totalFilesToTransfer;
    private final Exception transferException;
    private final boolean intraFileStatusReport;

    public static TransferStatus instance(TransferType transferType, String sourceFileAbsolutePath, String targetFileAbsolutePath, String targetResource, long totalSize, long bytesTransfered, int totalFilesTransferredSoFar, int totalFilesToTransfer, TransferState transferState, String transferHost, String transferZone) throws JargonException {
        return new TransferStatus(transferType, null, sourceFileAbsolutePath, targetFileAbsolutePath, targetResource, totalSize, bytesTransfered, totalFilesTransferredSoFar, totalFilesToTransfer, transferState, null, false, transferHost, transferZone);
    }

    public static TransferStatus instanceForSynch(TransferType transferType, String sourceFileAbsolutePath, String targetFileAbsolutePath, String targetResource, long totalSize, long bytesTransfered, int totalFilesTransferredSoFar, int totalFilesToTransfer, TransferState transferState, String transferHost, String transferZone) throws JargonException {
        return new TransferStatus(transferType, TransferType.SYNCH, sourceFileAbsolutePath, targetFileAbsolutePath, targetResource, totalSize, bytesTransfered, totalFilesTransferredSoFar, totalFilesToTransfer, transferState, null, false, transferHost, transferZone);
    }

    public static TransferStatus instanceForIntraFileStatus(TransferType transferType, long totalSize, long bytesTransfered) throws JargonException {
        return new TransferStatus(transferType, null, "", "", "", totalSize, bytesTransfered, 0, 0, TransferState.IN_PROGRESS_START_FILE, null, true, "", "");
    }

    public static TransferStatus instanceForException(TransferType transferType, String sourceFileAbsolutePath, String targetFileAbsolutePath, String targetResource, long totalSize, long bytesTransfered, int totalFilesTransferredSoFar, int totalFilesToTransfer, Exception exception, String transferHost, String transferZone) throws JargonException {
        return new TransferStatus(transferType, null, sourceFileAbsolutePath, targetFileAbsolutePath, targetResource, totalSize, bytesTransfered, totalFilesTransferredSoFar, totalFilesToTransfer, TransferState.FAILURE, exception, false, transferHost, transferZone);
    }

    public static TransferStatus instanceForExceptionForSynch(TransferType transferType, String sourceFileAbsolutePath, String targetFileAbsolutePath, String targetResource, long totalSize, long bytesTransfered, int totalFilesTransferredSoFar, int totalFilesToTransfer, Exception exception, String transferHost, String transferZone) throws JargonException {
        return new TransferStatus(transferType, TransferType.SYNCH, sourceFileAbsolutePath, targetFileAbsolutePath, targetResource, totalSize, bytesTransfered, totalFilesTransferredSoFar, totalFilesToTransfer, TransferState.FAILURE, exception, false, transferHost, transferZone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("transfer status:");
        sb.append("\n   transferState:");
        sb.append((Object)this.transferState);
        sb.append("\n   transferType:");
        sb.append((Object)this.transferType);
        if (this.transferEnclosingType != null) {
            sb.append("\n  enclosed by transfer type:");
            sb.append((Object)this.transferEnclosingType);
        }
        sb.append("\n   sourceFileAbsolutePath:");
        sb.append(this.sourceFileAbsolutePath);
        sb.append("\n   targetFileAbsolutePath:");
        sb.append(this.targetFileAbsolutePath);
        sb.append("\n   targetResource:");
        sb.append(this.targetResource);
        sb.append("\n   totalSize:");
        sb.append(this.totalSize);
        sb.append("\n   bytesTransferred:");
        sb.append(this.bytesTransfered);
        sb.append("\n   totalFilesTransferredSoFar:");
        sb.append(this.totalFilesTransferredSoFar);
        sb.append("\n   totalFilesToTransfer:");
        sb.append(this.totalFilesToTransfer);
        sb.append("\n   transferException:");
        sb.append(this.transferException);
        sb.append("\n   intraFileStatusReport");
        sb.append(this.intraFileStatusReport);
        sb.append("\n   transferHost:");
        sb.append(this.transferHost);
        sb.append("\n   transferZone:");
        sb.append(this.transferZone);
        return sb.toString();
    }

    private TransferStatus(TransferType transferType, TransferType transferEnclosingType, String sourceFileAbsolutePath, String targetFileAbsolutePath, String targetResource, long totalSize, long bytesTransferred, int totalFilesTransferredSoFar, int totalFilesToTransfer, TransferState transferState, Exception transferException, boolean intraFileStatusReport, String transferHost, String transferZone) throws JargonException {
        if (totalSize < 0L) {
            throw new JargonException("totalSize less than zero");
        }
        if (bytesTransferred < 0L) {
            throw new JargonException("bytesTransferred is less than zero");
        }
        if (!intraFileStatusReport) {
            if (totalFilesTransferredSoFar < 0) {
                throw new JargonException("totalFilesTransferredSoFar is less than zero");
            }
            if (totalFilesToTransfer < 0) {
                throw new JargonException("totalFilesToTransfer is less than zero");
            }
            if (transferType == null) {
                throw new JargonException("null transfer type");
            }
            if (sourceFileAbsolutePath == null || sourceFileAbsolutePath.isEmpty()) {
                throw new JargonException("null or empty sourceFileAbsolutePath");
            }
            if (targetFileAbsolutePath == null) {
                throw new JargonException("null  targetFileAbsolutePath");
            }
            if (targetResource == null) {
                throw new JargonException("null targetResource, set to blank if unused");
            }
            if (transferState == null) {
                throw new JargonException("null transferState");
            }
            if (transferHost == null || transferHost.isEmpty()) {
                throw new JargonException("null transferHost");
            }
            if (transferZone == null || transferZone.isEmpty()) {
                throw new JargonException("null transferZone");
            }
        }
        this.transferType = transferType;
        this.transferEnclosingType = transferEnclosingType;
        this.sourceFileAbsolutePath = sourceFileAbsolutePath;
        this.targetFileAbsolutePath = targetFileAbsolutePath;
        this.targetResource = targetResource;
        this.totalSize = totalSize;
        this.bytesTransfered = bytesTransferred;
        this.transferState = transferState;
        this.transferException = transferException;
        this.totalFilesToTransfer = totalFilesToTransfer;
        this.totalFilesTransferredSoFar = totalFilesTransferredSoFar;
        this.intraFileStatusReport = intraFileStatusReport;
        this.transferHost = transferHost;
        this.transferZone = transferZone;
    }

    public final TransferType getTransferType() {
        return this.transferType;
    }

    public final String getSourceFileAbsolutePath() {
        return this.sourceFileAbsolutePath;
    }

    public final String getTargetFileAbsolutePath() {
        return this.targetFileAbsolutePath;
    }

    public final long getTotalSize() {
        return this.totalSize;
    }

    public final long getBytesTransfered() {
        return this.bytesTransfered;
    }

    public final TransferState getTransferState() {
        return this.transferState;
    }

    public final Exception getTransferException() {
        return this.transferException;
    }

    public String getTargetResource() {
        return this.targetResource;
    }

    public int getTotalFilesToTransfer() {
        return this.totalFilesToTransfer;
    }

    public int getTotalFilesTransferredSoFar() {
        return this.totalFilesTransferredSoFar;
    }

    public boolean isIntraFileStatusReport() {
        return this.intraFileStatusReport;
    }

    public TransferType getTransferEnclosingType() {
        return this.transferEnclosingType;
    }

    public String getTransferHost() {
        return this.transferHost;
    }

    public String getTransferZone() {
        return this.transferZone;
    }

    public static enum TransferState {
        IN_PROGRESS_START_FILE,
        IN_PROGRESS_COMPLETE_FILE,
        SUCCESS,
        FAILURE,
        PAUSED,
        CANCELLED,
        RESTARTING,
        OVERALL_INITIATION,
        OVERALL_COMPLETION,
        SYNCH_INITIALIZATION,
        SYNCH_DIFF_GENERATION,
        SYNCH_DIFF_STEP,
        SYNCH_COMPLETION;

    }

    public static enum TransferType {
        PUT,
        GET,
        REPLICATE,
        COPY,
        SYNCH;

    }
}

