/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class IRODSDataConversionUtil {
    private IRODSDataConversionUtil() {
    }

    public static int getIntOrZeroFromIRODSValue(String irodsValue) {
        int result = 0;
        if (irodsValue == null) {
            throw new IllegalArgumentException("null irodsValue");
        }
        if (!irodsValue.isEmpty()) {
            try {
                result = Integer.parseInt(irodsValue);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("cannot format number:" + irodsValue, nfe);
            }
        }
        return result;
    }

    public static long getLongOrZeroFromIRODSValue(String irodsValue) {
        long result = 0L;
        if (irodsValue == null) {
            throw new IllegalArgumentException("null irodsValue");
        }
        if (!irodsValue.isEmpty()) {
            try {
                result = Long.parseLong(irodsValue);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("cannot format number:" + irodsValue, nfe);
            }
        }
        return result;
    }

    public static Date getDateFromIRODSValue(String irodsValue) {
        Integer dateInteger;
        if (irodsValue == null) {
            throw new IllegalArgumentException("null date value");
        }
        if (irodsValue.isEmpty()) {
            return new Date();
        }
        try {
            dateInteger = Integer.parseInt(irodsValue);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("malformed date value, cannot translate to integer:" + irodsValue);
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(timeZone);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.add(13, dateInteger);
        Date computedDate = calendar.getTime();
        return computedDate;
    }

    public static String escapeSingleQuotes(String inputString) {
        if (inputString == null) {
            throw new IllegalArgumentException("null inputString");
        }
        return inputString.replace("'", "\\'");
    }
}

