/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.RuleProcessingAOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileUtils {
    public static final Logger log = LoggerFactory.getLogger(LocalFileUtils.class);
    public static final DateFormat dateFormat = DateFormat.getDateTimeInstance();

    private LocalFileUtils() {
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null fileName");
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return fileName.substring(lastDot);
    }

    public static String getFileNameUpToExtension(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null fileName");
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return fileName.substring(0, lastDot);
    }

    public static String getFileNameWithTimeStampInterposed(String fileName) {
        String namePart = LocalFileUtils.getFileNameUpToExtension(fileName);
        String extension = LocalFileUtils.getFileExtension(fileName);
        StringBuilder newName = new StringBuilder(namePart);
        newName.append(".[backup from - ");
        newName.append(dateFormat.format(new Date()));
        newName.append("]");
        newName.append(extension);
        return newName.toString();
    }

    public static int countFilesInDirectory(File directory) {
        int count = 0;
        if (directory.isFile()) {
            count = 1;
        } else {
            for (File file : directory.listFiles()) {
                if (file.isFile()) {
                    ++count;
                }
                if (!file.isDirectory()) continue;
                count += LocalFileUtils.countFilesInDirectory(file);
            }
        }
        return count;
    }

    public static void createLocalFileIfNotExists(File localFileToHoldData) throws JargonException {
        if (localFileToHoldData.exists()) {
            log.info("local file exists, will not create the local file for {}", (Object)localFileToHoldData.getAbsolutePath());
        } else {
            log.info("local file does not exist, will attempt to create local file: {}", (Object)localFileToHoldData.getAbsolutePath());
            try {
                localFileToHoldData.createNewFile();
            }
            catch (IOException e) {
                log.error("IOException when trying to create a new file for the local output stream for {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
                throw new JargonException("IOException trying to create new file: " + localFileToHoldData.getAbsolutePath(), e);
            }
        }
    }

    public static long computeCRC32FileCheckSumViaAbsolutePath(String absolutePathToLocalFile) throws JargonException {
        FileInputStream file;
        try {
            file = new FileInputStream(absolutePathToLocalFile);
        }
        catch (FileNotFoundException e1) {
            throw new JargonException("error computing checksum, file not found:" + absolutePathToLocalFile, e1);
        }
        CheckedInputStream check = new CheckedInputStream(file, new CRC32());
        BufferedInputStream in = new BufferedInputStream(check);
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException e) {
            throw new JargonException("error computing checksum for file:" + absolutePathToLocalFile, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return check.getChecksum().getValue();
    }

    public static byte[] computeMD5FileCheckSumViaAbsolutePath(String absolutePathToLocalFile) throws JargonException {
        MessageDigest complete;
        FileInputStream file;
        try {
            file = new FileInputStream(absolutePathToLocalFile);
        }
        catch (FileNotFoundException e1) {
            throw new JargonException("error computing checksum, file not found:" + absolutePathToLocalFile, e1);
        }
        BufferedInputStream in = new BufferedInputStream(file);
        byte[] buffer = new byte[4096];
        try {
            complete = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("no such algorithm exception for MD5");
        }
        try {
            int numRead;
            do {
                if ((numRead = in.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            return byArray;
        }
        catch (Exception e) {
            throw new JargonException("Error computing MD5 checksum", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String md5ByteArrayToString(byte[] md5) {
        if (md5 == null || md5.length != 16) {
            throw new IllegalArgumentException("unknown format, not recognized as an MD5 checksum in a byte array");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append(String.format("%02x", md5[i]));
        }
        return sb.toString();
    }

    public static String getClasspathResourceFileAsString(String resourcePath) throws JargonException {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourcePath");
        }
        InputStreamReader resourceReader = new InputStreamReader(new BufferedInputStream(RuleProcessingAOImpl.class.getResourceAsStream(resourcePath)));
        StringWriter writer = null;
        String ruleString = null;
        try {
            writer = new StringWriter();
            char[] buff = new char[1024];
            int i = 0;
            while ((i = resourceReader.read(buff)) > -1) {
                writer.write(buff, 0, i);
            }
            ruleString = writer.toString();
        }
        catch (IOException ioe) {
            log.error("io exception reading rule data from resource", ioe);
            throw new JargonException("error reading rule from resource", ioe);
        }
        finally {
            try {
                resourceReader.close();
                writer.close();
            }
            catch (IOException e) {}
        }
        return ruleString;
    }
}

