/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.util.Arrays;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;

public class MiscIRODSUtils {
    private MiscIRODSUtils() {
    }

    public static String getDefaultIRODSResourceFromAccountIfFileInZone(String irodsAbsolutePath, IRODSAccount irodsAccount) {
        String defaultResource = "";
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null irodsAbsolutePath");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        List<String> pathComponents = MiscIRODSUtils.breakIRODSPathIntoComponents(irodsAbsolutePath);
        boolean inZone = MiscIRODSUtils.isFirstPartOfPathInZone(irodsAccount, pathComponents);
        if (inZone) {
            defaultResource = irodsAccount.getDefaultStorageResource();
        }
        return defaultResource;
    }

    public static boolean isFileInThisZone(String irodsAbsolutePath, IRODSAccount irodsAccount) {
        boolean inZone = true;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null irodsAbsolutePath");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        List<String> pathComponents = MiscIRODSUtils.breakIRODSPathIntoComponents(irodsAbsolutePath);
        inZone = MiscIRODSUtils.isFirstPartOfPathInZone(irodsAccount, pathComponents);
        return inZone;
    }

    public static String getZoneInPath(String irodsAbsolutePath) {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        List<String> pathComponents = MiscIRODSUtils.breakIRODSPathIntoComponents(irodsAbsolutePath);
        if (pathComponents.size() <= 1) {
            return null;
        }
        return pathComponents.get(1);
    }

    private static boolean isFirstPartOfPathInZone(IRODSAccount irodsAccount, List<String> pathComponents) {
        boolean inZone = true;
        if (!pathComponents.isEmpty() && pathComponents.size() != 1) {
            inZone = pathComponents.get(1).equals(irodsAccount.getZone());
        }
        return inZone;
    }

    public static List<String> breakIRODSPathIntoComponents(String irodsAbsolutePath) {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        String[] components = irodsAbsolutePath.split("/");
        return Arrays.asList(components);
    }

    public static String buildPathFromComponentsUpToIndex(List<String> pathComponents, int lastIndex) {
        if (pathComponents == null) {
            throw new IllegalArgumentException("null pathComponents");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String pathComponent : pathComponents) {
            if (pathComponent.isEmpty()) continue;
            if (lastIndex >= 0 && i++ >= lastIndex) break;
            sb.append("/");
            sb.append(pathComponent);
        }
        if (sb.length() == 0) {
            sb.append("/");
        }
        return sb.toString();
    }
}

