/*
 * Decompiled with CFR 0.152.
 */
package loci2vtk;

import java.io.File;
import java.util.prefs.Preferences;
import utils.Printer;

public class Parameters {
    private File destinationDirectory;
    private File sourceFile;
    private String experimentName;
    private boolean extractMetadataOnly;
    private boolean force8bits;
    private float[] customResolutions;
    private int[] customStrechingWindow;
    private int verboseLevel;
    public static final int QUIT_OK = 0;
    public static final int QUIT_SOURCE_NOT_VALID = 1;
    public static final int QUIT_UNKNOWN_STEP_SIZE = 2;
    public static final int QUIT_HEADLESS = 3;
    public static final int QUIT_WRONG_USAGE = 4;
    public static final int QUIT_SOURCE_NOT_READABLE = 5;
    public static final int QUIT_DESTINATION_NOT_WRITABLE = 6;
    public static final int QUIT_INVALID_EXPERIMENT_NAME = 7;
    public static final int QUIT_INVALID_EXPERIMENT_DATE = 8;
    public static final int QUIT_UNKNOWN_LATERAL_RESOLUTION = 9;
    public static final int QUIT_UNKNOWN_ERROR = 99;
    private static Preferences pref = Preferences.userRoot().node(new Parameters().getClass().getName());

    public Parameters() {
        this.destinationDirectory = null;
        this.sourceFile = null;
        this.experimentName = null;
        this.extractMetadataOnly = false;
        this.force8bits = false;
        this.customResolutions = null;
        this.customStrechingWindow = null;
        this.verboseLevel = 1;
    }

    public Parameters(String[] args) {
        this.parseParameters(args);
    }

    private void parseParameters(String[] args) {
        int i = 0;
        int l = args.length;
        while (i < l - 1) {
            if (args[i] == null) continue;
            if ("-d".equals(args[i])) {
                this.setDestination(new File(args[i + 1]));
                i += 2;
                continue;
            }
            if ("-e".equals(args[i])) {
                this.setExperimentName(args[i + 1]);
                i += 2;
                continue;
            }
            if ("-m".equals(args[i])) {
                this.setExtractMetadataOnly(true);
                ++i;
                continue;
            }
            if ("-v".equals(args[i])) {
                this.setVerboseMode(2);
                ++i;
                continue;
            }
            if ("-vv".equals(args[i])) {
                this.setVerboseMode(3);
                ++i;
                continue;
            }
            if ("-q".equals(args[i])) {
                this.setVerboseMode(0);
                ++i;
                continue;
            }
            if ("-f".equals(args[i])) {
                this.setForce8Bits(true);
                ++i;
                continue;
            }
            ++i;
        }
        this.setSource(new File(args[l - 1]));
        if (this.sourceFile == null) {
            Parameters.printUsage();
            System.exit(1);
        }
        if (this.destinationDirectory == null) {
            this.destinationDirectory = this.sourceFile.getParentFile();
        }
        if (this.experimentName == null) {
            String filename = this.sourceFile.getName();
            this.experimentName = filename.matches("^[0-9]{6}[a-z][A-Z].*$") ? filename.substring(0, 8) : (filename.matches("^[0-9]{6}[a-z].*$") ? filename.substring(0, 7) : null);
        }
    }

    public File getDestination() {
        return this.destinationDirectory;
    }

    public File getVTKDestination() {
        return new File(this.destinationDirectory, "VTK");
    }

    public File getSource() {
        return this.sourceFile;
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public boolean getExtractMetadataOnly() {
        return this.extractMetadataOnly;
    }

    public int getVerboseMode() {
        return this.verboseLevel;
    }

    public boolean force8Bits() {
        return this.force8bits;
    }

    public float[] getCustomResolutions() {
        return this.customResolutions;
    }

    public int[] getCustomStrechingWindow() {
        return this.customStrechingWindow;
    }

    public void setDestination(File f) {
        this.destinationDirectory = f.isDirectory() ? f : f.getParentFile();
    }

    public void setSource(File f) {
        this.sourceFile = f;
    }

    public void setExperimentName(String s) {
        this.experimentName = s;
    }

    public void setExtractMetadataOnly(boolean s) {
        this.extractMetadataOnly = s;
    }

    public void setVerboseMode(int s) {
        this.verboseLevel = s;
        Printer.setVerboseMode(this.verboseLevel);
    }

    public void setForce8Bits(boolean f) {
        this.force8bits = f;
    }

    public void setCustomResolutions(float[] resolutions) {
        this.customResolutions = resolutions;
    }

    public void setCustomStrechingWindow(int[] window) {
        this.customStrechingWindow = window;
    }

    public boolean isReady() {
        return this.destinationDirectory != null && this.sourceFile != null && this.experimentName != null;
    }

    public String toString() {
        return "[Source file]: " + (this.sourceFile == null ? "<null>" : this.sourceFile.getAbsolutePath()) + "\n[Destination directory]: " + (this.destinationDirectory == null ? "<null>" : this.destinationDirectory.getAbsolutePath()) + "\n[Experiment name]: " + (this.experimentName == null ? "<null>" : this.experimentName);
    }

    public static void printUsage() {
        System.out.println("NAME\n    loci2vtk - Convert LOCI compatible file format to compressed VTK for\n    BioEmergences\n\nLICENSE\n    GNU GENERAL PUBLIC LICENSE (Version 3, 29 June 2007)    Copyright (C)  2014  Dimitri Fabr\u00e8ges.\n    Permission is granted to copy, distribute and/or modify this document\n    under the terms of the GNU Free Documentation License, Version 1.3\n    or any later version published by the Free Software Foundation;\n    with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.\n    A copy of the license is included in the file license.txt\n\nSYNOPSIS\n    loci2vtk [-d DEST] [-e EXP] [-f] [-q|-v|-vv] SRC\n    loci2vtk [-d DEST] [-e EXP] [-m] [-q|-v|-vv] SRC\n    loci2vtk [-h]\n\nDESCRIPTION\n    Convert SRC files to a list of VTK files (one for each timestep).\n    SRC must be a single file. Other dataset's files will be automatically\n    loaded and converted too.\n    -d DEST\n        Specify a destination for the VTK. Default value is the same\n        directory as the one containing the SRC file.\n\n    -e EXP\n        Explicitly define the experiment name. Default value will be\n        calculated from the SRC file (the first 7 or 8 characters of the\n        filename depending on the microscope).\n\n    -m\n        Extract metadata only. If the -m option is used, -f and -u are disabled.\n\n    -f\n        Force VTK to be 8-bits data.\n\n    -q|-v|-vv\n        Verbose level:\n        -q : Quiet\n        -v: Verbose\n        -vv: Very verbose\n\n    -h\n        Display this message.\n\n    Exit status:\n        0    if OK or if the user quit the graphic interface,\n\n        1    if SRC file is not properly defined,\n\n        2    if z-step size could not be retrieved from the SRC file. This\n             may happend with new file type, or new version of file type,\n\n        3    if loci2vtk is run without argument in a headless\n             environment,\n\n        4    if parameters have not been properly specified,\n\n        5    if SRC file does not exist or is not reachable,\n\n        6    if DEST directory does not exist or is not reachable,\n\n        7    if EXP name is not valid. EXP should always start with 6\n             digits indicating the experiment date (yymmdd), follow by\n             one lower-case letter and an optional upper-case letter to\n             specify the microscope in use,\n\n        8    if EXP name is valid, but the date defined by the first six\n             digits does not exist (e.g. 130230: february, 30th 2013),\n\n        9    if the lateral resolution cannot be retrieved.\n\n        99   if an unknown error occured. See log for more details.\n\nAUTHORS\n        Written by Dimitri Fabr\u00e8ges 2013-2014, for BioEmergences");
    }

    public static String read(String key, String def) {
        return pref.get(key, def);
    }

    public static String read(String key) {
        return pref.get(key, null);
    }

    public static void write(String key, String value) {
        pref.put(key, value);
    }

    public static void clear(String key) {
        pref.remove(key);
    }
}

