/*
 * Decompiled with CFR 0.152.
 */
package loci2vtk;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.GregorianCalendar;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import loci2vtk.SettingsAdvanced;

public class Settings
extends JDialog
implements ActionListener {
    private static final int BROWSE_NOFLAG = 1;
    private static final int BROWSE_FLAG_DIRECTORY = 2;
    private File srcfile = null;
    private File desfile = null;
    private String expname = null;
    private boolean metadata = false;
    private boolean force8b = false;
    private float[] customResolutions = null;
    private int[] customStrechingWindow = null;
    private boolean cancel = true;
    private JToggleButton browseDestinationDirectory;
    private JToggleButton browseSourceFile;
    private JToggleButton convert;
    private JTextField destinationDirectory;
    private JLabel destinationDirectoryLabel;
    private JTextField experimentName;
    private JLabel experimentNameLabel;
    private JCheckBox extractMetadataOnly;
    private JCheckBox force8Bits;
    private JLabel logo;
    private JToggleButton more;
    private JTextField sourceFile;
    private JLabel sourceFileLabel;

    public Settings(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initEvents();
    }

    private void initEvents() {
        this.browseSourceFile.addActionListener(this);
        this.browseDestinationDirectory.addActionListener(this);
        this.extractMetadataOnly.addActionListener(this);
        this.convert.addActionListener(this);
        this.more.addActionListener(this);
    }

    private void initComponents() {
        this.logo = new JLabel();
        this.sourceFileLabel = new JLabel();
        this.sourceFile = new JTextField();
        this.browseSourceFile = new JToggleButton();
        this.destinationDirectoryLabel = new JLabel();
        this.destinationDirectory = new JTextField();
        this.browseDestinationDirectory = new JToggleButton();
        this.experimentNameLabel = new JLabel();
        this.experimentName = new JTextField();
        this.extractMetadataOnly = new JCheckBox();
        this.force8Bits = new JCheckBox();
        this.more = new JToggleButton();
        this.convert = new JToggleButton();
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(274, 385));
        this.setResizable(false);
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/resources/BioEmergences.png")));
        this.logo.setToolTipText("");
        this.sourceFileLabel.setFont(new Font("Tahoma", 0, 14));
        this.sourceFileLabel.setText("Source file:");
        this.sourceFile.setFont(new Font("Tahoma", 0, 14));
        this.browseSourceFile.setFont(new Font("Tahoma", 0, 14));
        this.browseSourceFile.setText("Browse...");
        this.destinationDirectoryLabel.setFont(new Font("Tahoma", 0, 14));
        this.destinationDirectoryLabel.setText("Destination directory:");
        this.destinationDirectory.setFont(new Font("Tahoma", 0, 14));
        this.browseDestinationDirectory.setFont(new Font("Tahoma", 0, 14));
        this.browseDestinationDirectory.setText("Browse...");
        this.experimentNameLabel.setFont(new Font("Tahoma", 0, 14));
        this.experimentNameLabel.setText("Experiment name:");
        this.experimentName.setFont(new Font("Tahoma", 0, 14));
        this.extractMetadataOnly.setFont(new Font("Tahoma", 0, 14));
        this.extractMetadataOnly.setText("Extract metadata only");
        this.force8Bits.setFont(new Font("Tahoma", 0, 14));
        this.force8Bits.setText("Force 8 bits conversion");
        this.more.setFont(new Font("Tahoma", 0, 14));
        this.more.setText("More...");
        this.convert.setFont(new Font("Tahoma", 0, 14));
        this.convert.setText("Convert");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.sourceFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseSourceFile)).addGroup(layout.createSequentialGroup().addComponent(this.destinationDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseDestinationDirectory)).addComponent(this.experimentName).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logo).addComponent(this.sourceFileLabel).addComponent(this.destinationDirectoryLabel).addComponent(this.experimentNameLabel).addComponent(this.extractMetadataOnly).addComponent(this.force8Bits)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.more, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.convert, -2, 91, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.logo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceFileLabel).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseSourceFile).addComponent(this.sourceFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.destinationDirectoryLabel).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseDestinationDirectory).addComponent(this.destinationDirectory, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.experimentNameLabel).addGap(0, 0, 0).addComponent(this.experimentName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.extractMetadataOnly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.force8Bits).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.more).addComponent(this.convert)).addContainerGap()));
        this.pack();
    }

    public File getSourceFile() {
        return this.srcfile;
    }

    public File getDestinationDirectory() {
        return this.desfile;
    }

    public String getExperimentName() {
        return this.expname;
    }

    public boolean getExtractMetadataOnly() {
        return this.metadata;
    }

    public boolean getForce8Bits() {
        return this.force8b;
    }

    public float[] getCustomResolutions() {
        return this.customResolutions;
    }

    public int[] getCustomStrechingWindow() {
        return this.customStrechingWindow;
    }

    public boolean wasCanceled() {
        return this.cancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.browseSourceFile)) {
            File f = this.browse(this.sourceFile.getText());
            if (f != null) {
                this.sourceFile.setText(f.getAbsolutePath());
                if ("".equals(this.experimentName.getText())) {
                    String filename = f.getName();
                    if (filename.matches("^[0-9]{6}[a-z][A-Z].*$")) {
                        this.experimentName.setText(filename.substring(0, 8));
                    } else if (filename.matches("^[0-9]{6}[a-z].*$")) {
                        this.experimentName.setText(filename.substring(0, 7));
                    }
                }
                this.srcfile = f;
            }
        } else if (e.getSource().equals(this.browseDestinationDirectory)) {
            File f = this.browse(this.destinationDirectory.getText().equals("") ? this.sourceFile.getText() : this.destinationDirectory.getText(), 2);
            if (f != null) {
                this.destinationDirectory.setText(f.getAbsolutePath());
            }
        } else if (e.getSource().equals(this.convert)) {
            if (this.checkFields()) {
                this.dispose();
            } else {
                this.cancel = true;
            }
        } else if (e.getSource().equals(this.more)) {
            if (this.checkFields()) {
                SettingsAdvanced sa = new SettingsAdvanced(null, true);
                sa.setLocationRelativeTo(null);
                sa.setVisible(true);
                if (!sa.wasCancelled()) {
                    if (sa.isCustomResolution()) {
                        this.customResolutions = new float[3];
                        this.customResolutions[0] = sa.getCustomDeltaX();
                        this.customResolutions[1] = sa.getCustomDeltaY();
                        this.customResolutions[2] = sa.getCustomDeltaZ();
                    } else {
                        this.customResolutions = null;
                    }
                    if (sa.isCustomStrechingWindow()) {
                        this.customStrechingWindow = new int[2];
                        this.customStrechingWindow[0] = sa.getCustomStrechingMin();
                        this.customStrechingWindow[1] = sa.getCustomStrechingMax();
                    } else {
                        this.customStrechingWindow = null;
                    }
                    this.dispose();
                } else {
                    this.cancel = true;
                }
            }
        } else if (e.getSource().equals(this.extractMetadataOnly)) {
            this.force8Bits.setEnabled(!this.extractMetadataOnly.isSelected());
        }
    }

    private boolean checkFields() {
        int date;
        int month;
        File des = new File(this.destinationDirectory.getText());
        String exp = this.experimentName.getText();
        if (!des.isDirectory()) {
            des = des.getParentFile();
        }
        if (this.srcfile == null) {
            JOptionPane.showMessageDialog(null, "No source file choosen", "I/O error", 0);
            return false;
        }
        if (!this.srcfile.exists()) {
            JOptionPane.showMessageDialog(null, this.srcfile.getName() + " does not exist or is not valid", "I/O error", 0);
            return false;
        }
        if (des == null) {
            JOptionPane.showMessageDialog(null, "No destination directory choosen", "I/O error", 0);
            return false;
        }
        if (!des.canWrite()) {
            JOptionPane.showMessageDialog(null, "Loci2VTK does not have permissions to write to the destination directory. It is most likely due to a file system not supported by your operating system.", "I/O error", 0);
            return false;
        }
        if (!des.exists()) {
            JOptionPane.showMessageDialog(null, des.getName() + " does not exist or is not valid", "I/O error", 0);
            return false;
        }
        if (!exp.matches("^[0-9]{6}[a-z][A-Z]?$")) {
            JOptionPane.showMessageDialog(null, "Experiment name is not a valid name", "Syntax error", 0);
            return false;
        }
        int year = 2000 + Integer.parseInt(exp.substring(0, 2));
        GregorianCalendar cal = new GregorianCalendar(year, month = Integer.parseInt(exp.substring(2, 4)) - 1, date = Integer.parseInt(exp.substring(4, 6)));
        if (cal.get(1) != year || cal.get(2) != month || cal.get(5) != date) {
            String expectedname = cal.get(1) - 2000 + "" + (cal.get(2) + 1) + "" + cal.get(5);
            String realname = year - 2000 + "" + (month + 1) + "" + date;
            JOptionPane.showMessageDialog(null, "Experiment name does not have a valid date (" + realname + " corresponds to " + expectedname + " in a regular calendar)", "Syntax error", 0);
            return false;
        }
        this.desfile = des;
        this.expname = exp;
        this.metadata = this.extractMetadataOnly.isSelected();
        this.force8b = this.force8Bits.isSelected() && !this.metadata;
        this.cancel = false;
        return true;
    }

    private File browse(String initial) {
        return this.browse(initial, 1);
    }

    private File browse(String initial, int flags) {
        boolean fordir = (flags & 2) == 2;
        JFileChooser jfc = new JFileChooser(initial);
        jfc.setFileSelectionMode(fordir ? 1 : 0);
        jfc.setDialogTitle("Select a " + (fordir ? "directory" : "file"));
        if (jfc.showDialog(null, "Select") == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }
}

