/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XMLParser {
    public static Document getXMLDocument(Hashtable<String, Object> metadata) {
        Element root = new Element("metadata");
        Enumeration<String> keys = metadata.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String val = metadata.get(key).toString().trim();
            String[] path = key.split("\\|");
            Element previous = root;
            int l = path.length;
            for (int i = 0; i < l; ++i) {
                previous.addContent(new Element("param").setText(key));
                Element next = new Element("value");
                previous.addContent(next);
                if (i == l - 1) {
                    next.setText(val);
                    continue;
                }
                previous = next;
            }
        }
        return new Document(root);
    }

    public static boolean writeOutXML(Document document, File file) {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        try {
            out.output(document, (OutputStream)new FileOutputStream(file));
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }
}

