/*
 * Decompiled with CFR 0.152.
 */
package eu.bioemergences.workflow.utils;

import eu.bioemergences.workflow.utils.InputStreamSinkEvent;
import eu.bioemergences.workflow.utils.InputStreamSinkListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

public class InputStreamSink
implements Runnable {
    private final InputStream m_in;
    private final String m_streamName;
    private final boolean m_error;
    private boolean stop = false;
    private boolean closed = false;
    private final ArrayList<InputStreamSinkListener> inputStreamSinkListeners = new ArrayList();

    public InputStreamSink(InputStream in, String streamName) {
        this(in, streamName, false);
    }

    public InputStreamSink(InputStream in, String streamName, boolean errorOnly) {
        this.m_in = in;
        this.m_streamName = streamName;
        this.m_error = errorOnly;
    }

    @Override
    public void run() {
        this.stop = false;
        this.closed = false;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(this.m_in));
            while ((line = reader.readLine()) != null && !this.stop) {
                line = line + "\n";
                if (this.m_error) {
                    this.fireErrorOutput(line);
                } else {
                    this.fireStandardOutput(line);
                }
                if (!Thread.interrupted()) continue;
                this.stop();
            }
        }
        catch (IOException e) {
            this.fireErrorOutput(e.getMessage());
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.fireErrorOutput(e.getMessage());
            }
            this.close();
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void close() {
        this.fireStreamClosed();
        this.closed = true;
    }

    public InputStreamSink addInputStreamSinkListener(InputStreamSinkListener listener) {
        if (!this.inputStreamSinkListeners.contains(listener)) {
            this.inputStreamSinkListeners.add(listener);
        }
        return this;
    }

    public InputStreamSink removeInputStreamSinkListener(InputStreamSinkListener listener) {
        this.inputStreamSinkListeners.remove(listener);
        return this;
    }

    public boolean isStop() {
        return this.stop;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void fireStandardOutput(String message) {
        Iterator<InputStreamSinkListener> i = this.inputStreamSinkListeners.iterator();
        while (i.hasNext()) {
            i.next().printOut(message);
        }
    }

    private void fireErrorOutput(String error) {
        Iterator<InputStreamSinkListener> i = this.inputStreamSinkListeners.iterator();
        while (i.hasNext()) {
            i.next().printErr(error);
        }
    }

    private void fireStreamClosed() {
        InputStreamSinkEvent ev = new InputStreamSinkEvent(this);
        Iterator<InputStreamSinkListener> i = this.inputStreamSinkListeners.iterator();
        while (i.hasNext()) {
            i.next().closed(ev);
        }
    }
}

