/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;

public class ConnectionProxyDefinition {
    private final String role;
    private final IRODSAccount irodsAccount;

    public static ConnectionProxyDefinition instance(String role, IRODSAccount irodsAccount) throws JargonException {
        return new ConnectionProxyDefinition(role, irodsAccount);
    }

    private ConnectionProxyDefinition(String role, IRODSAccount irodsAccount) throws JargonException {
        if (role == null || role.isEmpty()) {
            throw new JargonException("role is null or empty");
        }
        if (irodsAccount == null) {
            throw new JargonException("irodsAccount is null");
        }
        this.role = role;
        this.irodsAccount = irodsAccount;
    }

    public String getRole() {
        return this.role;
    }

    public IRODSAccount getIrodsAccount() {
        return this.irodsAccount;
    }
}

