/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentalInfoAccessor {
    private IRODSCommands irodsProtocol = null;
    private Logger log = LoggerFactory.getLogger(EnvironmentalInfoAccessor.class);

    public EnvironmentalInfoAccessor(IRODSCommands irodsProtocol) throws JargonException {
        if (irodsProtocol == null) {
            throw new JargonException("null irodsProtocol");
        }
        if (!irodsProtocol.isConnected()) {
            throw new JargonException("irods protocol is not connected");
        }
        this.irodsProtocol = irodsProtocol;
    }

    public IRODSServerProperties getIRODSServerProperties() throws JargonException {
        this.log.info("getting irods server properties");
        Tag response = this.irodsProtocol.irodsFunction("MiscSvrInfo_PI", "", 700);
        this.log.info("server response obtained");
        int serverType = response.getTag("serverType").getIntValue();
        IRODSServerProperties.IcatEnabled icatEnabled = null;
        icatEnabled = serverType == 1 ? IRODSServerProperties.IcatEnabled.ICAT_ENABLED : IRODSServerProperties.IcatEnabled.NO_ICAT;
        int serverBootTime = response.getTag("serverBootTime").getIntValue();
        String relVersion = response.getTag("relVersion").getStringValue();
        String apiVersion = response.getTag("apiVersion").getStringValue();
        String rodsZone = response.getTag("rodsZone").getStringValue();
        return IRODSServerProperties.instance(icatEnabled, serverBootTime, relVersion, apiVersion, rodsZone);
    }
}

