/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.ietf.jgss.GSSCredential;
import org.irods.jargon.core.exception.JargonException;

public final class IRODSAccount
implements Serializable {
    private static final long serialVersionUID = 8627989693793656697L;
    public static final String IRODS_VERSION_3_0 = "rods3.0jargon3.0";
    public static final String IRODS_JARGON_RELEASE_NUMBER = "rods3.0";
    private final transient GSSCredential gssCredential;
    public static final String IRODS_API_VERSION = "d";
    public static final String PUBLIC_USERNAME = "anonymous";
    public static final String STANDARD_PASSWORD = "PASSWORD";
    public static final String GSI_PASSWORD = "GSI";
    private final String certificateAuthority;
    public static final boolean defaultObfuscate = false;
    private final String host;
    private final int port;
    private final String zone;
    private final String userName;
    private final String password;
    private final String defaultStorageResource;
    private final String homeDirectory;
    private static final String authenticationScheme = "PASSWORD";
    private final String serverDN;
    private List<String> authenticatedRoles = new ArrayList<String>();

    public static IRODSAccount instance(String host, int port, String userName, String password, String homeDirectory, String zone, String defaultStorageResource) throws JargonException {
        if (host == null || userName == null || password == null || homeDirectory == null || zone == null || defaultStorageResource == null) {
            throw new JargonException("IRODSAccount values cannot be initialized with null");
        }
        if (host.length() == 0 || userName.length() == 0 || password.length() == 0 || zone.length() == 0) {
            throw new JargonException("data cannot be blank when initializing with this method");
        }
        return new IRODSAccount(host, port, userName, password, homeDirectory, zone, defaultStorageResource);
    }

    public static IRODSAccount instanceForReroutedHost(IRODSAccount initialAccount, String reroutedHostName) throws JargonException {
        if (initialAccount == null) {
            throw new IllegalArgumentException("null initialAccount");
        }
        if (reroutedHostName == null || reroutedHostName.isEmpty()) {
            throw new IllegalArgumentException("null or empty reroutedHostName");
        }
        return new IRODSAccount(reroutedHostName, initialAccount.getPort(), initialAccount.getUserName(), initialAccount.getPassword(), initialAccount.getHomeDirectory(), initialAccount.getZone(), initialAccount.getDefaultStorageResource());
    }

    public static IRODSAccount instance(String host, int port, GSSCredential gssCredential) {
        return new IRODSAccount(host, port, gssCredential, "", "");
    }

    public static IRODSAccount instance(String host, int port, GSSCredential gssCredential, String homeDirectory, String defaultStorageResource) throws JargonException {
        if (host == null || gssCredential == null || homeDirectory == null || defaultStorageResource == null) {
            throw new JargonException("IRODSAccount initialized with null values");
        }
        return new IRODSAccount(host, port, gssCredential, homeDirectory, defaultStorageResource);
    }

    public IRODSAccount(String host, int port, String userName, String password, String homeDirectory, String zone, String defaultStorageResource) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.homeDirectory = homeDirectory;
        this.zone = zone;
        this.defaultStorageResource = defaultStorageResource;
        this.serverDN = "";
        this.gssCredential = null;
        this.certificateAuthority = "";
    }

    private IRODSAccount(String host, int port, GSSCredential gssCredential) {
        this(host, port, gssCredential, "", "");
    }

    private IRODSAccount(String host, int port, GSSCredential gssCredential, String homeDirectory, String defaultStorageResource) {
        this.host = host;
        this.port = port;
        this.userName = "";
        this.password = "";
        this.homeDirectory = homeDirectory;
        this.zone = "";
        this.defaultStorageResource = defaultStorageResource;
        this.serverDN = "";
        this.certificateAuthority = "";
        this.gssCredential = gssCredential;
    }

    public String getDefaultStorageResource() {
        return this.defaultStorageResource;
    }

    public String getAuthenticationScheme() {
        return "PASSWORD";
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public String getZone() {
        return this.zone;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            IRODSAccount temp = (IRODSAccount)obj;
            if (!this.getHost().equals(temp.getHost())) {
                return false;
            }
            if (this.getPort() != temp.getPort()) {
                return false;
            }
            if (!this.getUserName().equals(temp.getUserName())) {
                return false;
            }
            return this.getPassword().equals(temp.getPassword());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.host.hashCode() + this.port + this.userName.hashCode() + this.password.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("irods://");
        sb.append(this.getUserName());
        sb.append("@");
        sb.append(this.getHost());
        sb.append(":");
        sb.append(this.getPort());
        return sb.toString();
    }

    public URI toURI(boolean includePassword) throws JargonException {
        URI uri = null;
        try {
            uri = includePassword ? new URI("irods://" + this.getUserName() + ":" + this.getPassword() + "@" + this.getHost() + ":" + this.getPort() + this.getHomeDirectory()) : new URI("irods://" + this.getUserName() + "@" + this.getHost() + ":" + this.getPort() + this.getHomeDirectory());
        }
        catch (URISyntaxException e) {
            throw new JargonException("cannot convert this account into a URI:" + this, e);
        }
        return uri;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public GSSCredential getGssCredential() {
        return this.gssCredential;
    }

    public static String getPublicUsername() {
        return PUBLIC_USERNAME;
    }

    public static String getStandardPassword() {
        return "PASSWORD";
    }

    public static String getGsiPassword() {
        return GSI_PASSWORD;
    }

    public static boolean isDefaultObfuscate() {
        return false;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    protected List<String> getAuthenticatedRoles() {
        return this.authenticatedRoles;
    }

    protected void setAuthenticatedRoles(List<String> authenticatedRoles) {
        this.authenticatedRoles = authenticatedRoles;
    }
}

