/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.DefaultPropertiesJargonConfig;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.exception.JargonException;

public class SettableJargonProperties
implements JargonProperties {
    private boolean useParallelTransfer = true;
    private int maxParallelThreads = 4;
    private int maxFilesAndDirsQueryMax = 5000;
    private boolean useTransferThreadsPool = false;
    private int transferThreadPoolMaxSimultaneousTransfers = 4;
    private int transferThreadPoolTimeoutMillis = 60000;
    private boolean allowPutGetResourceRedirects = false;
    private boolean computeChecksumAfterTransfer = false;
    private boolean computeAndVerifyChecksumAfterTransfer = false;
    private boolean intraFileStatusCallbacks = false;
    private int irodsSocketTimeout = 0;
    private int irodsParallelSocketTimeout = 0;
    private int internalInputStreamBufferSize = 0;
    private int internalOutputStreamBufferSize = -1;
    private int internalCacheBufferSize = 65535;
    private int sendInputStreamBufferSize = 0;
    private int localFileOutputStreamBufferSize = 0;
    private int putBufferSize = 0x400000;
    private int getBufferSize = 0x400000;
    private int inputToOutputCopyBufferByteSize = 8192;
    private String encoding = "UTF-8";

    public SettableJargonProperties(JargonProperties jargonProperties) {
        this.initialize(jargonProperties);
    }

    public SettableJargonProperties() throws JargonException {
        DefaultPropertiesJargonConfig jargonProperties = new DefaultPropertiesJargonConfig();
        this.initialize(jargonProperties);
    }

    private void initialize(JargonProperties jargonProperties) {
        if (jargonProperties == null) {
            throw new IllegalArgumentException("null jargonProperties");
        }
        this.useParallelTransfer = jargonProperties.isUseParallelTransfer();
        this.maxFilesAndDirsQueryMax = jargonProperties.getMaxFilesAndDirsQueryMax();
        this.allowPutGetResourceRedirects = jargonProperties.isAllowPutGetResourceRedirects();
        this.computeAndVerifyChecksumAfterTransfer = jargonProperties.isComputeAndVerifyChecksumAfterTransfer();
        this.computeChecksumAfterTransfer = jargonProperties.isComputeChecksumAfterTransfer();
        this.intraFileStatusCallbacks = jargonProperties.isIntraFileStatusCallbacks();
        this.irodsParallelSocketTimeout = jargonProperties.getIRODSParallelTransferSocketTimeout();
        this.irodsSocketTimeout = jargonProperties.getIRODSSocketTimeout();
        this.maxParallelThreads = jargonProperties.getMaxParallelThreads();
        this.transferThreadPoolTimeoutMillis = jargonProperties.getTransferThreadPoolTimeoutMillis();
        this.transferThreadPoolMaxSimultaneousTransfers = jargonProperties.getTransferThreadPoolMaxSimultaneousTransfers();
        this.internalInputStreamBufferSize = jargonProperties.getInternalInputStreamBufferSize();
        this.internalOutputStreamBufferSize = jargonProperties.getInternalOutputStreamBufferSize();
        this.internalCacheBufferSize = jargonProperties.getInternalCacheBufferSize();
        this.sendInputStreamBufferSize = jargonProperties.getSendInputStreamBufferSize();
        this.localFileOutputStreamBufferSize = jargonProperties.getLocalFileOutputStreamBufferSize();
        this.putBufferSize = jargonProperties.getPutBufferSize();
        this.getBufferSize = jargonProperties.getGetBufferSize();
        this.encoding = jargonProperties.getEncoding();
    }

    @Override
    public synchronized boolean isUseParallelTransfer() {
        return this.useParallelTransfer;
    }

    public synchronized void setUseParallelTransfer(boolean useParallelTransfer) {
        this.useParallelTransfer = useParallelTransfer;
    }

    public synchronized void setMaxParallelThreads(int maxParallelThreads) {
        this.maxParallelThreads = maxParallelThreads;
    }

    @Override
    public synchronized int getMaxParallelThreads() {
        return this.maxParallelThreads;
    }

    @Override
    public synchronized int getMaxFilesAndDirsQueryMax() {
        return this.maxFilesAndDirsQueryMax;
    }

    @Override
    public synchronized boolean isUseTransferThreadsPool() {
        return this.useTransferThreadsPool;
    }

    @Override
    public synchronized int getTransferThreadPoolTimeoutMillis() {
        return this.transferThreadPoolTimeoutMillis;
    }

    public synchronized void setMaxFilesAndDirsQueryMax(int maxFilesAndDirsQueryMax) {
        this.maxFilesAndDirsQueryMax = maxFilesAndDirsQueryMax;
    }

    public synchronized void setUseTransferThreadsPool(boolean useTransferThreadsPool) {
        this.useTransferThreadsPool = useTransferThreadsPool;
    }

    public synchronized void setTransferThreadPoolTimeoutMillis(int transferThreadPoolTimeoutMillis) {
        this.transferThreadPoolTimeoutMillis = transferThreadPoolTimeoutMillis;
    }

    @Override
    public synchronized boolean isAllowPutGetResourceRedirects() {
        return this.allowPutGetResourceRedirects;
    }

    public synchronized void setAllowPutGetResourceRedirects(boolean allowPutGetResourceRedirects) {
        this.allowPutGetResourceRedirects = allowPutGetResourceRedirects;
    }

    @Override
    public synchronized boolean isComputeChecksumAfterTransfer() {
        return this.computeChecksumAfterTransfer;
    }

    public synchronized void setComputeChecksumAfterTransfer(boolean computeChecksumAfterTransfer) {
        this.computeChecksumAfterTransfer = computeChecksumAfterTransfer;
    }

    @Override
    public synchronized boolean isComputeAndVerifyChecksumAfterTransfer() {
        return this.computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized void setComputeAndVerifyChecksumAfterTransfer(boolean computeAndVerifyChecksumAfterTransfer) {
        this.computeAndVerifyChecksumAfterTransfer = computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized void setIntraFileStatusCallbacks(boolean intraFileStatusCallbacks) {
        this.intraFileStatusCallbacks = intraFileStatusCallbacks;
    }

    @Override
    public synchronized boolean isIntraFileStatusCallbacks() {
        return this.intraFileStatusCallbacks;
    }

    @Override
    public synchronized int getIRODSSocketTimeout() {
        return this.irodsSocketTimeout;
    }

    public synchronized void setIRODSSocketTimeout(int irodsSocketTimeout) {
        this.irodsSocketTimeout = irodsSocketTimeout;
    }

    @Override
    public synchronized int getIRODSParallelTransferSocketTimeout() {
        return this.irodsParallelSocketTimeout;
    }

    public synchronized void setIRODSParallelTransferSocketTimeout(int irodsParallelSocketTimeout) {
        this.irodsParallelSocketTimeout = irodsParallelSocketTimeout;
    }

    @Override
    public synchronized int getTransferThreadPoolMaxSimultaneousTransfers() {
        return this.transferThreadPoolMaxSimultaneousTransfers;
    }

    @Override
    public synchronized int getInternalInputStreamBufferSize() {
        return this.internalInputStreamBufferSize;
    }

    @Override
    public synchronized int getInternalOutputStreamBufferSize() {
        return this.internalOutputStreamBufferSize;
    }

    @Override
    public synchronized int getInternalCacheBufferSize() {
        return this.internalCacheBufferSize;
    }

    @Override
    public synchronized int getSendInputStreamBufferSize() {
        return this.sendInputStreamBufferSize;
    }

    @Override
    public synchronized int getInputToOutputCopyBufferByteSize() {
        return this.inputToOutputCopyBufferByteSize;
    }

    @Override
    public synchronized int getLocalFileOutputStreamBufferSize() {
        return this.localFileOutputStreamBufferSize;
    }

    public synchronized void setTransferThreadPoolMaxSimultaneousTransfers(int transferThreadPoolMaxSimultaneousTransfers) {
        this.transferThreadPoolMaxSimultaneousTransfers = transferThreadPoolMaxSimultaneousTransfers;
    }

    public synchronized void setInternalInputStreamBufferSize(int internalInputStreamBufferSize) {
        this.internalInputStreamBufferSize = internalInputStreamBufferSize;
    }

    public synchronized void setInternalOutputStreamBufferSize(int internalOutputStreamBufferSize) {
        this.internalOutputStreamBufferSize = internalOutputStreamBufferSize;
    }

    public synchronized void setInternalCacheBufferSize(int internalCacheBufferSize) {
        this.internalCacheBufferSize = internalCacheBufferSize;
    }

    public synchronized void setSendInputStreamBufferSize(int sendInputStreamBufferSize) {
        this.sendInputStreamBufferSize = sendInputStreamBufferSize;
    }

    public synchronized void setLocalFileOutputStreamBufferSize(int localFileOutputStreamBufferSize) {
        this.localFileOutputStreamBufferSize = localFileOutputStreamBufferSize;
    }

    @Override
    public synchronized int getIrodsSocketTimeout() {
        return this.irodsSocketTimeout;
    }

    public synchronized void setIrodsSocketTimeout(int irodsSocketTimeout) {
        this.irodsSocketTimeout = irodsSocketTimeout;
    }

    @Override
    public synchronized int getIrodsParallelSocketTimeout() {
        return this.irodsParallelSocketTimeout;
    }

    public synchronized void setIrodsParallelSocketTimeout(int irodsParallelSocketTimeout) {
        this.irodsParallelSocketTimeout = irodsParallelSocketTimeout;
    }

    @Override
    public int getPutBufferSize() {
        return this.putBufferSize;
    }

    @Override
    public int getGetBufferSize() {
        return this.getBufferSize;
    }

    public synchronized void setPutBufferSize(int putBufferSize) {
        this.putBufferSize = putBufferSize;
    }

    public synchronized void setGetBufferSize(int getBufferSize) {
        this.getBufferSize = getBufferSize;
    }

    public synchronized void setInputToOutputCopyBufferByteSize(int inputToOutputCopyBufferByteSize) {
        this.inputToOutputCopyBufferByteSize = inputToOutputCopyBufferByteSize;
    }

    @Override
    public synchronized String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            throw new IllegalArgumentException("encoding is null or empty");
        }
        this.encoding = encoding;
    }
}

