/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class DataObjCloseInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "dataObjCloseInp_PI";
    public static final String L1_DESC_INX = "l1descInx";
    public static final String BYTES_WRITTEN = "bytesWritten";
    public static final int FILE_CLOSE_API_NBR = 605;
    private final int fileDescriptor;
    private final long bytesWritten;

    public static final DataObjCloseInp instance(int fileDescriptor, long bytesWritten) throws JargonException {
        return new DataObjCloseInp(fileDescriptor, bytesWritten);
    }

    private DataObjCloseInp(int fileDescriptor, long bytesWritten) throws JargonException {
        if (fileDescriptor < 1) {
            throw new JargonException("invalid file descriptor:" + fileDescriptor);
        }
        if (bytesWritten < 0L) {
            throw new JargonException("invalid bytes written value:" + bytesWritten);
        }
        this.fileDescriptor = fileDescriptor;
        this.bytesWritten = bytesWritten;
    }

    public int getFileDescriptor() {
        return this.fileDescriptor;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(L1_DESC_INX, this.getFileDescriptor()), new Tag(BYTES_WRITTEN, this.getBytesWritten())});
        return message;
    }
}

