/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.domain.AvuData;

public class ModAvuMetadataInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "ModAVUMetadataInp_PI";
    public static final String ARG_PREFIX = "arg";
    public static final int MOD_AVU_API_NBR = 706;
    private final String targetIdentifier;
    private final MetadataTargetType metadataTargetType;
    private final AvuData avuData;
    private final AvuData newAvuData;
    private final ActionType actionType;

    public static final ModAvuMetadataInp instanceForAddCollectionMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.COLLECTION, avuData, null, ActionType.ADD);
    }

    public static final ModAvuMetadataInp instanceForModifyCollectionMetadata(String targetIdentifier, AvuData avuData, AvuData newAvuData) {
        if (newAvuData == null) {
            throw new IllegalArgumentException("Null newAvuData");
        }
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.COLLECTION, avuData, newAvuData, ActionType.MOD);
    }

    public static final ModAvuMetadataInp instanceForDeleteCollectionMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.COLLECTION, avuData, null, ActionType.REMOVE);
    }

    public static final ModAvuMetadataInp instanceForAddDataObjectMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.DATA_OBJECT, avuData, null, ActionType.ADD);
    }

    public static final ModAvuMetadataInp instanceForModifyDataObjectMetadata(String targetIdentifier, AvuData avuData, AvuData newAvuData) {
        if (newAvuData == null) {
            throw new IllegalArgumentException("Null newAvuData");
        }
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.DATA_OBJECT, avuData, newAvuData, ActionType.MOD);
    }

    public static final ModAvuMetadataInp instanceForDeleteDataObjectMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.DATA_OBJECT, avuData, null, ActionType.REMOVE);
    }

    public static final ModAvuMetadataInp instanceForAddResourceMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.RESOURCE, avuData, null, ActionType.ADD);
    }

    public static final ModAvuMetadataInp instanceForModifyResourceMetadata(String targetIdentifier, AvuData avuData, AvuData newAvuData) {
        if (newAvuData == null) {
            throw new IllegalArgumentException("Null newAvuData");
        }
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.RESOURCE, avuData, newAvuData, ActionType.MOD);
    }

    public static final ModAvuMetadataInp instanceForDeleteResourceMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.RESOURCE, avuData, null, ActionType.REMOVE);
    }

    public static final ModAvuMetadataInp instanceForAddUserMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.USER, avuData, null, ActionType.ADD);
    }

    public static final ModAvuMetadataInp instanceForModifyUserMetadata(String targetIdentifier, AvuData avuData, AvuData newAvuData) {
        if (newAvuData == null) {
            throw new IllegalArgumentException("Null newAvuData");
        }
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.USER, avuData, newAvuData, ActionType.MOD);
    }

    public static final ModAvuMetadataInp instanceForDeleteUserMetadata(String targetIdentifier, AvuData avuData) {
        return new ModAvuMetadataInp(targetIdentifier, MetadataTargetType.USER, avuData, null, ActionType.REMOVE);
    }

    private ModAvuMetadataInp(String targetIdentifier, MetadataTargetType metadataTargetType, AvuData avuData, AvuData newAvuData, ActionType actionType) {
        if (targetIdentifier == null || targetIdentifier.isEmpty()) {
            throw new IllegalArgumentException("null or empty target identifier");
        }
        if (metadataTargetType == null) {
            throw new IllegalArgumentException("metadataTargetType is null");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null or missing avuData");
        }
        if (actionType == null) {
            throw new IllegalArgumentException("null action type");
        }
        this.targetIdentifier = targetIdentifier;
        this.metadataTargetType = metadataTargetType;
        this.avuData = avuData;
        this.actionType = actionType;
        this.newAvuData = newAvuData;
        this.setApiNumber(706);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        ArrayList<String> argList = new ArrayList<String>();
        Tag message = new Tag(PI_TAG);
        if (this.actionType == ActionType.ADD) {
            argList.add("add");
        } else if (this.actionType == ActionType.REMOVE) {
            argList.add("rmw");
        } else if (this.actionType == ActionType.MOD) {
            argList.add("mod");
        }
        if (this.metadataTargetType == MetadataTargetType.COLLECTION) {
            argList.add("-c");
        } else if (this.metadataTargetType == MetadataTargetType.DATA_OBJECT) {
            argList.add("-d");
        } else if (this.metadataTargetType == MetadataTargetType.RESOURCE) {
            argList.add("-R");
        } else if (this.metadataTargetType == MetadataTargetType.USER) {
            argList.add("-u");
        } else {
            throw new JargonException("metadata target type is not currently supported:" + (Object)((Object)this.metadataTargetType));
        }
        argList.add(this.targetIdentifier);
        argList.add(this.avuData.getAttribute());
        argList.add(this.avuData.getValue());
        if (!this.avuData.getUnit().isEmpty()) {
            argList.add(this.avuData.getUnit());
        }
        if (this.actionType == ActionType.MOD) {
            StringBuilder sb = new StringBuilder();
            if (!this.newAvuData.getAttribute().isEmpty()) {
                sb.append("n:");
                sb.append(this.newAvuData.getAttribute());
                argList.add(sb.toString());
            }
            sb = new StringBuilder();
            if (!this.newAvuData.getValue().isEmpty()) {
                sb.append("v:");
                sb.append(this.newAvuData.getValue());
                argList.add(sb.toString());
            }
            sb = new StringBuilder();
            if (!this.newAvuData.getUnit().isEmpty()) {
                sb.append("u:");
                sb.append(this.newAvuData.getUnit());
                argList.add(sb.toString());
            }
        }
        String val = "";
        for (int i = 0; i < 10; ++i) {
            StringBuilder argBuilder = new StringBuilder(ARG_PREFIX);
            argBuilder.append(i);
            val = "";
            if (i < argList.size()) {
                val = (String)argList.get(i);
            }
            message.addTag(argBuilder.toString(), val);
        }
        return message;
    }

    public String getTargetIdentifier() {
        return this.targetIdentifier;
    }

    public MetadataTargetType getMetadataTargetType() {
        return this.metadataTargetType;
    }

    public AvuData getAvuData() {
        return this.avuData;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public AvuData getNewAvuData() {
        return this.newAvuData;
    }

    public static enum ActionType {
        ADD,
        REMOVE,
        MOD;

    }

    public static enum MetadataTargetType {
        RESOURCE,
        USER,
        COLLECTION,
        DATA_OBJECT;

    }
}

