/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tag
implements Cloneable {
    public static final char OPEN_START_TAG = '<';
    public static final char CLOSE_START_TAG = '>';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    private static Logger log = LoggerFactory.getLogger(Tag.class);
    String tagName;
    public Tag[] tags;
    String value;

    public Tag(String tagName) {
        this.tagName = tagName;
    }

    public Tag(String tagName, int value) {
        this.tagName = tagName;
        this.value = "" + value;
    }

    public Tag(String tagName, long value) {
        this.tagName = tagName;
        this.value = "" + value;
    }

    public Tag(String tagName, String value) {
        this.tagName = tagName;
        this.value = value;
    }

    public Tag(String tagName, Tag tag) {
        this(tagName, new Tag[]{tag});
    }

    public Tag(String tagName, Tag[] tags) {
        this.tagName = tagName;
        this.tags = tags;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setValue(int value) {
        this.value = "" + value;
    }

    public void setValue(long value) {
        this.value = "" + value;
    }

    public void setValue(String value, boolean decode) {
        if (value == null) {
            this.value = null;
            return;
        }
        if (decode) {
            value = value.replaceAll("&amp;", "&");
            value = value.replaceAll("&lt;", "<");
            value = value.replaceAll("&gt;", ">");
            value = value.replaceAll("&quot;", "\"");
            value = value.replaceAll("&apos;", "`");
        }
        this.value = value;
    }

    public Object getValue() {
        if (this.tags != null) {
            return this.tags.clone();
        }
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.value);
    }

    public long getLongValue() {
        return Long.parseLong(this.value);
    }

    public String getStringValue() {
        return this.value;
    }

    public String getName() {
        return this.tagName;
    }

    public int getLength() {
        return this.tags.length;
    }

    public Tag getTag(String tagName) {
        if (this.tags == null) {
            return null;
        }
        for (Tag tag : this.tags) {
            if (!tag.getName().equals(tagName)) continue;
            return tag;
        }
        return null;
    }

    public Tag getTag(String tagName, int index) {
        if (this.tags == null) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].getName().equals(tagName)) continue;
            if (index == j) {
                return this.tags[i];
            }
            ++j;
        }
        return null;
    }

    public Tag[] getTags() {
        if (this.tags != null) {
            return this.tags;
        }
        return null;
    }

    public Object[] getTagValues() {
        if (this.tags == null) {
            return null;
        }
        Object[] val = new Object[this.tags.length];
        for (int i = 0; i < this.tags.length; ++i) {
            val[i] = this.tags[i].getValue();
        }
        return val;
    }

    public void addTag(String name, String val) {
        this.addTag(new Tag(name, val));
    }

    public void addTag(Tag add) {
        if (this.tags != null) {
            Tag[] temp = this.tags;
            this.tags = new Tag[temp.length + 1];
            System.arraycopy(temp, 0, this.tags, 0, temp.length);
            this.tags[temp.length] = add;
        } else {
            this.tags = new Tag[]{add};
        }
    }

    public void addTags(Tag[] add) {
        if (this.tags != null) {
            Tag[] temp = this.tags;
            this.tags = new Tag[temp.length + add.length];
            System.arraycopy(temp, 0, this.tags, 0, temp.length);
            System.arraycopy(add, 0, this.tags, temp.length, add.length);
        } else {
            this.tags = add;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        Tag newTag;
        return obj instanceof Tag && (newTag = (Tag)obj).getName().equals(this.tagName) && newTag.getValue().equals(this.value) && newTag.getTags() == this.tags;
    }

    public String toString() {
        return this.tagName;
    }

    public String parseTag() {
        StringBuffer parsed = new StringBuffer('<' + this.tagName + '>');
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                parsed.append(tag.parseTag());
            }
        } else {
            parsed.append(this.escapeChars(this.value));
        }
        parsed.append(OPEN_END_TAG + this.tagName + '>' + "\n");
        return parsed.toString();
    }

    String escapeChars(String out) {
        if (out == null) {
            return null;
        }
        out = out.replaceAll("&", "&amp;");
        out = out.replaceAll("<", "&lt;");
        out = out.replaceAll(">", "&gt;");
        out = out.replaceAll("\"", "&quot;");
        return out.replaceAll("`", "&apos;");
    }

    public static void status(Tag message) throws IOException {
        Tag s = message.getTag("status");
        if (s != null && s.getIntValue() < 0) {
            throw new JargonRuntimeException("" + s.getIntValue());
        }
    }

    public static Tag readNextTag(byte[] data, String encoding) throws UnsupportedEncodingException {
        return Tag.readNextTag(data, true, encoding);
    }

    public static Tag readNextTag(byte[] data, boolean decode, String encoding) throws UnsupportedEncodingException {
        if (data == null) {
            return null;
        }
        String d = new String(data, encoding);
        if (log.isTraceEnabled()) {
            log.trace(d);
        }
        d = d.replaceAll(">\n", ">");
        int start = d.indexOf(60);
        int end = d.indexOf(62, start);
        int offset = 0;
        if (start < 0) {
            return null;
        }
        String tagName = d.substring(start + 1, end);
        end = d.lastIndexOf(OPEN_END_TAG + tagName + '>');
        Tag tag = new Tag(tagName);
        offset = start + tagName.length() + 2;
        while (d.indexOf(60, offset) >= 0 && offset >= 0 && offset < end) {
            offset = Tag.readSubTag(tag, d, offset, decode);
        }
        return tag;
    }

    private static int readSubTag(Tag tag, String data, int offset, boolean decode) throws UnsupportedEncodingException {
        int start = data.indexOf(60, offset);
        if (start < 0) {
            return 1;
        }
        int closeStart = data.indexOf(62, start);
        String tagName = data.substring(start + 1, closeStart);
        int end = data.indexOf(OPEN_END_TAG + tagName + '>', closeStart);
        int subTagStart = data.indexOf(60, closeStart);
        Tag subTag = new Tag(tagName);
        tag.addTag(subTag);
        offset = start + tagName.length() + 2;
        if (subTagStart == end) {
            subTag.setValue(data.substring(offset, end), decode);
            return end + tagName.length() + 3;
        }
        while (data.indexOf(60, offset) >= 0 && offset >= 0 && offset < end) {
            offset = Tag.readSubTag(subTag, data, offset, decode);
        }
        return offset + tagName.length() + 3;
    }

    public static Tag createKeyValueTag(String keyword, String value) {
        return Tag.createKeyValueTag(new String[][]{{keyword, value}});
    }

    public static Tag createKeyValueTag(String[][] keyValue) {
        int i;
        Tag pair = new Tag("KeyValPair_PI", new Tag("ssLen", 0));
        int ssLength = 0;
        if (keyValue == null) {
            return pair;
        }
        for (i = 0; i < keyValue.length; ++i) {
            if (keyValue[i] == null || keyValue[i][0] == null) continue;
            pair.addTag("keyWord", keyValue[i][0]);
            ++ssLength;
        }
        pair.tags[0].setValue(ssLength);
        if (i == 0) {
            return pair;
        }
        for (i = 0; i < keyValue.length; ++i) {
            if (keyValue[i] == null || keyValue[i][0] == null) continue;
            pair.addTag("svalue", keyValue[i][1]);
        }
        return pair;
    }
}

