/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

public class TransferOptions {
    public static final int DEFAULT_UDP_SEND_RATE = 600000;
    public static final int DEFAULT_UDP_PACKET_SIZE = 8192;
    public static final int DEFAULT_MAX_PARALLEL_THREADS = 4;
    private int maxThreads = 4;
    private int udpSendRate = 600000;
    private int udpPacketSize = 8192;
    private TransferType transferType = TransferType.STANDARD;
    private boolean allowPutGetResourceRedirects = false;
    private boolean intraFileStatusCallbacks = false;
    private ForceOption forceOption = ForceOption.ASK_CALLBACK_LISTENER;
    private boolean computeChecksumAfterTransfer = false;
    private boolean computeAndVerifyChecksumAfterTransfer = false;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("transferOptions:");
        sb.append("\n   maxThreads:");
        sb.append(this.maxThreads);
        sb.append("\n  transferType:");
        sb.append((Object)this.transferType);
        sb.append("\n   udpSendRate:");
        sb.append(this.udpSendRate);
        sb.append("\n udpPacketSize:");
        sb.append(this.udpPacketSize);
        sb.append("\n allowPutGetResourceRedirects:");
        sb.append(this.allowPutGetResourceRedirects);
        sb.append("\n   computeChecksumAfterTransfer:");
        sb.append(this.computeChecksumAfterTransfer);
        sb.append("\n   computeAndVerifyChecksumAfterTransfer:");
        sb.append(this.computeAndVerifyChecksumAfterTransfer);
        sb.append("\n   intraFileStatusCallbacks:");
        sb.append(this.intraFileStatusCallbacks);
        sb.append("\n   forceOption:");
        sb.append((Object)this.forceOption);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferOptions(TransferOptions transferOptions) {
        this();
        if (transferOptions != null) {
            TransferOptions transferOptions2 = this;
            synchronized (transferOptions2) {
                this.setMaxThreads(transferOptions.getMaxThreads());
                this.setTransferType(transferOptions.getTransferType());
                this.setUdpPacketSize(transferOptions.getUdpPacketSize());
                this.setUdpSendRate(transferOptions.getUdpSendRate());
                this.setAllowPutGetResourceRedirects(transferOptions.isAllowPutGetResourceRedirects());
                this.setComputeChecksumAfterTransfer(transferOptions.isComputeChecksumAfterTransfer());
                this.setComputeAndVerifyChecksumAfterTransfer(transferOptions.isComputeAndVerifyChecksumAfterTransfer());
                this.setIntraFileStatusCallbacks(transferOptions.intraFileStatusCallbacks);
                this.setForceOption(transferOptions.getForceOption());
            }
        }
    }

    public TransferOptions() {
    }

    public synchronized TransferType getTransferType() {
        return this.transferType;
    }

    public synchronized void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public synchronized int getMaxThreads() {
        return this.maxThreads;
    }

    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public synchronized int getUdpSendRate() {
        return this.udpSendRate;
    }

    public synchronized void setUdpSendRate(int udpSendRate) {
        this.udpSendRate = udpSendRate;
    }

    public synchronized int getUdpPacketSize() {
        return this.udpPacketSize;
    }

    public synchronized void setUdpPacketSize(int udpPacketSize) {
        this.udpPacketSize = udpPacketSize;
    }

    public synchronized boolean isAllowPutGetResourceRedirects() {
        return this.allowPutGetResourceRedirects;
    }

    public synchronized void setAllowPutGetResourceRedirects(boolean allowPutGetResourceRedirects) {
        this.allowPutGetResourceRedirects = allowPutGetResourceRedirects;
    }

    public synchronized void setComputeChecksumAfterTransfer(boolean computeChecksumAfterTransfer) {
        this.computeChecksumAfterTransfer = computeChecksumAfterTransfer;
    }

    public synchronized boolean isComputeChecksumAfterTransfer() {
        return this.computeChecksumAfterTransfer;
    }

    public synchronized void setComputeAndVerifyChecksumAfterTransfer(boolean computeAndVerifyChecksumAfterTransfer) {
        this.computeAndVerifyChecksumAfterTransfer = computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized boolean isComputeAndVerifyChecksumAfterTransfer() {
        return this.computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized boolean isIntraFileStatusCallbacks() {
        return this.intraFileStatusCallbacks;
    }

    public synchronized void setIntraFileStatusCallbacks(boolean intraFileStatusCallbacks) {
        this.intraFileStatusCallbacks = intraFileStatusCallbacks;
    }

    public synchronized ForceOption getForceOption() {
        return this.forceOption;
    }

    public synchronized void setForceOption(ForceOption forceOption) {
        this.forceOption = forceOption;
    }

    public static enum ForceOption {
        USE_FORCE,
        NO_FORCE,
        ASK_CALLBACK_LISTENER;

    }

    public static enum TransferType {
        STANDARD,
        NO_PARALLEL,
        UDP;

    }
}

