/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.ModAccessControlInp;
import org.irods.jargon.core.packinstr.ModAvuMetadataInp;
import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.FileCatalogObjectAOImpl;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.UserAO;
import org.irods.jargon.core.pub.aohelper.CollectionAOHelper;
import org.irods.jargon.core.pub.domain.AvuData;
import org.irods.jargon.core.pub.domain.Collection;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileFactoryImpl;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.AVUQueryOperatorEnum;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.AccessObjectQueryProcessingUtils;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionAOImpl
extends FileCatalogObjectAOImpl
implements CollectionAO {
    private static final String QUERY_STRING_FOR_AVU_QUERY = "query string for AVU query: {}";
    private static final String QUERY_EXCEPTION_FOR_QUERY = "query exception for query:";
    public static final String ERROR_IN_COLECTION_QUERY = "An error occurred in the query for the collection";
    private IRODSFileFactory irodsFileFactory = new IRODSFileFactoryImpl(this.getIRODSSession(), this.getIRODSAccount());
    private IRODSGenQueryExecutor irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
    public static final Logger log = LoggerFactory.getLogger(CollectionAOImpl.class);

    protected CollectionAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSFile instanceIRODSFileForCollectionPath(String collectionPath) throws JargonException {
        log.info("returning a collection for path: {}", (Object)collectionPath);
        IRODSFile collection = this.irodsFileFactory.instanceIRODSFile(collectionPath);
        if (collection.exists() && !collection.isDirectory()) {
            log.error("collection cannot be returned, the given path is not a collection: {}", (Object)collectionPath);
            throw new IllegalArgumentException("the given path is not a collection");
        }
        return collection;
    }

    @Override
    public List<Collection> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements) throws JargonQueryException, JargonException {
        return this.findDomainByMetadataQuery(avuQueryElements, 0);
    }

    @Override
    public List<Collection> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements, int partialStartIndex) throws JargonQueryException, JargonException {
        IRODSQueryResultSetInterface resultSet;
        log.info("building a metadata query for: {}", avuQueryElements);
        StringBuilder query = new StringBuilder();
        query.append(CollectionAOHelper.buildSelects());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS.getName());
        query.append(" WHERE ");
        boolean previousElement = false;
        for (AVUQueryElement queryElement : avuQueryElements) {
            if (previousElement) {
                query.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)CollectionAOHelper.buildConditionPart(queryElement));
        }
        String queryString = query.toString();
        log.debug(QUERY_STRING_FOR_AVU_QUERY, (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY, (Object)queryString, (Object)e);
            throw new JargonException(ERROR_IN_COLECTION_QUERY);
        }
        return CollectionAOHelper.buildListFromResultSet(resultSet);
    }

    @Override
    public List<Collection> findAll(String absolutePathOfParent) throws JargonException {
        return this.findAll(absolutePathOfParent, 0);
    }

    @Override
    public List<Collection> findAll(String absolutePathOfParent, int partialStartIndex) throws JargonException {
        IRODSQueryResultSetInterface resultSet;
        if (absolutePathOfParent == null) {
            throw new IllegalArgumentException("null absolutePathOfParent");
        }
        String parentPath = "/";
        if (!absolutePathOfParent.isEmpty()) {
            parentPath = absolutePathOfParent;
        }
        StringBuilder query = new StringBuilder();
        query.append(CollectionAOHelper.buildSelects());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_PARENT_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(parentPath));
        query.append("'");
        String queryString = query.toString();
        if (log.isInfoEnabled()) {
            log.info("coll query:" + queryString);
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error("query exception for:" + queryString, e);
            throw new JargonException(ERROR_IN_COLECTION_QUERY);
        }
        return CollectionAOHelper.buildListFromResultSet(resultSet);
    }

    @Override
    public List<Collection> findWhere(String whereClause, int partialStartIndex) throws JargonException {
        IRODSQueryResultSetInterface resultSet;
        if (whereClause == null) {
            throw new IllegalArgumentException("null where clause");
        }
        StringBuilder query = new StringBuilder();
        query.append(CollectionAOHelper.buildSelects());
        query.append(" WHERE ");
        query.append(whereClause);
        String queryString = query.toString();
        log.info("coll query:{}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error("query exception for:" + queryString, e);
            throw new JargonException(ERROR_IN_COLECTION_QUERY);
        }
        return CollectionAOHelper.buildListFromResultSet(resultSet);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, "");
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQueryForCollection(List<AVUQueryElement> avuQuery, String collectionAbsolutePath) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null || avuQuery.isEmpty()) {
            throw new IllegalArgumentException("null or empty query");
        }
        if (collectionAbsolutePath == null) {
            throw new IllegalArgumentException("Null absolutePath for collection");
        }
        IRODSGenQueryExecutor irodsGenQueryExecutorImpl = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        log.info("building a metadata query for: {}", avuQuery);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_COLL_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(CollectionAOHelper.buildMetadataSelects());
        query.append(" WHERE ");
        boolean previousElement = false;
        for (AVUQueryElement queryElement : avuQuery) {
            if (previousElement) {
                query.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)CollectionAOHelper.buildConditionPart(queryElement));
        }
        if (collectionAbsolutePath.isEmpty()) {
            log.info("no absolute path, ignore this in the where clause");
        } else {
            log.info("adding abs path to query");
            if (previousElement) {
                query.append(" AND ");
            } else {
                query.append(' ');
            }
            query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
            query.append(" = '");
            query.append(IRODSDataConversionUtil.escapeSingleQuotes(collectionAbsolutePath));
            query.append('\'');
        }
        String queryString = query.toString();
        log.debug(QUERY_STRING_FOR_AVU_QUERY, (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + queryString, e);
            throw new JargonException(ERROR_IN_COLECTION_QUERY);
        }
        return AccessObjectQueryProcessingUtils.buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain.COLLECTION, resultSet);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQueryWithAdditionalWhere(List<AVUQueryElement> avuQuery, String additionalWhere) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null || avuQuery.isEmpty()) {
            throw new IllegalArgumentException("null or empty query");
        }
        if (additionalWhere == null) {
            throw new IllegalArgumentException("null additional where clause, set to blank if unused");
        }
        IRODSGenQueryExecutor irodsGenQueryExecutorImpl = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        log.info("building a metadata query for: {}", avuQuery);
        log.info("additional where data: {}", (Object)additionalWhere);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_COLL_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(CollectionAOHelper.buildMetadataSelects());
        query.append(" WHERE ");
        boolean previousElement = false;
        for (AVUQueryElement queryElement : avuQuery) {
            if (previousElement) {
                query.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)CollectionAOHelper.buildConditionPart(queryElement));
        }
        if (additionalWhere.isEmpty()) {
            log.info("no additionalWhere, ignore this in the where clause");
        } else {
            log.info("adding additional where to query");
            if (previousElement) {
                query.append(" AND ");
            } else {
                query.append(' ');
            }
            query.append(additionalWhere);
        }
        String queryString = query.toString();
        log.debug(QUERY_STRING_FOR_AVU_QUERY, (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + queryString, e);
            throw new JargonException(ERROR_IN_COLECTION_QUERY);
        }
        return AccessObjectQueryProcessingUtils.buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain.COLLECTION, resultSet);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQueryForCollection(List<AVUQueryElement> avuQuery, String collectionAbsolutePath, int partialStartIndex) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null) {
            throw new IllegalArgumentException("null query");
        }
        if (collectionAbsolutePath == null) {
            throw new IllegalArgumentException("Null absolutePath for collection");
        }
        IRODSGenQueryExecutor irodsGenQueryExecutorImpl = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        log.info("building a metadata query for: {}", avuQuery);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_COLL_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(CollectionAOHelper.buildMetadataSelects());
        query.append(" WHERE ");
        boolean previousElement = false;
        for (AVUQueryElement queryElement : avuQuery) {
            if (previousElement) {
                query.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)CollectionAOHelper.buildConditionPart(queryElement));
        }
        if (collectionAbsolutePath.isEmpty()) {
            log.info("no absolute path, ignore this in the where clause");
        } else {
            log.info("adding abs path to query");
            if (previousElement) {
                query.append(" AND ");
            } else {
                query.append(' ');
            }
            query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
            query.append(" = '");
            query.append(IRODSDataConversionUtil.escapeSingleQuotes(collectionAbsolutePath));
            query.append('\'');
        }
        String queryString = query.toString();
        log.debug(QUERY_STRING_FOR_AVU_QUERY, (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY + queryString, e);
            throw new JargonException(ERROR_IN_COLECTION_QUERY);
        }
        return AccessObjectQueryProcessingUtils.buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain.COLLECTION, resultSet);
    }

    @Override
    public void addAVUMetadata(String absolutePath, AvuData avuData) throws DataNotFoundException, DuplicateDataException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        log.info("adding avu metadata to collection: {}", avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForAddCollectionMetadata(absolutePath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-814000") > -1) {
                throw new DataNotFoundException("Target collection was not found, could not add AVU");
            }
            if (je.getMessage().indexOf("-809000") > -1) {
                throw new DuplicateDataException("Duplicate AVU exists, cannot add");
            }
            log.error("jargon exception adding AVU metadata", je);
            throw je;
        }
        log.debug("metadata added");
    }

    @Override
    public void deleteAVUMetadata(String absolutePath, AvuData avuData) throws DataNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        log.info("deleting avu metadata from collection: {}", avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForDeleteCollectionMetadata(absolutePath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-814000") > -1) {
                throw new DataNotFoundException("Target collection was not found, could not remove AVU");
            }
            log.error("jargon exception removing AVU metadata", je);
            throw je;
        }
        log.debug("metadata removed");
    }

    @Override
    public void modifyAvuValueBasedOnGivenAttributeAndUnit(String absolutePath, AvuData avuData) throws DataNotFoundException, JargonException {
        List<MetaDataAndDomainData> result;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null avuData");
        }
        log.info("setting avu metadata value for collection");
        log.info("with  avu metadata:{}", avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.ATTRIBUTE, AVUQueryOperatorEnum.EQUAL, avuData.getAttribute()));
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.UNITS, AVUQueryOperatorEnum.EQUAL, avuData.getUnit()));
            result = this.findMetadataValuesByMetadataQueryForCollection(queryElements, absolutePath);
        }
        catch (JargonQueryException e) {
            log.error("error querying data for avu", e);
            throw new JargonException("error querying data for AVU");
        }
        if (result.isEmpty()) {
            throw new DataNotFoundException("no avu data found");
        }
        if (result.size() > 1) {
            throw new JargonException("more than one AVU found with given attribute and unit, cannot modify non-unique AVU's in this way");
        }
        AvuData currentAvuData = new AvuData(result.get(0).getAvuAttribute(), result.get(0).getAvuValue(), result.get(0).getAvuUnit());
        AvuData modAvuData = new AvuData(result.get(0).getAvuAttribute(), avuData.getValue(), result.get(0).getAvuUnit());
        this.modifyAVUMetadata(absolutePath, currentAvuData, modAvuData);
        log.info("metadata modified to:{}", modAvuData);
    }

    @Override
    public void modifyAVUMetadata(String absolutePath, AvuData currentAvuData, AvuData newAvuData) throws DataNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (currentAvuData == null) {
            throw new IllegalArgumentException("null currentAvuData");
        }
        if (newAvuData == null) {
            throw new IllegalArgumentException("null newAvuData");
        }
        log.info("overwrite avu metadata for collection: {}", currentAvuData);
        log.info("with new avu metadata:{}", newAvuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForModifyCollectionMetadata(absolutePath, currentAvuData, newAvuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-814000") > -1) {
                throw new DataNotFoundException("Target collection was not found, could not modify AVU");
            }
            log.error("jargon exception modifying AVU metadata", je);
            throw je;
        }
        log.debug("metadata rewritten");
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForCollection(String collectionAbsolutePath, int partialStartIndex) throws JargonException, JargonQueryException {
        if (collectionAbsolutePath == null || collectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collectionAbsolutePath");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex must be 0 or greater, set to 0 if no offset desired");
        }
        log.info("find metadata values for collection:{}", (Object)collectionAbsolutePath);
        log.info("with partial start of:{}", partialStartIndex);
        ArrayList<AVUQueryElement> avuQuery = new ArrayList<AVUQueryElement>();
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, collectionAbsolutePath, partialStartIndex);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForCollection(String collectionAbsolutePath) throws JargonException, JargonQueryException {
        return this.findMetadataValuesForCollection(collectionAbsolutePath, 0);
    }

    @Override
    public Collection findByAbsolutePath(String irodsCollectionAbsolutePath) throws DataNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsCollectionAbsolutePath");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        sb.append(" = '");
        sb.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsCollectionAbsolutePath));
        sb.append("'");
        List<Collection> collectionList = this.findWhere(sb.toString(), 0);
        if (collectionList.size() == 0) {
            throw new DataNotFoundException("no collection found for path:" + irodsCollectionAbsolutePath);
        }
        return collectionList.get(0);
    }

    @Override
    public int countAllFilesUnderneathTheGivenCollection(String irodsCollectionAbsolutePath) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (irodsCollectionAbsolutePath == null) {
            throw new IllegalArgumentException("irodsCollectionAbsolutePath is null");
        }
        log.info("countAllFilesUnderneathTheGivenCollection: {}", (Object)irodsCollectionAbsolutePath);
        IRODSFile irodsFile = this.irodsFileFactory.instanceIRODSFile(irodsCollectionAbsolutePath);
        if (!irodsFile.isDirectory()) {
            log.error("this is a file, not a directory, and therefore I cannot get a count of the children: {}", (Object)irodsCollectionAbsolutePath);
            throw new JargonException("attempting to count children under a file at path:" + irodsCollectionAbsolutePath);
        }
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_DATA_REPL_NUM.getName());
        query.append(", COUNT(");
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(") WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" LIKE '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsCollectionAbsolutePath));
        query.append("%'");
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), 1);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:" + query.toString(), e);
            throw new JargonException("error in exists query");
        }
        int queryWithLikeCtr = 0;
        if (resultSet.getResults().size() > 0) {
            queryWithLikeCtr = IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(resultSet.getFirstResult().getColumn(1));
        }
        return queryWithLikeCtr;
    }

    @Override
    public void setAccessPermissionInherit(String zone, String absolutePath, boolean recursive) throws JargonException {
        log.info("setAccessPermissionInherit on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetInheritOnACollection(collNeedsRecursive, zone, absolutePath);
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionToNotInherit(String zone, String absolutePath, boolean recursive) throws JargonException {
        log.info("setAccessPermissionToNotInherit on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetNoInheritOnACollection(collNeedsRecursive, zone, absolutePath);
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionRead(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("setAccessPermissionRead on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, absolutePath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionReadAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("setAccessPermissionReadAsAdmin on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, absolutePath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionWrite(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("setAccessPermissionWrite on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, absolutePath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionWriteAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("setAccessPermissionWriteAsAdmin on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, absolutePath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwn(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("setAccessPermissionOwn on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, absolutePath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwnAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("setAccessPermissionOwnAsAdmin on absPath:{}", (Object)absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, absolutePath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionForUser(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("removeAccessPermission on absPath:{}", (Object)absolutePath);
        log.info("for user:{}", (Object)userName);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, absolutePath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionForUserAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        log.info("removeAccessPermissionAsAdmin on absPath:{}", (Object)absolutePath);
        log.info("for user:{}", (Object)userName);
        boolean collNeedsRecursive = this.adjustRecursiveOption(absolutePath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, absolutePath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public boolean isCollectionSetForPermissionInheritance(String absolutePath) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToCollection");
        }
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(CollectionAOHelper.buildInheritanceQueryForCollectionAbsolutePath(absolutePath), 1);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            throw new JargonException("error querying for inheritance flag", e);
        }
        String inheritanceFlag = resultSet.getFirstResult().getColumn(0);
        boolean returnInheritanceVal = false;
        if (inheritanceFlag.trim().equals("1")) {
            returnInheritanceVal = true;
        }
        return returnInheritanceVal;
    }

    @Override
    public FilePermissionEnum getPermissionForCollection(String irodsAbsolutePath, String userName, String zone) throws JargonException {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        log.info("getPermissionForCollection for absPath:{}", (Object)irodsAbsolutePath);
        log.info("userName:{}", (Object)userName);
        IRODSFileSystemAO irodsFileSystemAO = this.getIRODSAccessObjectFactory().getIRODSFileSystemAO(this.getIRODSAccount());
        IRODSFileFactory irodsFileFactory = this.getIRODSFileFactory();
        int permissionVal = irodsFileSystemAO.getDirectoryPermissionsForGivenUser(irodsFileFactory.instanceIRODSFile(irodsAbsolutePath), userName);
        FilePermissionEnum filePermissionEnum = FilePermissionEnum.valueOf(permissionVal);
        return filePermissionEnum;
    }

    private boolean adjustRecursiveOption(String absolutePath, boolean recursive) throws JargonException {
        IRODSFile collFile = this.getIRODSFileFactory().instanceIRODSFile(absolutePath);
        if (!collFile.exists()) {
            throw new JargonException("irodsFile does not exist for given path, cannot set permissions on it");
        }
        boolean collNeedsRecursive = recursive;
        CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        int countFilesUnderParent = collectionAndDataObjectListAndSearchAO.countDataObjectsAndCollectionsUnderPath(absolutePath);
        if (recursive && countFilesUnderParent == 0) {
            log.info("overridding recursive flag, file has no children");
            collNeedsRecursive = false;
        }
        return collNeedsRecursive;
    }

    @Override
    public UserFilePermission getPermissionForUserName(String irodsCollectionAbsolutePath, String userName) throws JargonException {
        UserFilePermission userFilePermission = null;
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsCollectionAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("getPermissionForUserName with irodsCollectionAbsolutePath: {}", (Object)irodsCollectionAbsolutePath);
        log.info("   userName:{}", (Object)userName);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        StringBuilder query = new StringBuilder(CollectionAOHelper.buildACLQueryForCollectionName(irodsCollectionAbsolutePath));
        query.append(" AND ");
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_NAME.getName());
        query.append(" = '");
        query.append(userName);
        query.append("'");
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        UserAO userAO = this.getIRODSAccessObjectFactory().getUserAO(this.getIRODSAccount());
        User user = null;
        try {
            IRODSQueryResultSet resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
            IRODSQueryResultRow row = resultSet.getFirstResult();
            user = userAO.findById(row.getColumn(1));
            userFilePermission = new UserFilePermission(row.getColumn(0), row.getColumn(1), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(2))), user.getUserType());
            log.debug("loaded filePermission:{}", userFilePermission);
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in query loading user file permissions for collection", e);
        }
        catch (DataNotFoundException dnf) {
            log.info("no data found for user ACL");
        }
        return userFilePermission;
    }

    @Override
    public List<UserFilePermission> listPermissionsForCollection(String irodsCollectionAbsolutePath) throws FileNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collectionAbsolutePath");
        }
        log.info("listPermissionsForCollection: {}", (Object)irodsCollectionAbsolutePath);
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        String query = CollectionAOHelper.buildACLQueryForCollectionName(irodsCollectionAbsolutePath);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        UserAO userAO = this.getIRODSAccessObjectFactory().getUserAO(this.getIRODSAccount());
        User user = null;
        try {
            IRODSQueryResultSet resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
            UserFilePermission userFilePermission = null;
            StringBuilder userAndZone = null;
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                userAndZone = new StringBuilder(row.getColumn(0));
                userAndZone.append('#');
                userAndZone.append(row.getColumn(3));
                user = userAO.findByName(userAndZone.toString());
                userFilePermission = new UserFilePermission(row.getColumn(0), row.getColumn(1), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(2))), user.getUserType(), row.getColumn(3));
                log.debug("loaded filePermission:{}", userFilePermission);
                userFilePermissions.add(userFilePermission);
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in query loading user file permissions for collection", e);
        }
        return userFilePermissions;
    }
}

