/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.AuditActionEnum;
import org.irods.jargon.core.pub.CollectionAuditAO;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.domain.AuditedAction;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionAuditAOImpl
extends IRODSGenericAO
implements CollectionAuditAO {
    public static final Logger log = LoggerFactory.getLogger(CollectionAuditAOImpl.class);
    public static final char COMMA = ',';
    private final transient IRODSGenQueryExecutor irodsGenQueryExecutor;

    protected CollectionAuditAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(irodsAccount);
    }

    @Override
    public List<AuditedAction> findAllAuditRecordsForCollection(IRODSFile irodsFile, int partialStart) throws JargonException {
        IRODSQueryResultSet resultSet;
        log.info("findAllAuditRecordsForCollection()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("null or empty irodsFile");
        }
        if (partialStart < 0) {
            throw new IllegalArgumentException("partial start must be >= 0");
        }
        log.info("irodsFile:{}", irodsFile);
        log.info("partialStart:{}", partialStart);
        ArrayList<AuditedAction> auditedActions = new ArrayList<AuditedAction>();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(RodsGenQueryEnum.COL_AUDIT_OBJ_ID.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_AUDIT_USER_ID.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_AUDIT_ACTION_ID.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_AUDIT_COMMENT.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_AUDIT_CREATE_TIME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_AUDIT_MODIFY_TIME.getName());
        sb.append(" WHERE ");
        sb.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        sb.append(" = '");
        sb.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsFile.getAbsolutePath().trim()));
        sb.append('\'');
        String query = sb.toString();
        log.debug("query for audit collection:{}", (Object)query);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, partialStart);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query: {}", (Object)query, (Object)e);
            throw new JargonException("error in query for data object", e);
        }
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            AuditedAction auditedAction = new AuditedAction();
            auditedAction.setObjectId(Integer.parseInt(row.getColumn(0)));
            auditedAction.setDomainObjectUniqueName(irodsFile.getAbsolutePath());
            auditedAction.setUserId(Integer.parseInt(row.getColumn(1)));
            auditedAction.setUserName(row.getColumn(2));
            auditedAction.setAuditActionEnum(AuditActionEnum.valueOf(Integer.parseInt(row.getColumn(3))));
            auditedAction.setComment(row.getColumn(4));
            auditedAction.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(5)));
            auditedAction.setUpdatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(6)));
            auditedAction.setLastResult(row.isLastResult());
            auditedAction.setCount(row.getRecordCount());
            auditedActions.add(auditedAction);
            log.info("added audited action:{}", auditedAction);
        }
        return auditedActions;
    }
}

