/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.OpenedDataObjInp;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.Stream2StreamAO;
import org.irods.jargon.core.pub.aohelper.AOHelper;
import org.irods.jargon.core.pub.domain.DataObject;
import org.irods.jargon.core.pub.io.ByteCountingCallbackInputStreamWrapper;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileInputStream;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.LocalFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataAOHelper
extends AOHelper {
    public static final Logger log = LoggerFactory.getLogger(DataAOHelper.class);
    private final IRODSAccessObjectFactory irodsAccessObjectFactory;
    private final IRODSAccount irodsAccount;
    private int streamBufferSize = 0;
    private int putBufferSize = 0;

    protected DataAOHelper(IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount) {
        if (irodsAccessObjectFactory == null) {
            throw new IllegalArgumentException("null irodsAccessObjectFactory");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        this.irodsAccessObjectFactory = irodsAccessObjectFactory;
        this.irodsAccount = irodsAccount;
        this.streamBufferSize = this.irodsAccessObjectFactory.getJargonProperties().getSendInputStreamBufferSize();
        this.putBufferSize = this.irodsAccessObjectFactory.getJargonProperties().getPutBufferSize();
    }

    protected String buildSelects() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_D_DATA_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_COLL_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_REPL_NUM.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_VERSION.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_TYPE_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_SIZE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_RESC_GROUP_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_RESC_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_DATA_PATH.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_OWNER_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_OWNER_ZONE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_REPL_STATUS.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_DATA_STATUS.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_DATA_CHECKSUM.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_EXPIRY.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_MAP_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_COMMENTS.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_CREATE_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_D_MODIFY_TIME.getName());
        return query.toString();
    }

    protected DataObject buildDomainFromResultSetRow(IRODSQueryResultRow row) throws JargonException {
        DataObject dataObject = new DataObject();
        dataObject.setId(Integer.parseInt(row.getColumn(0)));
        dataObject.setCollectionId(Integer.parseInt(row.getColumn(1)));
        dataObject.setCollectionName(row.getColumn(2));
        dataObject.setDataName(row.getColumn(3));
        dataObject.setDataReplicationNumber(Integer.parseInt(row.getColumn(4)));
        dataObject.setDataVersion(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(5)));
        dataObject.setDataTypeName(row.getColumn(6));
        dataObject.setDataSize(Long.parseLong(row.getColumn(7)));
        dataObject.setResourceGroupName(row.getColumn(8));
        dataObject.setResourceName(row.getColumn(9));
        dataObject.setDataPath(row.getColumn(10));
        dataObject.setDataOwnerName(row.getColumn(11));
        dataObject.setDataOwnerZone(row.getColumn(12));
        dataObject.setReplicationStatus(row.getColumn(13));
        dataObject.setDataStatus(row.getColumn(14));
        dataObject.setChecksum(row.getColumn(15));
        dataObject.setExpiry(row.getColumn(16));
        dataObject.setDataMapId(Integer.parseInt(row.getColumn(17)));
        dataObject.setComments(row.getColumn(18));
        dataObject.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(19)));
        dataObject.setUpdatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(20)));
        dataObject.setLastResult(row.isLastResult());
        dataObject.setCount(row.getRecordCount());
        if (log.isInfoEnabled()) {
            log.info("data object built \n");
            log.info(dataObject.toString());
        }
        return dataObject;
    }

    public static String buildMetadataSelects() {
        StringBuilder sb = new StringBuilder();
        sb.append(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS.getName());
        return sb.toString();
    }

    protected List<DataObject> buildListFromResultSet(IRODSQueryResultSetInterface resultSet) throws JargonException {
        ArrayList<DataObject> data = new ArrayList<DataObject>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            data.add(this.buildDomainFromResultSetRow(row));
        }
        return data;
    }

    protected StringBuilder buildConditionPart(AVUQueryElement queryElement) {
        StringBuilder queryCondition = new StringBuilder();
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.ATTRIBUTE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.VALUE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.UNITS) {
            queryCondition.append(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        return queryCondition;
    }

    public static List<MetaDataAndDomainData> buildMetaDataAndDomainDataListFromResultSet(IRODSQueryResultSetInterface irodsQueryResultSet) throws JargonException {
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        ArrayList<MetaDataAndDomainData> metaDataResults = new ArrayList<MetaDataAndDomainData>();
        for (IRODSQueryResultRow row : irodsQueryResultSet.getResults()) {
            metaDataResults.add(DataAOHelper.buildMetaDataAndDomainDataFromResultSetRowForDataObject(row));
        }
        return metaDataResults;
    }

    public static MetaDataAndDomainData buildMetaDataAndDomainDataFromResultSetRowForDataObject(IRODSQueryResultRow row) throws JargonException {
        String domainId = row.getColumn(0);
        StringBuilder sb = new StringBuilder();
        sb.append(row.getColumn(1));
        sb.append('/');
        sb.append(row.getColumn(2));
        String domainUniqueName = sb.toString();
        String attributeName = row.getColumn(3);
        String attributeValue = row.getColumn(4);
        String attributeUnits = row.getColumn(5);
        MetaDataAndDomainData data = MetaDataAndDomainData.instance(MetaDataAndDomainData.MetadataDomain.DATA, domainId, domainUniqueName, attributeName, attributeValue, attributeUnits);
        data.setCount(row.getRecordCount());
        data.setLastResult(row.isLastResult());
        log.debug("metadataAndDomainData: {}", data);
        return data;
    }

    protected void processNormalGetTransfer(File localFileToHoldData, long length, IRODSCommands irodsProtocol, TransferOptions transferOptions, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        BufferedOutputStream localFileOutputStream;
        log.info("normal file transfer started, get output stream for local destination file");
        if (irodsProtocol == null) {
            throw new IllegalArgumentException("null irodsProtocol");
        }
        if (transferOptions == null) {
            throw new IllegalArgumentException("null transferOptions");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        try {
            localFileOutputStream = new BufferedOutputStream(new FileOutputStream(localFileToHoldData));
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException when trying to create a new file for the local output stream for {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
            throw new JargonException("FileNotFoundException for local file when trying to get to: " + localFileToHoldData.getAbsolutePath(), e);
        }
        ConnectionProgressStatusListener intraFileStatusListener = null;
        if (transferStatusCallbackListener != null || transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks()) {
            intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.GET, length, transferControlBlock, transferStatusCallbackListener);
        }
        irodsProtocol.read(localFileOutputStream, length, intraFileStatusListener);
        log.info("transfer is complete");
        try {
            localFileOutputStream.flush();
            localFileOutputStream.close();
        }
        catch (IOException e) {
            log.error("IOException when trying to create a new file for the local output stream for {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
            throw new JargonException("IOException for local file when trying to get to: " + localFileToHoldData.getAbsolutePath(), e);
        }
    }

    protected void processNormalPutTransfer(File localFile, boolean overwrite, IRODSFile targetFile, IRODSCommands irodsProtocol, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException, FileNotFoundException {
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        if (irodsProtocol == null) {
            throw new IllegalArgumentException("null irodsProtocol");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        log.info("processNormalPutTransfer");
        TransferOptions myTransferOptions = new TransferOptions(transferControlBlock.getTransferOptions());
        myTransferOptions.setMaxThreads(0);
        boolean execFlag = false;
        if (localFile.canExecute()) {
            log.info("file is executable");
            execFlag = true;
        }
        DataObjInp dataObjInp = DataObjInp.instanceForNormalPutStrategy(targetFile.getAbsolutePath(), localFile.length(), targetFile.getResource(), overwrite, myTransferOptions, execFlag);
        if (myTransferOptions != null && (myTransferOptions.isComputeAndVerifyChecksumAfterTransfer() || myTransferOptions.isComputeChecksumAfterTransfer())) {
            log.info("computing a checksum on the file at:{}", (Object)localFile.getAbsolutePath());
            String localFileChecksum = LocalFileUtils.md5ByteArrayToString(LocalFileUtils.computeMD5FileCheckSumViaAbsolutePath(localFile.getAbsolutePath()));
            log.info("local file checksum is:{}", (Object)localFileChecksum);
            dataObjInp.setFileChecksumValue(localFileChecksum);
        }
        ConnectionProgressStatusListener intraFileStatusListener = null;
        if (transferStatusCallbackListener != null || myTransferOptions.isIntraFileStatusCallbacks()) {
            intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingInterval(TransferStatus.TransferType.PUT, localFile.length(), transferControlBlock, transferStatusCallbackListener, 100);
        }
        irodsProtocol.irodsFunctionIncludingAllDataInStream(dataObjInp, localFile.length(), new FileInputStream(localFile), intraFileStatusListener);
    }

    protected void putReadWriteLoop(File localFile, boolean overwrite, IRODSFile targetFile, int fd, IRODSCommands irodsProtocol, TransferControlBlock transferControlBlock, ConnectionProgressStatusListener intraFileStatusListener) throws JargonException, FileNotFoundException {
        log.info("put read/write loop");
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        if (irodsProtocol == null) {
            throw new IllegalArgumentException("null irodsProtocol");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        long lengthLeftToSend = localFile.length();
        InputStream fis = null;
        try {
            fis = new FileInputStream(localFile);
            log.debug("stream buffer size for file input stream used to read local file:{}", this.streamBufferSize);
            if (this.streamBufferSize == 0) {
                fis = new BufferedInputStream(fis);
            } else if (this.streamBufferSize > 0) {
                fis = new BufferedInputStream(fis, this.streamBufferSize);
            }
            log.info("starting read/write loop to send data to iRODS");
            OpenedDataObjInp openedDataObjInp = null;
            long lengthThisSend = 0L;
            while (lengthLeftToSend > 0L) {
                if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                    log.info("cancelling");
                    break;
                }
                lengthThisSend = Math.min((long)this.putBufferSize, lengthLeftToSend);
                openedDataObjInp = OpenedDataObjInp.instanceForFilePut(fd, lengthThisSend);
                log.debug("length left:{}", lengthLeftToSend -= irodsProtocol.irodsFunctionForStreamingToIRODSInFrames(openedDataObjInp, (int)lengthThisSend, fis, intraFileStatusListener));
            }
            if (lengthLeftToSend != 0L) {
                log.error("did not send all data");
                irodsProtocol.disconnectWithIOException();
                throw new JargonException("did not send all data");
            }
            log.info("send operation done, send opr complete");
            irodsProtocol.operationComplete(fd);
        }
        catch (Exception e) {
            log.error("error encountered in read/write loop, will rethrow");
            throw new JargonException(e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {}
        }
    }

    protected IRODSFile checkTargetFileForPutOperation(File localFile, IRODSFile irodsFileDestination, boolean ignoreChecks, IRODSFileFactory irodsFileFactory) throws JargonException {
        IRODSFile targetFile;
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (irodsFileDestination == null) {
            throw new IllegalArgumentException("null irodsFileDestination");
        }
        if (irodsFileFactory == null) {
            throw new IllegalArgumentException("null irodsFileFactory");
        }
        if (ignoreChecks) {
            log.debug("ignoring iRODS checks, assume this is a data object");
            targetFile = irodsFileDestination;
        } else {
            log.debug(">>>>>checking if destination file is a collection");
            if (irodsFileDestination.isDirectory()) {
                log.info("put specifying an irods collection, will use the local file name as the iRODS file name:{}", (Object)localFile.getName());
                targetFile = irodsFileFactory.instanceIRODSFile(irodsFileDestination.getAbsolutePath(), localFile.getName());
                targetFile.setResource(irodsFileDestination.getResource());
            } else {
                targetFile = irodsFileDestination;
            }
        }
        return targetFile;
    }

    protected static String buildACLQueryForCollectionPathAndDataName(String irodsCollectionAbsolutePath, String dataName) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        query.append(",");
        query.append(RodsGenQueryEnum.COL_DATA_ACCESS_USER_ID.getName());
        query.append(",");
        query.append(RodsGenQueryEnum.COL_DATA_ACCESS_TYPE.getName());
        query.append(",");
        query.append(RodsGenQueryEnum.COL_USER_TYPE.getName());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsCollectionAbsolutePath));
        query.append('\'');
        query.append(" AND ");
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(dataName));
        query.append('\'');
        return query.toString();
    }

    protected void processGetTransferViaRead(IRODSFile irodsFile, File localFileToHoldData, long irodsFileLength, TransferOptions transferOptions, int fd, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        log.info("processGetTransferViaRead()");
        if (localFileToHoldData == null) {
            throw new IllegalArgumentException("null localFileToHoldData");
        }
        if (irodsFileLength < 0L) {
            throw new IllegalArgumentException("irodsFileLength < 0");
        }
        if (fd <= 0) {
            throw new IllegalArgumentException("fd is <= 0");
        }
        log.info("streaming file transfer started, get output stream for local destination file");
        try {
            IRODSFileInputStream ifis = this.irodsAccessObjectFactory.getIRODSFileFactory(this.irodsAccount).instanceIRODSFileInputStreamGivingFD(irodsFile, fd);
            Stream2StreamAO stream2StreamAO = this.irodsAccessObjectFactory.getStream2StreamAO(this.irodsAccount);
            if (transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && transferStatusCallbackListener != null) {
                log.info("wrapping stream with callback stream wrapper");
                ConnectionProgressStatusListener connectionProgressStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingInterval(TransferStatus.TransferType.GET, irodsFileLength, transferControlBlock, transferStatusCallbackListener, 5);
                ByteCountingCallbackInputStreamWrapper wrapper = new ByteCountingCallbackInputStreamWrapper(connectionProgressStatusListener, ifis);
                stream2StreamAO.transferStreamToFileUsingIOStreams(wrapper, localFileToHoldData, irodsFileLength, this.irodsAccessObjectFactory.getJargonProperties().getGetBufferSize());
            } else {
                stream2StreamAO.transferStreamToFileUsingIOStreams(ifis, localFileToHoldData, irodsFileLength, 0x400000);
            }
        }
        catch (JargonException e) {
            log.error("Exception streaming data to local file from iRODS: {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
            throw e;
        }
        finally {
            irodsFile.closeGivenDescriptor(fd);
        }
    }
}

