/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileIntegrityException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.exception.OverwriteException;
import org.irods.jargon.core.packinstr.DataObjCopyInp;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.ModAccessControlInp;
import org.irods.jargon.core.packinstr.ModAvuMetadataInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.DataAOHelper;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.FileCatalogObjectAOImpl;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.ResourceAO;
import org.irods.jargon.core.pub.ResourceAOHelper;
import org.irods.jargon.core.pub.domain.AvuData;
import org.irods.jargon.core.pub.domain.DataObject;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.AVUQueryOperatorEnum;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.ParallelGetFileTransferStrategy;
import org.irods.jargon.core.transfer.ParallelPutFileTransferStrategy;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.LocalFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataObjectAOImpl
extends FileCatalogObjectAOImpl
implements DataObjectAO {
    private static final String NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH = "null or empty irodsCollectionAbsolutePath";
    private static final String ERROR_IN_PARALLEL_TRANSFER = "error in parallel transfer";
    private static final String NULL_LOCAL_FILE = "null local file";
    private static final String NULL_OR_EMPTY_ABSOLUTE_PATH = "null or empty absolutePath";
    public static final Logger log = LoggerFactory.getLogger(DataObjectAOImpl.class);
    private final transient DataAOHelper dataAOHelper = new DataAOHelper(this.getIRODSAccessObjectFactory(), this.getIRODSAccount());
    private final transient IRODSGenQueryExecutor irodsGenQueryExecutor;

    protected DataObjectAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(irodsAccount);
    }

    @Override
    public DataObject findByCollectionNameAndDataName(String collectionPath, String dataName) throws DataNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        DataObject dataObject = null;
        if (dataName == null || dataName.isEmpty()) {
            throw new IllegalArgumentException("dataName is null or empty");
        }
        log.info("find by collection path: {}", (Object)collectionPath);
        log.info(" data obj name: {}", (Object)dataName);
        StringBuilder sb = new StringBuilder();
        sb.append(this.dataAOHelper.buildSelects());
        sb.append(" WHERE ");
        if (collectionPath == null || collectionPath.isEmpty()) {
            log.info("ignoring collection path in query");
        } else {
            sb.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
            sb.append(" = '");
            sb.append(IRODSDataConversionUtil.escapeSingleQuotes(collectionPath.trim()));
            sb.append('\'');
            sb.append(" AND ");
        }
        sb.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        sb.append(" = '");
        sb.append(IRODSDataConversionUtil.escapeSingleQuotes(dataName.trim()));
        sb.append('\'');
        String query = sb.toString();
        log.debug("query for data object:{}", (Object)query);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query: {}", (Object)query, (Object)e);
            throw new JargonException("error in query for data object", e);
        }
        if (resultSet.getFirstResult() != null) {
            dataObject = this.dataAOHelper.buildDomainFromResultSetRow(resultSet.getFirstResult());
            log.debug("returning: {}", (Object)dataObject.toString());
        }
        return dataObject;
    }

    @Override
    public DataObject findByAbsolutePath(String absolutePath) throws DataNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        log.info("findByAbsolutePath() with path:{}", (Object)absolutePath);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(absolutePath);
        return this.findByCollectionNameAndDataName(irodsFile.getParent(), irodsFile.getName());
    }

    @Override
    public List<DataObject> findWhere(String where) throws JargonException {
        return this.findWhere(where, 0);
    }

    @Override
    public List<DataObject> findWhere(String where, int partialStart) throws JargonException {
        IRODSQueryResultSetInterface resultSet;
        if (where == null || where.isEmpty()) {
            throw new IllegalArgumentException("where clause is empty, this is not advisable for data object queries");
        }
        log.info("find by where: {}", (Object)where);
        StringBuilder sb = new StringBuilder();
        sb.append(this.dataAOHelper.buildSelects());
        sb.append(" WHERE ");
        sb.append(where);
        String query = sb.toString();
        log.debug("query for data object:{}", (Object)query);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStart);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query: {}", (Object)query, (Object)e);
            throw new JargonException("error in query for data object", e);
        }
        return this.dataAOHelper.buildListFromResultSet(resultSet);
    }

    @Override
    @Deprecated
    public void putLocalDataObjectToIRODS(File localFile, IRODSFile irodsFileDestination, boolean overwrite, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        TransferControlBlock effectiveTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        TransferOptions.ForceOption forceOption = overwrite ? TransferOptions.ForceOption.USE_FORCE : TransferOptions.ForceOption.NO_FORCE;
        effectiveTransferControlBlock.getTransferOptions().setForceOption(forceOption);
        this.putLocalDataObjectToIRODS(localFile, irodsFileDestination, effectiveTransferControlBlock, transferStatusCallbackListener);
    }

    @Override
    public void putLocalDataObjectToIRODS(File localFile, IRODSFile irodsFileDestination, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        TransferControlBlock effectiveTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        this.putLocalDataObjectToIRODSCommonProcessing(localFile, irodsFileDestination, false, effectiveTransferControlBlock, transferStatusCallbackListener);
    }

    @Override
    public void putLocalDataObjectToIRODS(File localFile, IRODSFile irodsFileDestination, boolean overwrite) throws DataNotFoundException, OverwriteException, JargonException {
        TransferControlBlock effectiveTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(null);
        if (overwrite) {
            effectiveTransferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.USE_FORCE);
        }
        this.putLocalDataObjectToIRODSCommonProcessing(localFile, irodsFileDestination, false, effectiveTransferControlBlock, null);
    }

    @Override
    public void putLocalDataObjectToIRODSForClientSideRuleOperation(File localFile, IRODSFile irodsFileDestination, boolean overwrite, TransferControlBlock transferControlBlock) throws DataNotFoundException, OverwriteException, JargonException {
        TransferControlBlock effectiveTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        this.putLocalDataObjectToIRODSCommonProcessing(localFile, irodsFileDestination, true, effectiveTransferControlBlock, null);
    }

    protected void putLocalDataObjectToIRODSCommonProcessing(File localFile, IRODSFile irodsFileDestination, boolean ignoreChecks, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws DataNotFoundException, OverwriteException, JargonException {
        if (localFile == null) {
            throw new IllegalArgumentException(NULL_LOCAL_FILE);
        }
        if (irodsFileDestination == null) {
            throw new IllegalArgumentException("null destination file");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        log.info("put operation, localFile: {}", (Object)localFile.getAbsolutePath());
        log.info("to irodsFile: {}", (Object)irodsFileDestination.getAbsolutePath());
        if (!localFile.exists()) {
            log.error("put error, local file does not exist: {}", (Object)localFile.getAbsolutePath());
            throw new DataNotFoundException("put attempt where local file does not exist:" + localFile.getAbsolutePath());
        }
        IRODSFile targetFile = this.dataAOHelper.checkTargetFileForPutOperation(localFile, irodsFileDestination, ignoreChecks, this.getIRODSFileFactory());
        boolean force = false;
        if (!ignoreChecks && targetFile.exists()) {
            if (transferControlBlock.getTransferOptions() == null) {
                throw new JargonRuntimeException("transfer control block does not have a transfer options set");
            }
            OverwriteResponse overwriteResponse = this.evaluateOverwrite(localFile, transferControlBlock, transferStatusCallbackListener, transferControlBlock.getTransferOptions(), (File)((Object)targetFile));
            if (overwriteResponse == OverwriteResponse.SKIP) {
                log.info("skipping due to overwrite status");
                return;
            }
            if (overwriteResponse == OverwriteResponse.PROCEED_WITH_FORCE) {
                force = true;
            }
        }
        long localFileLength = localFile.length();
        log.debug("localFileLength:{}", localFileLength);
        if (localFileLength < 0x2000000L) {
            log.info("processing transfer as normal, length below max");
            try {
                this.dataAOHelper.processNormalPutTransfer(localFile, force, targetFile, this.getIRODSProtocol(), transferControlBlock, transferStatusCallbackListener);
            }
            catch (FileNotFoundException e) {
                log.error("File not found for local file I was trying to put:{}", (Object)localFile.getAbsolutePath());
                throw new JargonException("localFile not found to put to irods", e);
            }
        } else {
            log.info("processing as a parallel transfer, length above max");
            this.processAsAParallelPutOperationIfMoreThanZeroThreads(localFile, targetFile, force, transferControlBlock, transferStatusCallbackListener);
        }
        log.info("transfer complete");
    }

    private void processAsAParallelPutOperationIfMoreThanZeroThreads(File localFile, IRODSFile targetFile, boolean overwrite, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws DataNotFoundException, OverwriteException, JargonException {
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null target file");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        TransferOptions myTransferOptions = new TransferOptions(transferControlBlock.getTransferOptions());
        myTransferOptions.setMaxThreads(this.getJargonProperties().getMaxParallelThreads());
        log.info("setting max threads cap to:{}", myTransferOptions.getMaxThreads());
        ConnectionProgressStatusListener intraFileStatusListener = null;
        boolean execFlag = false;
        if (localFile.canExecute()) {
            log.info("file is executable");
            execFlag = true;
        }
        DataObjInp dataObjInp = DataObjInp.instanceForParallelPut(targetFile.getAbsolutePath(), localFile.length(), targetFile.getResource(), overwrite, myTransferOptions, execFlag);
        try {
            if (myTransferOptions.isComputeAndVerifyChecksumAfterTransfer() || myTransferOptions.isComputeChecksumAfterTransfer()) {
                log.info("before generating parallel transfer threads, computing a checksum on the file at:{}", (Object)localFile.getAbsolutePath());
                String localFileChecksum = LocalFileUtils.md5ByteArrayToString(LocalFileUtils.computeMD5FileCheckSumViaAbsolutePath(localFile.getAbsolutePath()));
                log.info("local file checksum is:{}", (Object)localFileChecksum);
                dataObjInp.setFileChecksumValue(localFileChecksum);
            }
            Tag responseToInitialCallForPut = this.getIRODSProtocol().irodsFunction(dataObjInp);
            int numberOfThreads = responseToInitialCallForPut.getTag("numThreads").getIntValue();
            int fd = responseToInitialCallForPut.getTag("l1descInx").getIntValue();
            log.debug("fd for file:{}", fd);
            if (numberOfThreads < 0) {
                throw new JargonException("numberOfThreads returned from iRODS is < 0, some error occurred");
            }
            if (numberOfThreads > 0) {
                this.parallelPutTransfer(localFile, responseToInitialCallForPut, numberOfThreads, localFile.length(), transferControlBlock, transferStatusCallbackListener);
            } else {
                log.info("parallel operation deferred by server sending 0 threads back in PortalOperOut, revert to single thread transfer");
                if (transferStatusCallbackListener != null || myTransferOptions.isIntraFileStatusCallbacks()) {
                    intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingInterval(TransferStatus.TransferType.PUT, localFile.length(), transferControlBlock, transferStatusCallbackListener, 100);
                }
                this.dataAOHelper.putReadWriteLoop(localFile, overwrite, targetFile, fd, this.getIRODSProtocol(), transferControlBlock, intraFileStatusListener);
            }
        }
        catch (DataNotFoundException dnf) {
            log.warn("send of put returned no data found from irods, currently is ignored and null is returned from put operation");
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-312000") > -1) {
                log.error("attempted put of file that exists in irods without overwrite");
                throw new JargonException("attempted put of a file that already exists in IRODS, overwrite was not set to true", je);
            }
            throw je;
        }
        catch (FileNotFoundException e) {
            log.error("File not found for local file I was trying to put:{}", (Object)localFile.getAbsolutePath());
            throw new DataNotFoundException("localFile not found to put to irods", e);
        }
        catch (Exception e) {
            log.error(ERROR_IN_PARALLEL_TRANSFER, e);
            throw new JargonException(ERROR_IN_PARALLEL_TRANSFER, e);
        }
    }

    private void parallelPutTransfer(File localFile, Tag responseToInitialCallForPut, int numberOfThreads, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws DataNotFoundException, OverwriteException, JargonException {
        log.info("transfer will be done using {} threads", numberOfThreads);
        String host = responseToInitialCallForPut.getTag("PortList_PI").getTag("hostAddr").getStringValue();
        int port = responseToInitialCallForPut.getTag("PortList_PI").getTag("portNum").getIntValue();
        int pass = responseToInitialCallForPut.getTag("PortList_PI").getTag("cookie").getIntValue();
        ParallelPutFileTransferStrategy parallelPutFileStrategy = ParallelPutFileTransferStrategy.instance(host, port, numberOfThreads, pass, localFile, this.getIRODSAccessObjectFactory(), transferLength, transferControlBlock, transferStatusCallbackListener);
        log.info("getting ready to initiate parallel file transfer strategy:{}", parallelPutFileStrategy);
        parallelPutFileStrategy.transfer();
        log.info("transfer is done, now terminate the keep alive process");
        log.info("transfer process is complete");
        int statusForComplete = responseToInitialCallForPut.getTag("l1descInx").getIntValue();
        log.debug("status for complete:{}", statusForComplete);
        log.info("sending operation complete at termination of parallel transfer");
        this.getIRODSProtocol().operationComplete(statusForComplete);
    }

    @Override
    public void getDataObjectFromIrods(IRODSFile irodsFileToGet, File localFileToHoldData) throws OverwriteException, DataNotFoundException, JargonException {
        this.getDataObjectFromIrodsGivingTransferOptions(irodsFileToGet, localFileToHoldData, null);
    }

    @Override
    public void getDataObjectFromIrodsGivingTransferOptions(IRODSFile irodsFileToGet, File localFileToHoldData, TransferOptions transferOptions) throws OverwriteException, DataNotFoundException, JargonException {
        if (localFileToHoldData == null) {
            throw new IllegalArgumentException(NULL_LOCAL_FILE);
        }
        if (irodsFileToGet == null) {
            throw new IllegalArgumentException("nulll destination file");
        }
        TransferOptions myTransferOptions = this.buildDefaultTransferOptionsIfNotSpecified(transferOptions);
        TransferControlBlock transferControlBlock = DefaultTransferControlBlock.instance();
        transferControlBlock.setTransferOptions(myTransferOptions);
        this.getDataObjectFromIrods(irodsFileToGet, localFileToHoldData, transferControlBlock, null);
    }

    @Override
    public void getDataObjectFromIrods(IRODSFile irodsFileToGet, File localFileToHoldData, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws OverwriteException, DataNotFoundException, JargonException {
        File localFile;
        log.info("getDataObjectFromIrods()");
        if (transferStatusCallbackListener == null) {
            log.info("transferStatusCallbackListener not given to getDataObjectFromIrods() method");
        } else {
            log.info("transferStatusCallbackListener present for getDataObjectFromIrods() method");
        }
        if (localFileToHoldData == null) {
            throw new IllegalArgumentException(NULL_LOCAL_FILE);
        }
        if (irodsFileToGet == null) {
            throw new IllegalArgumentException("nulll destination file");
        }
        log.info("irodsFileToGet:{}", (Object)irodsFileToGet.getAbsolutePath());
        log.info("localFileToHoldData:{}", (Object)localFileToHoldData.getAbsolutePath());
        TransferControlBlock operativeTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        TransferOptions thisFileTransferOptions = new TransferOptions(operativeTransferControlBlock.getTransferOptions());
        if (localFileToHoldData.isDirectory()) {
            log.info("a put to a directory, just use the source file name and accept the directory as a target");
            StringBuilder sb = new StringBuilder();
            sb.append(localFileToHoldData.getAbsolutePath());
            sb.append("/");
            sb.append(irodsFileToGet.getName());
            log.info("target file name will be:{}", (Object)sb.toString());
            localFile = new File(sb.toString());
        } else {
            localFile = localFileToHoldData;
        }
        OverwriteResponse overwriteResponse = this.evaluateOverwrite((File)((Object)irodsFileToGet), transferControlBlock, transferStatusCallbackListener, thisFileTransferOptions, localFile);
        if (overwriteResponse == OverwriteResponse.SKIP) {
            log.info("skipping due to overwrite status");
            return;
        }
        long irodsFileLength = irodsFileToGet.length();
        log.info("testing file length to set parallel transfer options");
        if (irodsFileLength > 0x2000000L) {
            thisFileTransferOptions.setMaxThreads(this.getIRODSSession().getJargonProperties().getMaxParallelThreads());
            log.info("length above threshold, send max threads cap");
        } else {
            thisFileTransferOptions.setMaxThreads(0);
        }
        log.info("target local file: {}", (Object)localFile.getAbsolutePath());
        log.info("from source file: {}", (Object)irodsFileToGet.getAbsolutePath());
        DataObjInp dataObjInp = irodsFileToGet.getResource().isEmpty() ? DataObjInp.instanceForGet(irodsFileToGet.getAbsolutePath(), irodsFileLength, thisFileTransferOptions) : DataObjInp.instanceForGetSpecifyingResource(irodsFileToGet.getAbsolutePath(), irodsFileToGet.getResource(), thisFileTransferOptions);
        this.processGetAfterResourceDetermined(irodsFileToGet, localFile, dataObjInp, thisFileTransferOptions, irodsFileLength, operativeTransferControlBlock, transferStatusCallbackListener);
    }

    private OverwriteResponse evaluateOverwrite(File sourceFile, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, TransferOptions thisFileTransferOptions, File targetFile) throws OverwriteException {
        OverwriteResponse overwriteResponse = OverwriteResponse.PROCEED_WITH_NO_FORCE;
        if (targetFile.exists()) {
            log.info("target file exists, check if overwrite allowed, file is:{}", (Object)targetFile.getAbsolutePath());
            if (thisFileTransferOptions.getForceOption() == TransferOptions.ForceOption.NO_FORCE) {
                throw new OverwriteException("attempt to overwrite file, target file already exists and no force option specified");
            }
            if (thisFileTransferOptions.getForceOption() == TransferOptions.ForceOption.USE_FORCE) {
                log.info("force specified, do the overwrite");
                overwriteResponse = OverwriteResponse.PROCEED_WITH_FORCE;
            } else if (thisFileTransferOptions.getForceOption() == TransferOptions.ForceOption.ASK_CALLBACK_LISTENER) {
                if (transferStatusCallbackListener == null) {
                    throw new OverwriteException("attempt to overwrite file, target file already exists and no callback listener provided to ask");
                }
                TransferStatusCallbackListener.CallbackResponse callbackResponse = transferStatusCallbackListener.transferAsksWhetherToForceOperation(sourceFile.getAbsolutePath(), false);
                switch (callbackResponse) {
                    case CANCEL: {
                        log.info("transfer cancelleld");
                        overwriteResponse = OverwriteResponse.SKIP;
                        break;
                    }
                    case YES_THIS_FILE: {
                        overwriteResponse = OverwriteResponse.PROCEED_WITH_FORCE;
                        break;
                    }
                    case NO_THIS_FILE: {
                        overwriteResponse = OverwriteResponse.SKIP;
                        break;
                    }
                    case YES_FOR_ALL: {
                        if (transferControlBlock == null) {
                            log.warn("attempting to process a 'yes for all' response, but no transfer control block to maintain this, it will be ignored for subsequent transfers");
                        } else {
                            transferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.USE_FORCE);
                        }
                        overwriteResponse = OverwriteResponse.PROCEED_WITH_FORCE;
                        break;
                    }
                    case NO_FOR_ALL: {
                        if (transferControlBlock == null) {
                            log.warn("attempting to process a 'no for all' response, but no transfer control block to maintain this, it will be ignored for subsequent transfers");
                            overwriteResponse = OverwriteResponse.SKIP;
                            break;
                        }
                        transferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.NO_FORCE);
                        overwriteResponse = OverwriteResponse.SKIP;
                        break;
                    }
                    default: {
                        log.error("unknown callback response:{}", (Object)callbackResponse);
                    }
                }
            }
        }
        return overwriteResponse;
    }

    @Override
    public void irodsDataObjectGetOperationForClientSideAction(IRODSFile irodsFileToGet, File localFileToHoldData, TransferOptions transferOptions) throws OverwriteException, DataNotFoundException, JargonException {
        if (localFileToHoldData == null) {
            throw new IllegalArgumentException(NULL_LOCAL_FILE);
        }
        if (irodsFileToGet == null) {
            throw new IllegalArgumentException("nulll destination file");
        }
        OverwriteResponse overwriteResponse = this.evaluateOverwrite((File)((Object)irodsFileToGet), null, null, this.buildDefaultTransferOptionsIfNotSpecified(transferOptions), localFileToHoldData);
        if (overwriteResponse == OverwriteResponse.SKIP) {
            log.info("skipping due to over-write status");
            return;
        }
        log.info("target local file: {}", (Object)localFileToHoldData.getAbsolutePath());
        log.info("from source file: {}", (Object)irodsFileToGet.getAbsolutePath());
        TransferOptions myTransferOptions = this.buildDefaultTransferOptionsIfNotSpecified(transferOptions);
        DataObjInp dataObjInp = DataObjInp.instanceForGetSpecifyingResource(irodsFileToGet.getAbsolutePath(), "", myTransferOptions);
        TransferControlBlock transferControlBlock = DefaultTransferControlBlock.instance();
        transferControlBlock.setTransferOptions(myTransferOptions);
        this.processGetAfterResourceDetermined(irodsFileToGet, localFileToHoldData, dataObjInp, myTransferOptions, 0L, transferControlBlock, null);
    }

    private void processGetAfterResourceDetermined(IRODSFile irodsFileToGet, File localFileToHoldData, DataObjInp dataObjInp, TransferOptions thisFileTransferOptions, long irodsFileLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws OverwriteException, JargonException, DataNotFoundException {
        log.info("process get after resource determined");
        if (transferStatusCallbackListener == null) {
            log.info("no transfer status callback listener provided");
        }
        if (thisFileTransferOptions == null) {
            throw new IllegalArgumentException("null transfer options");
        }
        LocalFileUtils.createLocalFileIfNotExists(localFileToHoldData);
        IRODSCommands irodsProtocol = this.getIRODSProtocol();
        Tag message = irodsProtocol.irodsFunction(dataObjInp);
        if (message == null) {
            log.warn("irods file does not exist, null was returned from the get, return DataNotFoundException for iRODS file: {}", (Object)irodsFileToGet.getAbsolutePath());
            throw new DataNotFoundException("irods file not found during get operation:" + irodsFileToGet.getAbsolutePath());
        }
        Tag temp = message.getTag("MsgHeader_PI");
        if (temp == null) {
            log.info("create a new file, length is zero");
            return;
        }
        if ((temp = temp.getTag("bsLen")) == null) {
            log.info("no size returned, return from get with no update done");
            return;
        }
        long lengthFromIrodsResponse = temp.getLongValue();
        log.info("transfer length is:", lengthFromIrodsResponse);
        try {
            if (lengthFromIrodsResponse == 0L) {
                this.checkNbrThreadsAndProcessAsParallelIfMoreThanZeroThreads(irodsFileToGet, localFileToHoldData, thisFileTransferOptions, message, lengthFromIrodsResponse, irodsFileLength, transferControlBlock, transferStatusCallbackListener);
            } else {
                this.dataAOHelper.processNormalGetTransfer(localFileToHoldData, lengthFromIrodsResponse, irodsProtocol, thisFileTransferOptions, transferControlBlock, transferStatusCallbackListener);
            }
            if (thisFileTransferOptions != null && thisFileTransferOptions.isComputeAndVerifyChecksumAfterTransfer()) {
                log.info("computing a checksum on the file at:{}", (Object)localFileToHoldData.getAbsolutePath());
                String localFileChecksum = LocalFileUtils.md5ByteArrayToString(LocalFileUtils.computeMD5FileCheckSumViaAbsolutePath(localFileToHoldData.getAbsolutePath()));
                log.info("local file checksum is:{}", (Object)localFileChecksum);
                String irodsChecksum = this.computeMD5ChecksumOnDataObject(irodsFileToGet);
                log.info("irods checksum:{}", (Object)irodsChecksum);
                if (!irodsChecksum.equals(localFileChecksum)) {
                    throw new FileIntegrityException("checksum verification after get fails");
                }
            }
            log.info("looking for executable to set flag on local file");
            if (irodsFileToGet.canExecute()) {
                log.info("execute set on local file");
                localFileToHoldData.setExecutable(true);
            }
        }
        catch (Exception e) {
            log.error(ERROR_IN_PARALLEL_TRANSFER, e);
            throw new JargonException(ERROR_IN_PARALLEL_TRANSFER, e);
        }
    }

    private void checkNbrThreadsAndProcessAsParallelIfMoreThanZeroThreads(IRODSFile irodsSourceFile, File localFileToHoldData, TransferOptions transferOptions, Tag message, long length, long irodsFileLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        String host = message.getTag("PortList_PI").getTag("hostAddr").getStringValue();
        int port = message.getTag("PortList_PI").getTag("portNum").getIntValue();
        int password = message.getTag("PortList_PI").getTag("cookie").getIntValue();
        int numberOfThreads = message.getTag("numThreads").getIntValue();
        log.info("number of threads for this transfer = {} ", numberOfThreads);
        if (numberOfThreads == 0) {
            log.info("number of threads is zero, possibly parallel transfers were turned off via rule, process as normal");
            int fd = message.getTag("l1descInx").getIntValue();
            this.dataAOHelper.processGetTransferViaRead(irodsSourceFile, localFileToHoldData, irodsFileLength, transferOptions, fd, transferControlBlock, transferStatusCallbackListener);
        } else {
            log.info("process as a parallel transfer");
            if (transferStatusCallbackListener == null) {
                log.info("no callback listener specified");
            } else {
                log.info("callback listener was provided");
            }
            ParallelGetFileTransferStrategy parallelGetTransferStrategy = ParallelGetFileTransferStrategy.instance(host, port, numberOfThreads, password, localFileToHoldData, this.getIRODSAccessObjectFactory(), irodsSourceFile.length(), transferControlBlock, transferStatusCallbackListener);
            parallelGetTransferStrategy.transfer();
        }
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObjectUsingAVUQuery(List<AVUQueryElement> avuQuery, String dataObjectCollectionAbsPath, String dataObjectFileName) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null) {
            throw new IllegalArgumentException("null query");
        }
        if (dataObjectCollectionAbsPath == null || dataObjectCollectionAbsPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath for dataObjectCollectionAbsPath");
        }
        if (dataObjectFileName == null || dataObjectFileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectFileName");
        }
        log.info("building a metadata query for: {}", avuQuery);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_D_DATA_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS.getName());
        query.append(" WHERE ");
        boolean previousElement = false;
        for (AVUQueryElement queryElement : avuQuery) {
            if (previousElement) {
                query.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)this.dataAOHelper.buildConditionPart(queryElement));
        }
        if (previousElement) {
            query.append(" AND ");
        } else {
            query.append(' ');
        }
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(dataObjectCollectionAbsPath));
        query.append('\'');
        query.append(" AND ");
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(dataObjectFileName));
        query.append('\'');
        String queryString = query.toString();
        log.debug("query string for AVU query: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query:" + queryString, e);
            throw new JargonException("error in query for a data object");
        }
        return DataAOHelper.buildMetaDataAndDomainDataListFromResultSet(resultSet);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObjectUsingAVUQuery(List<AVUQueryElement> avuQuery, String dataObjectAbsolutePath) throws JargonQueryException, JargonException {
        if (avuQuery == null) {
            throw new IllegalArgumentException("null query");
        }
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath for dataObjectAbsolutePath");
        }
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(dataObjectAbsolutePath);
        return this.findMetadataValuesForDataObjectUsingAVUQuery(avuQuery, irodsFile.getParent(), irodsFile.getName());
    }

    @Override
    public IRODSFile instanceIRODSFileForPath(String fileAbsolutePath) throws JargonException {
        log.info("returning a file for path: {}", (Object)fileAbsolutePath);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(fileAbsolutePath);
        return irodsFile;
    }

    @Override
    public void addAVUMetadata(String absolutePath, AvuData avuData) throws DataNotFoundException, DuplicateDataException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        log.info("adding avu metadata to data object: {}", avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForAddDataObjectMetadata(absolutePath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target dataObject was not found, could not add AVU");
            }
            if (je.getMessage().indexOf("-809000") > -1) {
                throw new DuplicateDataException("Duplicate AVU exists, cannot add");
            }
            log.error("jargon exception adding AVU metadata", je);
            throw je;
        }
        log.debug("metadata added");
    }

    @Override
    public void addAVUMetadata(String irodsCollectionAbsolutePath, String fileName, AvuData avuData) throws DataNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        log.info("adding avu metadata to data object: {}", avuData);
        log.info("parent collection absolute path: {}", (Object)irodsCollectionAbsolutePath);
        log.info("file name: {}", (Object)fileName);
        StringBuilder sb = new StringBuilder(irodsCollectionAbsolutePath);
        sb.append("/");
        sb.append(fileName);
        this.addAVUMetadata(sb.toString(), avuData);
    }

    @Override
    public void deleteAVUMetadata(String absolutePath, AvuData avuData) throws DataNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        log.info("deleting avu metadata on dataObject: {}", avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForDeleteDataObjectMetadata(absolutePath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target data object was not found, could not remove AVU");
            }
            log.error("jargon exception removing AVU metadata", je);
            throw je;
        }
        log.debug("metadata removed");
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQuery(avuQuery, 0);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery, int partialStartIndex) throws JargonQueryException, JargonException {
        IRODSQueryResultSetInterface resultSet;
        if (avuQuery == null || avuQuery.isEmpty()) {
            throw new IllegalArgumentException("null or empty query");
        }
        log.info("building a metadata query for: {}", avuQuery);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_D_DATA_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS.getName());
        query.append(" WHERE ");
        boolean previousElement = false;
        for (AVUQueryElement queryElement : avuQuery) {
            if (previousElement) {
                query.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)this.dataAOHelper.buildConditionPart(queryElement));
        }
        String queryString = query.toString();
        log.debug("query string for AVU query: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query:" + queryString, e);
            throw new JargonException("error in data object AVU Query", e);
        }
        return DataAOHelper.buildMetaDataAndDomainDataListFromResultSet(resultSet);
    }

    @Override
    public List<DataObject> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements) throws JargonQueryException, JargonException {
        return this.findDomainByMetadataQuery(avuQueryElements, 0);
    }

    @Override
    public List<DataObject> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements, int partialStartIndex) throws JargonQueryException, JargonException {
        IRODSQueryResultSetInterface resultSet;
        log.info("building a metadata query for: {}", avuQueryElements);
        StringBuilder query = new StringBuilder();
        query.append(this.dataAOHelper.buildSelects());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS.getName());
        query.append(" WHERE ");
        boolean previousElement = false;
        for (AVUQueryElement queryElement : avuQueryElements) {
            if (previousElement) {
                query.append(" AND ");
            }
            previousElement = true;
            query.append((CharSequence)this.dataAOHelper.buildConditionPart(queryElement));
        }
        String queryString = query.toString();
        log.debug("query string for AVU query: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, this.getIRODSSession().getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query:" + queryString, e);
            throw new JargonException("error in query for data objects query by metadata");
        }
        return this.dataAOHelper.buildListFromResultSet(resultSet);
    }

    @Override
    public void replicateIrodsDataObject(String irodsFileAbsolutePath, String targetResource) throws JargonException {
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsFileAbsolutePath");
        }
        if (targetResource == null || targetResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty targetResource");
        }
        log.info("replicate operation, irodsFileAbsolutePath: {}", (Object)irodsFileAbsolutePath);
        log.info("to resource: {}", (Object)targetResource);
        DataObjInp dataObjInp = DataObjInp.instanceForReplicate(irodsFileAbsolutePath, targetResource);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (JargonException je) {
            log.error("error replicating irods file", je);
            throw je;
        }
        log.info("replication complete");
    }

    @Override
    public void copyIRODSDataObject(IRODSFile irodsSourceFile, IRODSFile irodsTargetFile, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws OverwriteException, DataNotFoundException, JargonException {
        log.info("copyIRODSDataObject()");
        if (irodsSourceFile == null) {
            throw new IllegalArgumentException("null irodsSourceFile");
        }
        if (irodsTargetFile == null) {
            throw new IllegalArgumentException("null irodsTargetFile");
        }
        log.info("sourceFile:{}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("targetFile:{}", (Object)irodsTargetFile.getAbsolutePath());
        log.info("at resource: {}", (Object)irodsTargetFile.getResource());
        if (!irodsSourceFile.exists()) {
            throw new DataNotFoundException("the source file for the copy does not exist");
        }
        if (!irodsSourceFile.isFile()) {
            throw new JargonException("the source file is not a data object");
        }
        IRODSFile myTargetFile = irodsTargetFile;
        if (myTargetFile.exists() && myTargetFile.isDirectory()) {
            log.info("target is a directory, check if the file already exists");
            myTargetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFile.getAbsolutePath(), irodsSourceFile.getName());
            log.info("target file normalized as a data object:{}", (Object)irodsTargetFile.getAbsolutePath());
        }
        TransferControlBlock operativeTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        OverwriteResponse overwriteResponse = this.evaluateOverwrite((File)((Object)irodsSourceFile), transferControlBlock, transferStatusCallbackListener, operativeTransferControlBlock.getTransferOptions(), (File)((Object)myTargetFile));
        boolean force = false;
        if (overwriteResponse == OverwriteResponse.SKIP) {
            log.info("skipping due to overwrite status");
            return;
        }
        if (overwriteResponse == OverwriteResponse.PROCEED_WITH_FORCE) {
            force = true;
        }
        DataObjCopyInp dataObjCopyInp = DataObjCopyInp.instanceForCopy(irodsSourceFile.getAbsolutePath(), myTargetFile.getAbsolutePath(), irodsTargetFile.getResource(), myTargetFile.length(), force);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjCopyInp);
        }
        catch (JargonException je) {
            log.error("error copying irods file", je);
            throw je;
        }
        log.info("copy complete");
    }

    @Override
    public void copyIrodsDataObject(String irodsSourceFileAbsolutePath, String irodsTargetFileAbsolutePath, String targetResourceName) throws OverwriteException, DataNotFoundException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsSourceFileAbsolutePath");
        }
        if (irodsTargetFileAbsolutePath == null || irodsTargetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsTargetFileAbsolutePath");
        }
        if (targetResourceName == null) {
            throw new IllegalArgumentException("null  targetResourceName");
        }
        log.info("copyIrodsDataObject, irodsSourceFileAbsolutePath: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("irodsTargetFileAbsolutePath:{}", (Object)irodsTargetFileAbsolutePath);
        log.info("at resource: {}", (Object)targetResourceName);
        IRODSFile sourceFile = this.getIRODSFileFactory().instanceIRODSFile(irodsSourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
        targetFile.setResource(targetResourceName);
        TransferControlBlock transferControlBlock = this.buildDefaultTransferControlBlockBasedOnJargonProperties();
        transferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.NO_FORCE);
        this.copyIRODSDataObject(sourceFile, targetFile, transferControlBlock, null);
    }

    @Override
    public void copyIrodsDataObjectWithForce(String irodsSourceFileAbsolutePath, String irodsTargetFileAbsolutePath, String targetResourceName) throws OverwriteException, DataNotFoundException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsSourceFileAbsolutePath");
        }
        if (irodsTargetFileAbsolutePath == null || irodsTargetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsTargetFileAbsolutePath");
        }
        if (targetResourceName == null) {
            throw new IllegalArgumentException("null or empty targetResourceName");
        }
        log.info("copyIrodsDataObjectWithForce, irodsSourceFileAbsolutePath: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("irodsTargetFileAbsolutePath:{}", (Object)irodsTargetFileAbsolutePath);
        log.info("at resource: {}", (Object)targetResourceName);
        IRODSFile sourceFile = this.getIRODSFileFactory().instanceIRODSFile(irodsSourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
        targetFile.setResource(targetResourceName);
        TransferControlBlock transferControlBlock = this.buildDefaultTransferControlBlockBasedOnJargonProperties();
        transferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.USE_FORCE);
        this.copyIRODSDataObject(sourceFile, targetFile, transferControlBlock, null);
        log.info("copy complete");
    }

    @Override
    public void replicateIrodsDataObjectToAllResourcesInResourceGroup(String irodsFileAbsolutePath, String irodsResourceGroupName) throws JargonException {
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsFileAbsolutePath");
        }
        if (irodsResourceGroupName == null || irodsResourceGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty targetResource");
        }
        log.info("replicate operation, irodsFileAbsolutePath: {}", (Object)irodsFileAbsolutePath);
        log.info("to resource group: {}", (Object)irodsResourceGroupName);
        DataObjInp dataObjInp = DataObjInp.instanceForReplicateToResourceGroup(irodsFileAbsolutePath, irodsResourceGroupName);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (JargonException je) {
            log.error("error replicating irods file to resource group", je);
            throw je;
        }
        log.info("replication complete");
    }

    @Override
    public List<Resource> getResourcesForDataObject(String dataObjectPath, String dataObjectName) throws JargonException {
        log.info("getting resources for path:{}", (Object)dataObjectPath);
        ResourceAO resourceAO = this.getIRODSAccessObjectFactory().getResourceAO(this.getIRODSAccount());
        StringBuilder sb = new StringBuilder();
        sb.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        sb.append(" = '");
        sb.append(IRODSDataConversionUtil.escapeSingleQuotes(dataObjectPath));
        sb.append('\'');
        sb.append(" AND ");
        sb.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        sb.append(" = '");
        sb.append(IRODSDataConversionUtil.escapeSingleQuotes(dataObjectName));
        sb.append('\'');
        return resourceAO.findWhere(sb.toString());
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObject(String dataObjectCollectionAbsPath, String dataObjectFileName) throws JargonException {
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            return this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, dataObjectCollectionAbsPath, dataObjectFileName);
        }
        catch (JargonQueryException e) {
            log.error("query exception looking up data object:{}", (Object)dataObjectCollectionAbsPath, (Object)e);
            log.error("fileName: {}", (Object)dataObjectFileName);
            throw new JargonException(e);
        }
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObject(String dataObjectAbsolutePath) throws JargonException {
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectAbsolutePath");
        }
        log.info("findMetadataValuesForDataObject: {}", (Object)dataObjectAbsolutePath);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(dataObjectAbsolutePath);
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            return this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, irodsFile.getParent(), irodsFile.getName());
        }
        catch (JargonQueryException e) {
            log.error("query exception looking up data object:{}", (Object)dataObjectAbsolutePath, (Object)e);
            throw new JargonException(e);
        }
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObject(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsFile");
        }
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            return this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, irodsFile.getParent(), irodsFile.getName());
        }
        catch (JargonQueryException e) {
            log.error("query exception rethrown as Jargon Exception", e);
            throw new JargonException(e);
        }
    }

    @Override
    public String computeMD5ChecksumOnDataObject(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("irodsFile is null");
        }
        log.info("computing checksum on irodsFile: {}", (Object)irodsFile.getAbsolutePath());
        DataObjInp dataObjInp = DataObjInp.instanceForDataObjectChecksum(irodsFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
        if (response == null) {
            log.error("invalid response to checksum call, response was null, expected checksum value");
            throw new JargonException("invalid response to checksum call, received null response when doing checksum on file:" + irodsFile);
        }
        String returnedChecksum = response.getTag("myStr").getStringValue();
        log.info("checksum is: {}", (Object)returnedChecksum);
        return returnedChecksum;
    }

    @Override
    public void setAccessPermissionRead(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absolutePath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionReadInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absolutePath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionWrite(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absolutePath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionWriteInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absolutePath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwn(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absolutePath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwnInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absolutePath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionsForUser(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absolutePath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionsForUserInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absolutePath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public FilePermissionEnum getPermissionForDataObject(String absolutePath, String userName, String zone) throws JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        log.info("getPermissionForDataObject for absPath:{}", (Object)absolutePath);
        log.info("userName:{}", (Object)userName);
        IRODSFileSystemAO irodsFileSystemAO = this.getIRODSAccessObjectFactory().getIRODSFileSystemAO(this.getIRODSAccount());
        int permissionVal = irodsFileSystemAO.getFilePermissionsForGivenUser(this.getIRODSFileFactory().instanceIRODSFile(absolutePath), userName);
        FilePermissionEnum filePermissionEnum = FilePermissionEnum.valueOf(permissionVal);
        return filePermissionEnum;
    }

    @Override
    public List<UserFilePermission> listPermissionsForDataObject(String irodsCollectionAbsolutePath, String dataName) throws JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (dataName == null || dataName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataName");
        }
        log.info("listPermissionsForDataObject path: {}", (Object)irodsCollectionAbsolutePath);
        log.info("dataName: {}", (Object)irodsCollectionAbsolutePath);
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        StringBuilder query = new StringBuilder(DataAOHelper.buildACLQueryForCollectionPathAndDataName(irodsCollectionAbsolutePath, dataName));
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                userFilePermissions.add(this.buildUserFilePermissionFromResultRow(row));
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in query loading user file permissions for data object", e);
        }
        return userFilePermissions;
    }

    private UserFilePermission buildUserFilePermissionFromResultRow(IRODSQueryResultRow row) throws JargonException {
        UserFilePermission userFilePermission = new UserFilePermission(row.getColumn(0), row.getColumn(1), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(2))), UserTypeEnum.findTypeByString(row.getColumn(3)));
        return userFilePermission;
    }

    @Override
    public List<UserFilePermission> listPermissionsForDataObject(String irodsDataObjectAbsolutePath) throws JargonException {
        if (irodsDataObjectAbsolutePath == null || irodsDataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsDataObjectAbsolutePath");
        }
        log.info("listPermissionsForDataObject: {}", (Object)irodsDataObjectAbsolutePath);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(irodsDataObjectAbsolutePath);
        return this.listPermissionsForDataObject(irodsFile.getParent(), irodsFile.getName());
    }

    @Override
    public void modifyAvuValueBasedOnGivenAttributeAndUnit(String absolutePath, AvuData avuData) throws DataNotFoundException, JargonException {
        List<MetaDataAndDomainData> result;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null avuData");
        }
        log.info("setting avu metadata value for dataObject");
        log.info("with  avu metadata:{}", avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.ATTRIBUTE, AVUQueryOperatorEnum.EQUAL, avuData.getAttribute()));
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.UNITS, AVUQueryOperatorEnum.EQUAL, avuData.getUnit()));
            result = this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, absolutePath);
        }
        catch (JargonQueryException e) {
            log.error("error querying data for avu", e);
            throw new JargonException("error querying data for AVU");
        }
        if (result.isEmpty()) {
            throw new DataNotFoundException("no avu data found");
        }
        if (result.size() > 1) {
            throw new JargonException("more than one AVU found with given attribute and unit, cannot modify non-unique AVU's in this way");
        }
        AvuData currentAvuData = new AvuData(result.get(0).getAvuAttribute(), result.get(0).getAvuValue(), result.get(0).getAvuUnit());
        AvuData modAvuData = new AvuData(result.get(0).getAvuAttribute(), avuData.getValue(), result.get(0).getAvuUnit());
        this.modifyAVUMetadata(absolutePath, currentAvuData, modAvuData);
        log.info("metadata modified to:{}", modAvuData);
    }

    @Override
    public void modifyAVUMetadata(String dataObjectAbsolutePath, AvuData currentAvuData, AvuData newAvuData) throws DataNotFoundException, JargonException {
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectAbsolutePath");
        }
        if (currentAvuData == null) {
            throw new IllegalArgumentException("null currentAvuData");
        }
        if (newAvuData == null) {
            throw new IllegalArgumentException("null newAvuData");
        }
        log.info("overwrite avu metadata for data object: {}", currentAvuData);
        log.info("with new avu metadata:{}", newAvuData);
        log.info("absolute path: {}", (Object)dataObjectAbsolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForModifyDataObjectMetadata(dataObjectAbsolutePath, currentAvuData, newAvuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target data object was not found, could not modify AVU");
            }
            log.error("jargon exception modifying AVU metadata", je);
            throw je;
        }
        log.debug("metadata rewritten");
    }

    @Override
    public void modifyAVUMetadata(String irodsCollectionAbsolutePath, String dataObjectName, AvuData currentAvuData, AvuData newAvuData) throws DataNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (dataObjectName == null || dataObjectName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectName");
        }
        if (currentAvuData == null) {
            throw new IllegalArgumentException("null currentAvuData");
        }
        if (newAvuData == null) {
            throw new IllegalArgumentException("null newAvuData");
        }
        log.info("overwrite avu metadata for collection: {}", currentAvuData);
        log.info("with new avu metadata:{}", newAvuData);
        log.info("absolute path: {}", (Object)irodsCollectionAbsolutePath);
        log.info(" data object name: {}", (Object)dataObjectName);
        StringBuilder sb = new StringBuilder();
        sb.append(irodsCollectionAbsolutePath);
        sb.append("/");
        sb.append(dataObjectName);
        this.modifyAVUMetadata(sb.toString(), currentAvuData, newAvuData);
    }

    @Override
    public UserFilePermission getPermissionForDataObjectForUserName(String irodsCollectionAbsolutePath, String dataName, String userName) throws JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (dataName == null || dataName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataName");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("listPermissionsForDataObjectForUserName path: {}", (Object)irodsCollectionAbsolutePath);
        log.info("dataName: {}", (Object)irodsCollectionAbsolutePath);
        log.info("userName:{}", (Object)userName);
        UserFilePermission userFilePermission = null;
        StringBuilder query = new StringBuilder(DataAOHelper.buildACLQueryForCollectionPathAndDataName(irodsCollectionAbsolutePath, dataName));
        query.append(" AND ");
        query.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        query.append(" = '");
        query.append(userName);
        query.append("'");
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query.toString(), this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        try {
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
            IRODSQueryResultRow row = resultSet.getFirstResult();
            userFilePermission = this.buildUserFilePermissionFromResultRow(row);
            log.debug("loaded filePermission:{}", userFilePermission);
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:{}", (Object)query.toString(), (Object)e);
            throw new JargonException("error in query loading user file permissions for data object", e);
        }
        catch (DataNotFoundException dnf) {
            log.info("no data found for user ACL");
        }
        return userFilePermission;
    }

    @Override
    public List<Resource> listFileResources(String irodsAbsolutePath) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        log.info("listFileResources() for path:{}", (Object)irodsAbsolutePath);
        ResourceAOHelper resourceAOHelper = new ResourceAOHelper(this.getIRODSAccount(), this.getIRODSAccessObjectFactory());
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(irodsAbsolutePath);
        StringBuilder query = new StringBuilder();
        query.append(resourceAOHelper.buildResourceSelects());
        query.append(" where ");
        if (!irodsFile.exists() || !irodsFile.isFile()) {
            log.error("file for query does not exist, or is not a file at path:{}", (Object)irodsAbsolutePath);
            throw new JargonException("file does not exist, or is not a file");
        }
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsFile.getParent()));
        query.append("'");
        query.append(" AND ");
        query.append(RodsGenQueryEnum.COL_DATA_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsFile.getName()));
        query.append("'");
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        String queryString = query.toString();
        if (log.isInfoEnabled()) {
            log.info("resource query:{}", (Object)this.toString());
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error("query exception for:{}", (Object)queryString, (Object)e);
            throw new JargonException("error in query");
        }
        List<Resource> resources = resourceAOHelper.buildResourceListFromResultSet(resultSet);
        if (resources.isEmpty()) {
            log.warn("no data found");
            throw new DataNotFoundException("no resources found for file:" + irodsFile.getAbsolutePath());
        }
        return resources;
    }

    @Override
    public UserFilePermission getPermissionForDataObjectForUserName(String irodsAbsolutePath, String userName) throws JargonException {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("listPermissionsForDataObjectForUserName path: {}", (Object)irodsAbsolutePath);
        log.info("userName:{}", (Object)userName);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(irodsAbsolutePath);
        return this.getPermissionForDataObjectForUserName(irodsFile.getParent(), irodsFile.getName(), userName);
    }

    private TransferOptions buildDefaultTransferOptionsIfNotSpecified(TransferOptions transferOptions) throws JargonException {
        TransferOptions myTransferOptions = transferOptions;
        myTransferOptions = transferOptions == null ? this.getIRODSSession().buildTransferOptionsBasedOnJargonProperties() : new TransferOptions(transferOptions);
        return myTransferOptions;
    }

    private TransferControlBlock checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(TransferControlBlock transferControlBlock) throws JargonException {
        TransferControlBlock effectiveTransferControlBlock = transferControlBlock;
        if (effectiveTransferControlBlock == null) {
            log.info("no transferControlBlock provided, building a default version");
            effectiveTransferControlBlock = DefaultTransferControlBlock.instance();
        }
        if (effectiveTransferControlBlock.getTransferOptions() == null) {
            log.info("creating a default transferOptions, as none specified");
            effectiveTransferControlBlock.setTransferOptions(this.getIRODSSession().buildTransferOptionsBasedOnJargonProperties());
        }
        return effectiveTransferControlBlock;
    }

    private static enum OverwriteResponse {
        SKIP,
        PROCEED_WITH_NO_FORCE,
        PROCEED_WITH_FORCE;

    }
}

