/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSAccessObject;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.IRODSAccessObjectFactoryImpl;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IRODSGenericAO
implements IRODSAccessObject {
    private final IRODSSession irodsSession;
    private final IRODSAccount irodsAccount;
    private static final Logger log = LoggerFactory.getLogger(IRODSGenericAO.class);

    public IRODSGenericAO(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        if (irodsSession == null) {
            throw new JargonException("IRODSSession is null");
        }
        if (irodsAccount == null) {
            throw new JargonException("IRODSAccount is null");
        }
        this.irodsSession = irodsSession;
        this.irodsAccount = irodsAccount;
        log.debug("establishing connection");
        irodsSession.currentConnection(irodsAccount);
    }

    @Override
    public final IRODSSession getIRODSSession() {
        return this.irodsSession;
    }

    @Override
    public final IRODSAccount getIRODSAccount() {
        return this.irodsAccount;
    }

    @Override
    public final IRODSServerProperties getIRODSServerProperties() throws JargonException {
        return this.getIRODSSession().currentConnection(this.getIRODSAccount()).getIRODSServerProperties();
    }

    @Override
    public final IRODSCommands getIRODSProtocol() throws JargonException {
        return this.getIRODSSession().currentConnection(this.getIRODSAccount());
    }

    @Override
    public JargonProperties getJargonProperties() {
        return this.getIRODSSession().getJargonProperties();
    }

    @Override
    public TransferControlBlock buildDefaultTransferControlBlockBasedOnJargonProperties() throws JargonException {
        return this.getIRODSSession().buildDefaultTransferControlBlockBasedOnJargonProperties();
    }

    @Override
    public IRODSAccessObjectFactory getIRODSAccessObjectFactory() throws JargonException {
        return IRODSAccessObjectFactoryImpl.instance(this.irodsSession);
    }

    @Override
    public IRODSFileFactory getIRODSFileFactory() throws JargonException {
        return IRODSAccessObjectFactoryImpl.instance(this.irodsSession).getIRODSFileFactory(this.irodsAccount);
    }
}

