/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.ZoneAO;
import org.irods.jargon.core.pub.aohelper.AOHelper;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.domain.Zone;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceAOHelper
extends AOHelper {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Zone lastZone = null;
    private final ZoneAO zoneAO;

    protected ResourceAOHelper(IRODSAccount irodsAccount, IRODSAccessObjectFactory irodsAccessObjectFactory) throws JargonException {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (irodsAccessObjectFactory == null) {
            throw new IllegalArgumentException("null irodsAccessObjectFactory");
        }
        this.zoneAO = irodsAccessObjectFactory.getZoneAO(irodsAccount);
    }

    protected String buildResourceSelects() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_R_RESC_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_RESC_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_ZONE_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_TYPE_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_CLASS_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_LOC.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_VAULT_PATH.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_FREE_SPACE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_FREE_SPACE_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_RESC_INFO.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_RESC_COMMENT.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_CREATE_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_MODIFY_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_R_RESC_STATUS.getName());
        return query.toString();
    }

    protected Resource buildResourceFromResultSetRow(IRODSQueryResultRow row) throws JargonException {
        Resource resource = new Resource();
        resource.setId(row.getColumn(0));
        resource.setName(row.getColumn(1));
        String zoneName = row.getColumn(2);
        if (this.lastZone == null || !zoneName.equals(this.lastZone.getZoneName())) {
            try {
                this.lastZone = this.zoneAO.getZoneByName(zoneName);
            }
            catch (DataNotFoundException e) {
                String message = "no zone found for zone in resource=" + zoneName;
                this.log.error(message);
                throw new JargonException("zone not found for resource, data integrity error", e);
            }
        }
        resource.setZone(this.lastZone);
        resource.setType(row.getColumn(3));
        resource.setResourceClass(row.getColumn(4));
        resource.setLocation(row.getColumn(5));
        resource.setVaultPath(row.getColumn(6));
        try {
            resource.setFreeSpace(Long.parseLong(row.getColumn(7)));
        }
        catch (NumberFormatException nfe) {
            resource.setFreeSpace(0L);
            this.log.warn("unable to format resourceFreeSpace for value:" + row.getColumn(7) + " setting to 0");
        }
        resource.setFreeSpaceTime(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(8)));
        resource.setInfo(row.getColumn(9));
        resource.setComment(row.getColumn(10));
        resource.setCreateTime(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(11)));
        resource.setModifyTime(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(12)));
        resource.setStatus(row.getColumn(13));
        if (this.log.isInfoEnabled()) {
            this.log.info("resource built \n");
            this.log.info(resource.toString());
        }
        return resource;
    }

    protected List<Resource> buildResourceListFromResultSet(IRODSQueryResultSetInterface resultSet) throws JargonException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            resources.add(this.buildResourceFromResultSetRow(row));
        }
        return resources;
    }
}

