/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.ExecMyRuleInp;
import org.irods.jargon.core.packinstr.RuleExecDelInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.DataObjectAOImpl;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.RuleProcessingAO;
import org.irods.jargon.core.pub.domain.DelayedRuleExecution;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileReader;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.rule.IRODSRule;
import org.irods.jargon.core.rule.IRODSRuleExecResult;
import org.irods.jargon.core.rule.IRODSRuleExecResultOutputParameter;
import org.irods.jargon.core.rule.IRODSRuleParameter;
import org.irods.jargon.core.rule.IRODSRuleTranslator;
import org.irods.jargon.core.rule.JargonRuleException;
import org.irods.jargon.core.utils.Base64;
import org.irods.jargon.core.utils.LocalFileUtils;
import org.irods.jargon.core.utils.TagHandlingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleProcessingAOImpl
extends IRODSGenericAO
implements RuleProcessingAO {
    public static final String LOCAL_PATH = "localPath";
    public static final String KEY_WORD = "keyWord";
    public static final String SVALUE = "svalue";
    public static final String COMMA = ",";
    private static final Logger log = LoggerFactory.getLogger(RuleProcessingAOImpl.class);
    public static final String CL_PUT_ACTION = "CL_PUT_ACTION";
    public static final String CL_GET_ACTION = "CL_GET_ACTION";
    public static final String BIN_BYTES_BUF_PI = "BinBytesBuf_PI";
    public static final String EXEC_CMD_OUT_PI = "ExecCmdOut_PI";
    public static final String DATA_OBJ_INP_PI = "DataObjInp_PI";
    public static final String KEY_VAL_PAIR_PI = "KeyValPair_PI";
    public static final String BUF_LEN = "buflen";
    public static final String OBJ_PATH = "objPath";
    public static final String RULE_EXEC_OUT = "ruleExecOut";
    private static final Object DEST_RESC_NAME = "destRescName";

    protected RuleProcessingAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSRuleExecResult executeRuleFromResource(String resourcePath, List<IRODSRuleParameter> irodsRuleInputParameters, RuleProcessingAO.RuleProcessingType ruleProcessingType) throws DataNotFoundException, JargonException {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourcePath");
        }
        String ruleString = LocalFileUtils.getClasspathResourceFileAsString(resourcePath);
        return this.executeRule(ruleString, irodsRuleInputParameters, ruleProcessingType);
    }

    @Override
    public IRODSRuleExecResult executeRuleFromIRODSFile(String ruleFileAbsolutePath, List<IRODSRuleParameter> irodsRuleInputParameters, RuleProcessingAO.RuleProcessingType ruleProcessingType) throws JargonException {
        if (ruleFileAbsolutePath == null || ruleFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty ruleFileAbsolutePath");
        }
        IRODSFileReader irodsFileReader = this.getIRODSFileFactory().instanceIRODSFileReader(ruleFileAbsolutePath);
        StringWriter writer = null;
        String ruleString = null;
        try {
            writer = new StringWriter();
            char[] buff = new char[1024];
            int i = 0;
            while ((i = irodsFileReader.read(buff)) > -1) {
                writer.write(buff, 0, i);
            }
            ruleString = writer.toString();
        }
        catch (IOException ioe) {
            log.error("io exception reading rule data from resource", ioe);
            throw new JargonException("error reading rule from resource", ioe);
        }
        finally {
            try {
                irodsFileReader.close();
                writer.close();
            }
            catch (IOException e) {}
        }
        return this.executeRule(ruleString, irodsRuleInputParameters, ruleProcessingType);
    }

    @Override
    public IRODSRuleExecResult executeRule(String irodsRuleAsString) throws JargonRuleException, JargonException {
        log.info("executing rule: {}", (Object)irodsRuleAsString);
        IRODSRuleTranslator irodsRuleTranslator = new IRODSRuleTranslator(this.getIRODSServerProperties());
        if (this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0") && IRODSRuleTranslator.isUsingNewRuleSyntax(irodsRuleAsString)) {
            log.debug("adding @external to the rule body");
            StringBuilder bodyWithExtern = new StringBuilder("@external\n");
            bodyWithExtern.append(irodsRuleAsString);
            irodsRuleAsString = bodyWithExtern.toString();
        }
        IRODSRule irodsRule = irodsRuleTranslator.translatePlainTextRuleIntoIRODSRule(irodsRuleAsString);
        log.debug("translated rule: {}", irodsRule);
        ExecMyRuleInp execMyRuleInp = ExecMyRuleInp.instance(irodsRule);
        Tag response = this.getIRODSProtocol().irodsFunction(execMyRuleInp);
        log.debug("response from rule exec: {}", (Object)response.parseTag());
        IRODSRuleExecResult irodsRuleExecResult = this.processRuleResult(response, irodsRule);
        log.debug("processing end of rule execution by reading message");
        return irodsRuleExecResult;
    }

    @Override
    public IRODSRuleExecResult executeRule(String irodsRuleAsString, List<IRODSRuleParameter> inputParameterOverrides, RuleProcessingAO.RuleProcessingType ruleProcessingType) throws JargonRuleException, JargonException {
        StringBuilder bodyWithExtern;
        if (irodsRuleAsString == null || irodsRuleAsString.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsRuleAsString");
        }
        if (ruleProcessingType == null) {
            throw new IllegalArgumentException("null ruleProcessingType");
        }
        log.info("executing rule: {}", (Object)irodsRuleAsString);
        IRODSRuleTranslator irodsRuleTranslator = new IRODSRuleTranslator(this.getIRODSServerProperties());
        if (this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0") && IRODSRuleTranslator.isUsingNewRuleSyntax(irodsRuleAsString)) {
            if (ruleProcessingType == RuleProcessingAO.RuleProcessingType.CLASSIC) {
                throw new JargonRuleException("cannot run new format rule as CLASSIC");
            }
            log.info("verified as new format");
        } else if (ruleProcessingType != RuleProcessingAO.RuleProcessingType.CLASSIC) {
            throw new JargonRuleException("must run old format rule as CLASSIC");
        }
        if (ruleProcessingType == RuleProcessingAO.RuleProcessingType.CLASSIC) {
            log.debug("classic, do not add external or internal");
        } else if (ruleProcessingType == RuleProcessingAO.RuleProcessingType.INTERNAL) {
            log.debug("adding @internal to the rule body");
            bodyWithExtern = new StringBuilder("@internal\n");
            bodyWithExtern.append(irodsRuleAsString);
            irodsRuleAsString = bodyWithExtern.toString();
        } else {
            log.debug("adding @external to the rule body");
            bodyWithExtern = new StringBuilder("@external\n");
            bodyWithExtern.append(irodsRuleAsString);
            irodsRuleAsString = bodyWithExtern.toString();
        }
        IRODSRule irodsRule = irodsRuleTranslator.translatePlainTextRuleIntoIRODSRule(irodsRuleAsString, inputParameterOverrides);
        log.debug("translated rule: {}", irodsRule);
        ExecMyRuleInp execMyRuleInp = ExecMyRuleInp.instance(irodsRule);
        Tag response = this.getIRODSProtocol().irodsFunction(execMyRuleInp);
        log.debug("response from rule exec: {}", (Object)response.parseTag());
        IRODSRuleExecResult irodsRuleExecResult = this.processRuleResult(response, irodsRule);
        log.debug("processing end of rule execution by reading message");
        return irodsRuleExecResult;
    }

    private IRODSRuleExecResult processRuleResult(Tag irodsRuleResult, IRODSRule irodsRule) throws JargonRuleException, JargonException {
        if (irodsRule == null) {
            throw new JargonException("irodsRule is nul");
        }
        if (irodsRuleResult == null) {
            log.debug("rule result was null, return empty output parameter map");
            IRODSRuleExecResult ruleResult = IRODSRuleExecResult.instance(irodsRule, new HashMap<String, IRODSRuleExecResultOutputParameter>());
            return ruleResult;
        }
        int parametersLength = irodsRuleResult.getTag("paramLen").getIntValue();
        log.debug("I have {} parameters from the rule", parametersLength);
        Map<String, IRODSRuleExecResultOutputParameter> outputParameters = this.processIndividualParameters(irodsRuleResult, parametersLength);
        IRODSRuleExecResult irodsRuleExecResult = IRODSRuleExecResult.instance(irodsRule, outputParameters);
        log.info("execute result: {}", irodsRuleExecResult);
        return irodsRuleExecResult;
    }

    @Override
    public int purgeAllDelayedExecQueue() throws JargonException {
        int numberPurged = 0;
        log.info("purgeAllDelayedExecQueue");
        List<DelayedRuleExecution> delayedRuleExecutions = this.listAllDelayedRuleExecutions(0);
        RuleExecDelInp ruleExecDelInp = null;
        for (DelayedRuleExecution delayedRuleExecution : delayedRuleExecutions) {
            log.info("deleting rule with id:{}", delayedRuleExecution.getId());
            ruleExecDelInp = RuleExecDelInp.instanceForDeleteRule(String.valueOf(delayedRuleExecution.getId()));
            this.getIRODSProtocol().irodsFunction(ruleExecDelInp);
            ++numberPurged;
        }
        return numberPurged;
    }

    @Override
    public List<DelayedRuleExecution> listAllDelayedRuleExecutions(int partialStartIndex) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex must be 0 or greater");
        }
        log.info("listAllDelayedRuleExecutions() with partial start of {}", partialStartIndex);
        ArrayList<DelayedRuleExecution> delayedRuleExecutions = new ArrayList<DelayedRuleExecution>();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_ID.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_NAME.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_USER_NAME.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_ADDRESS.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_TIME.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_FREQUENCY.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_PRIORITY.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_ESTIMATED_EXE_TIME.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_NOTIFICATION_ADDR.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_LAST_EXE_TIME.getName());
        sb.append(COMMA);
        sb.append(RodsGenQueryEnum.COL_RULE_EXEC_STATUS.getName());
        String query = sb.toString();
        log.debug("query for rule exec status:{}", (Object)query);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(query, 5000);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query: {}", (Object)query, (Object)e);
            throw new JargonException("error in query for rule execution status", e);
        }
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            delayedRuleExecutions.add(this.buildDelayedRuleExecutionFromResultRow(row));
        }
        return delayedRuleExecutions;
    }

    private DelayedRuleExecution buildDelayedRuleExecutionFromResultRow(IRODSQueryResultRow row) throws JargonException {
        DelayedRuleExecution dre = new DelayedRuleExecution();
        dre.setId(Integer.parseInt(row.getColumn(0)));
        dre.setName(row.getColumn(1));
        dre.setUserName(row.getColumn(2));
        dre.setAddress(row.getColumn(3));
        dre.setExecTime(row.getColumn(4));
        dre.setFrequency(row.getColumn(5));
        dre.setPriority(row.getColumn(6));
        dre.setEstimatedExecTime(row.getColumn(7));
        dre.setNotificationAddress(row.getColumn(8));
        dre.setLastExecTime(row.getColumn(9));
        dre.setExecStatus(row.getColumn(10));
        dre.setLastResult(row.isLastResult());
        dre.setCount(row.getRecordCount());
        if (log.isInfoEnabled()) {
            log.info("built delayed rule execution built \n");
            log.info(dre.toString());
        }
        return dre;
    }

    private Map<String, IRODSRuleExecResultOutputParameter> processIndividualParameters(Tag rulesTag, int parametersLength) throws JargonException {
        HashMap<String, IRODSRuleExecResultOutputParameter> irodsRuleOutputParameters = new HashMap<String, IRODSRuleExecResultOutputParameter>();
        boolean clientSideActionOccurred = false;
        for (int i = 0; i < parametersLength; ++i) {
            Tag msParam = rulesTag.getTag("MsParam_PI", i);
            String label = msParam.getTag("label").getStringValue();
            String type = msParam.getTag("type").getStringValue();
            Object value = this.getParameter(type, msParam);
            log.debug("rule parameter label: {}", (Object)label);
            log.debug("parm type: {}", (Object)type);
            log.debug("value: {}", value);
            if (label.equals(CL_PUT_ACTION) || label.equals(CL_GET_ACTION)) {
                clientSideActionOccurred = true;
                irodsRuleOutputParameters.put(label, this.processRuleResponseWithClientSideActionTag(label, type, value, msParam));
                continue;
            }
            irodsRuleOutputParameters.put(label, this.processRuleResponseTag(label, type, value, msParam));
        }
        if (clientSideActionOccurred) {
            log.info("a client side action ocurred, I have an irods message to consume to end the rule processing");
        }
        log.info("rule operation complete");
        return irodsRuleOutputParameters;
    }

    private IRODSRuleExecResultOutputParameter processRuleResponseTag(String label, String type, Object value, Tag msParam) throws JargonException {
        log.debug("processing output parameter for label: {}", (Object)label);
        log.debug("type: {}", (Object)type);
        log.debug("value: {}", value);
        log.debug("tag: {}", (Object)msParam.getStringValue());
        if (type.equals(EXEC_CMD_OUT_PI)) {
            // empty if block
        }
        return IRODSRuleExecResultOutputParameter.instance(label, IRODSRuleExecResultOutputParameter.OutputParamType.STRING, value);
    }

    private Object getParameter(String type, Tag parameterTag) throws JargonException {
        if (type.equals("INT_PI")) {
            return parameterTag.getTag("INT_PI").getTag("myInt").getIntValue();
        }
        if (type.equals("BUF_LEN_PI")) {
            return parameterTag.getTag(BIN_BYTES_BUF_PI).getTag("buf").getValue();
        }
        if (type.equals(EXEC_CMD_OUT_PI)) {
            return this.extractStringFromExecCmdOut(parameterTag);
        }
        if (type.equals("STR_PI")) {
            return parameterTag.getTag("STR_PI").getTag("myStr").getStringValue();
        }
        return parameterTag.getTag(type);
    }

    private Object extractStringFromExecCmdOut(Tag parameterTag) throws JargonException {
        String results;
        Tag exec = parameterTag.getTag(EXEC_CMD_OUT_PI);
        if (exec.getLength() != 3) {
            throw new JargonException("expected 3 tags in ExecCmdOut_PI tag set");
        }
        int status = exec.getTag("status").getIntValue();
        log.debug("status of exec: {}", status);
        if (status != 0) {
            throw new JargonException("invalid status in response ExecCmdOut_PI tag:" + status);
        }
        Tag bufTag = exec.getTag(BIN_BYTES_BUF_PI, 0).getTag("buf");
        if (bufTag != null) {
            String base64Encoded = bufTag.getStringValue();
            byte[] decoded = Base64.fromString(base64Encoded);
            results = new String(decoded);
        } else {
            results = "";
        }
        return results;
    }

    private IRODSRuleExecResultOutputParameter processRuleResponseWithClientSideActionTag(String label, String type, Object value, Tag msParam) throws JargonException {
        if (!label.equals(CL_PUT_ACTION) && !label.equals(CL_GET_ACTION)) {
            throw new JargonException("this is not a client side action");
        }
        Tag fileAction = msParam.getTag(type);
        String irodsFileAbsolutePath = fileAction.getTag(OBJ_PATH).getStringValue();
        log.info("client side action - irods file absolute path: {}", (Object)irodsFileAbsolutePath);
        Tag kvp = fileAction.getTag(KEY_VAL_PAIR_PI);
        Map<String, String> kvpMap = TagHandlingUtils.translateKeyValuePairTagIntoMap(kvp);
        log.debug("kvp map is:{}", kvpMap);
        String localPath = kvpMap.get(LOCAL_PATH);
        if (localPath == null) {
            log.error("no local file path found in tags");
            throw new JargonException("client side action indicated, but no localPath in tag");
        }
        String resourceName = kvpMap.get(DEST_RESC_NAME);
        if (resourceName == null) {
            resourceName = "";
        }
        log.debug("getting reference to local file");
        File localFile = new File(localPath);
        if (label.equals(CL_GET_ACTION)) {
            this.clientSideGetAction(irodsFileAbsolutePath, localFile);
        } else if (label.equals(CL_PUT_ACTION)) {
            this.clientSidePutAction(irodsFileAbsolutePath, localFile, resourceName);
        }
        StringBuilder putLabel = new StringBuilder();
        putLabel.append(label);
        putLabel.append('-');
        putLabel.append(irodsFileAbsolutePath);
        String labelValForAction = putLabel.toString();
        return IRODSRuleExecResultOutputParameter.instance(labelValForAction, IRODSRuleExecResultOutputParameter.OutputParamType.CLIENT_ACTION_RESULT, localPath);
    }

    private void clientSidePutAction(String irodsFileAbsolutePath, File localFile, String resourceName) throws JargonException {
        DataObjectAOImpl dataObjectAO = new DataObjectAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSFile irodsFile = dataObjectAO.instanceIRODSFileForPath(irodsFileAbsolutePath);
        irodsFile.setResource(resourceName);
        log.debug("performing put of file");
        dataObjectAO.putLocalDataObjectToIRODSForClientSideRuleOperation(localFile, irodsFile, true, null);
        log.debug("client side put action was successful");
    }

    private void clientSideGetAction(String irodsFileAbsolutePath, File localFile) throws JargonException, DataNotFoundException {
        log.info("client-side get action");
        DataObjectAOImpl dataObjectAO = new DataObjectAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSFile irodsFile = dataObjectAO.instanceIRODSFileForPath(irodsFileAbsolutePath);
        log.info("performing get of file");
        dataObjectAO.irodsDataObjectGetOperationForClientSideAction(irodsFile, localFile, null);
        log.debug("client side get action was successful");
    }
}

