/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.aohelper;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.UserAO;
import org.irods.jargon.core.pub.aohelper.AOHelper;
import org.irods.jargon.core.pub.domain.Collection;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionAOHelper
extends AOHelper {
    public static final Logger LOG = LoggerFactory.getLogger(CollectionAOHelper.class);

    public static String buildSelects() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_COLL_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_PARENT_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_OWNER_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_OWNER_ZONE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_MAP_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_INHERITANCE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_COMMENTS.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_CREATE_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_MODIFY_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_INFO1.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_INFO2.getName());
        return query.toString();
    }

    public static String buildMetadataSelects() {
        StringBuilder query = new StringBuilder();
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS.getName());
        return query.toString();
    }

    public static Collection buildCollectionFromResultSetRow(IRODSQueryResultRow row) throws JargonException {
        Collection collection = new Collection();
        collection.setCollectionId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(0)));
        collection.setCollectionName(row.getColumn(1));
        collection.setCollectionParentName(row.getColumn(2));
        collection.setCollectionOwnerName(row.getColumn(3));
        collection.setCollectionOwnerZone(row.getColumn(4));
        collection.setCollectionMapId(row.getColumn(5));
        collection.setCollectionInheritance(row.getColumn(6));
        collection.setComments(row.getColumn(7));
        collection.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(8)));
        collection.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(9)));
        collection.setInfo1(row.getColumn(10));
        collection.setInfo2(row.getColumn(11));
        collection.setCount(row.getRecordCount());
        collection.setLastResult(row.isLastResult());
        if (LOG.isInfoEnabled()) {
            LOG.info("collection built \n");
            LOG.info(collection.toString());
        }
        return collection;
    }

    public static StringBuilder buildConditionPart(AVUQueryElement queryElement) {
        StringBuilder queryCondition = new StringBuilder();
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.ATTRIBUTE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.VALUE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.UNITS) {
            queryCondition.append(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        return queryCondition;
    }

    public static List<Collection> buildListFromResultSet(IRODSQueryResultSetInterface resultSet) throws JargonException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            collections.add(CollectionAOHelper.buildCollectionFromResultSetRow(row));
        }
        return collections;
    }

    public static CollectionAndDataObjectListingEntry buildCollectionListEntryFromResultSetRowForCollectionQuery(IRODSQueryResultRow row) throws JargonException {
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setParentPath(row.getColumn(0));
        entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
        entry.setPathOrName(row.getColumn(1));
        entry.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(2)));
        entry.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(3)));
        entry.setId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(4)));
        entry.setOwnerName(row.getColumn(5));
        entry.setOwnerZone(row.getColumn(6));
        entry.setCount(row.getRecordCount());
        entry.setLastResult(row.isLastResult());
        if (LOG.isDebugEnabled()) {
            LOG.info("listing entry built {}", (Object)entry.toString());
        }
        return entry;
    }

    public static CollectionAndDataObjectListingEntry buildCollectionListEntryFromResultSetRowForDataObjectQuery(IRODSQueryResultRow row) throws JargonException {
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setParentPath(row.getColumn(0));
        entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT);
        entry.setPathOrName(row.getColumn(1));
        entry.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(2)));
        entry.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(3)));
        entry.setId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(4)));
        entry.setDataSize(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(5)));
        entry.setOwnerName(row.getColumn(7));
        entry.setCount(row.getRecordCount());
        entry.setLastResult(row.isLastResult());
        if (LOG.isDebugEnabled()) {
            LOG.info("listing entry built {}", (Object)entry.toString());
        }
        return entry;
    }

    public static String buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry() {
        StringBuilder query = new StringBuilder();
        query.append(RodsGenQueryEnum.COL_COLL_PARENT_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_CREATE_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_MODIFY_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_OWNER_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_OWNER_ZONE.getName());
        return query.toString();
    }

    public static String buildInheritanceQueryForCollectionAbsolutePath(String absolutePathToCollection) {
        if (absolutePathToCollection == null || absolutePathToCollection.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToCollection");
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_COLL_INHERITANCE.getName());
        query.append(" WHERE  ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(absolutePathToCollection));
        query.append("'");
        return query.toString();
    }

    public static void buildUserFilePermissionForCollection(List<UserFilePermission> userFilePermissions, IRODSQueryResultRow row, UserAO userAO) throws JargonException {
        StringBuilder userAndZone = new StringBuilder(row.getColumn(9));
        userAndZone.append('#');
        userAndZone.append(row.getColumn(10));
        User user = userAO.findByName(userAndZone.toString());
        UserFilePermission userFilePermission = new UserFilePermission(row.getColumn(9), row.getColumn(8), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(7))), user.getUserType(), row.getColumn(10));
        userFilePermissions.add(userFilePermission);
    }

    public static void buildUserFilePermissionForDataObject(List<UserFilePermission> userFilePermissions, IRODSQueryResultRow row) throws JargonException {
        UserFilePermission userFilePermission = new UserFilePermission(row.getColumn(8), row.getColumn(9), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(10))), UserTypeEnum.findTypeByString(row.getColumn(11)));
        userFilePermissions.add(userFilePermission);
    }

    public static String buildACLQueryForCollectionName(String irodsCollectionAbsolutePath) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_NAME.getName());
        query.append(",");
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ID.getName());
        query.append(",");
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_TYPE.getName());
        query.append(",");
        query.append(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ZONE.getName());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(" = '");
        query.append(IRODSDataConversionUtil.escapeSingleQuotes(irodsCollectionAbsolutePath));
        query.append("'");
        return query.toString();
    }
}

