/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSFileSystemAOImpl;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.io.FileIOOperationsAOImpl;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileImpl;
import org.irods.jargon.core.pub.io.IRODSFileInputStream;
import org.irods.jargon.core.pub.io.IRODSFileOutputStream;
import org.irods.jargon.core.pub.io.IRODSFileReader;
import org.irods.jargon.core.pub.io.IRODSFileWriter;
import org.irods.jargon.core.pub.io.IRODSRandomAccessFile;
import org.irods.jargon.core.pub.io.SessionClosingIRODSFileInputStream;
import org.irods.jargon.core.pub.io.SessionClosingIRODSFileOutputStream;
import org.irods.jargon.core.utils.IRODSUriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSFileFactoryImpl
extends IRODSGenericAO
implements IRODSFileFactory {
    public static final String PATH_SEPARATOR = "/";
    static Logger log = LoggerFactory.getLogger(IRODSFileFactoryImpl.class);

    public IRODSFileFactoryImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSFile instanceIRODSFile(String path) throws JargonException {
        IRODSFileSystemAOImpl irodsFileSystem = new IRODSFileSystemAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        return new IRODSFileImpl(path, irodsFileSystem);
    }

    @Override
    public IRODSFile instanceIRODSFile(URI uri) throws JargonException {
        if (uri == null) {
            throw new JargonException("null uri");
        }
        IRODSAccount irodsAccount = null;
        try {
            irodsAccount = IRODSUriUtils.getIRODSAccountFromURI(uri);
        }
        catch (JargonException je) {
            log.info("no account info in URI, use default account");
            irodsAccount = this.getIRODSAccount();
        }
        String fileName = uri.getPath();
        log.debug("irods account: {}", (Object)irodsAccount.toString());
        log.debug("fileName: {}", (Object)fileName);
        IRODSFileSystemAOImpl irodsFileSystemAO = new IRODSFileSystemAOImpl(this.getIRODSSession(), irodsAccount);
        return new IRODSFileImpl(uri.getPath(), irodsFileSystemAO);
    }

    @Override
    public IRODSFile instanceIRODSFile(String parent, String child) throws JargonException {
        if (parent == null) {
            throw new JargonException("parent is null");
        }
        if (child == null) {
            throw new JargonException("child is null");
        }
        if (child.isEmpty() && parent.isEmpty()) {
            throw new JargonException("both child and parent names are blank");
        }
        IRODSFileSystemAOImpl irodsFileSystem = new IRODSFileSystemAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        if (parent.isEmpty() && child.equals(PATH_SEPARATOR)) {
            return new IRODSFileImpl(child, irodsFileSystem);
        }
        return new IRODSFileImpl(parent, child, (IRODSFileSystemAO)irodsFileSystem);
    }

    @Override
    public IRODSFile instanceIRODSFile(File parent, String child) throws JargonException {
        if (parent == null) {
            throw new JargonException("parent is null");
        }
        if (child == null) {
            throw new JargonException("child is null");
        }
        IRODSFileSystemAOImpl irodsFileSystem = new IRODSFileSystemAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        return new IRODSFileImpl(parent, child, (IRODSFileSystemAO)irodsFileSystem);
    }

    @Override
    public IRODSFileOutputStream instanceIRODSFileOutputStream(IRODSFile file) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            return new IRODSFileOutputStream(file, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating output stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSFileOutputStream instanceIRODSFileOutputStreamWithRerouting(IRODSFile file) throws JargonException {
        try {
            if (!file.exists()) {
                log.info("file does not exist, creating a new file");
                file.createNewFile();
            } else if (!file.canWrite()) {
                log.info("this file is not writeable by the current user {}", (Object)file.getAbsolutePath());
                throw new JargonException("file is not writeable:" + file.getAbsolutePath());
            }
            IRODSAccount useThisAccount = this.getIRODSAccount();
            boolean reroute = false;
            if (this.getIRODSServerProperties().isSupportsConnectionRerouting()) {
                log.info("redirects are available, check to see if I need to redirect to a resource server");
                DataObjectAO dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
                String detectedHost = dataObjectAO.getHostForPutOperation(file.getAbsolutePath(), file.getResource());
                if (detectedHost == null || detectedHost.equals("thisAddress")) {
                    log.info("using given resource connection");
                } else if (detectedHost.equals("localhost")) {
                    log.warn("localhost received as detected host, ignore and do not reroute");
                } else {
                    useThisAccount = IRODSAccount.instanceForReroutedHost(this.getIRODSAccount(), detectedHost);
                    reroute = true;
                }
            }
            FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), useThisAccount);
            if (reroute) {
                IRODSFileFactory rerouteFileFactory = this.getIRODSAccessObjectFactory().getIRODSFileFactory(useThisAccount);
                IRODSFile irodsFile = rerouteFileFactory.instanceIRODSFile(file.getAbsolutePath());
                return new SessionClosingIRODSFileOutputStream(irodsFile, fileIOOperations);
            }
            IRODSFile irodsFile = this.instanceIRODSFile(file.getAbsolutePath());
            return new IRODSFileOutputStream(irodsFile, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating output stream", e);
            throw new JargonException(e);
        }
        catch (IOException ioException) {
            log.error("IOException creating output stream", ioException);
            throw new JargonException(ioException);
        }
    }

    @Override
    public SessionClosingIRODSFileOutputStream instanceSessionClosingIRODSFileOutputStream(IRODSFile file) throws JargonException {
        log.info("instanceSessionClosingIRODSFileOutputStream");
        if (file == null) {
            throw new IllegalArgumentException("null irodsFile");
        }
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            if (!file.exists()) {
                log.info("file does not exist, creating a new file");
                file.createNewFile();
            } else if (!file.canWrite()) {
                log.info("this file is not writeable by the current user {}", (Object)file.getAbsolutePath());
                throw new JargonException("file is not writeable:" + file.getAbsolutePath());
            }
            return new SessionClosingIRODSFileOutputStream(file, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating output stream", e);
            throw new JargonException(e);
        }
        catch (IOException ioException) {
            log.error("IOException creating output stream", ioException);
            throw new JargonException(ioException);
        }
    }

    @Override
    public IRODSFileOutputStream instanceIRODSFileOutputStream(String name) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            if (log.isInfoEnabled()) {
                log.info("creating IRODSFileImpl for:" + name);
            }
            IRODSFile irodsFile = this.instanceIRODSFile(name);
            irodsFile.createNewFile();
            return new IRODSFileOutputStream(irodsFile, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating output stream", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            log.error("IOException creating output stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSFileWriter instanceIRODSFileWriter(String name) throws JargonException {
        try {
            if (log.isInfoEnabled()) {
                log.info("creating IRODSFileWriter for:" + name);
            }
            IRODSFile irodsFile = this.instanceIRODSFile(name);
            irodsFile.createNewFile();
            return new IRODSFileWriter(irodsFile, this);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating FileWriter", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            log.error("IOException creating FileWriter", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSFileReader instanceIRODSFileReader(String irodsFileAbsolutePath) throws JargonException {
        try {
            IRODSFile irodsFile;
            if (log.isInfoEnabled()) {
                log.info("creating IRODSFileReader for:" + irodsFileAbsolutePath);
            }
            if (!(irodsFile = this.instanceIRODSFile(irodsFileAbsolutePath)).exists()) {
                throw new JargonException("file does not exist in iRODS");
            }
            if (!irodsFile.isFile()) {
                throw new JargonException("the given file is not a file in iRODS");
            }
            return new IRODSFileReader(irodsFile, this);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating FileReader", e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            log.error("IOException creating FileReader", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSFileInputStream instanceIRODSFileInputStream(IRODSFile file) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            return new IRODSFileInputStream(file, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating input stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSFileInputStream instanceIRODSFileInputStreamGivingFD(IRODSFile file, int fd) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            return new IRODSFileInputStream(file, fileIOOperations, fd);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating input stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public SessionClosingIRODSFileInputStream instanceSessionClosingIRODSFileInputStream(String name) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            if (log.isInfoEnabled()) {
                log.info("opening IRODSFileImpl for:" + name);
            }
            IRODSFile irodsFile = this.instanceIRODSFile(name);
            return new SessionClosingIRODSFileInputStream(irodsFile, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating output stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public SessionClosingIRODSFileInputStream instanceSessionClosingIRODSFileInputStream(IRODSFile file) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            return new SessionClosingIRODSFileInputStream(file, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating input stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSFileInputStream instanceIRODSFileInputStream(String name) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            if (log.isInfoEnabled()) {
                log.info("opening IRODSFileImpl for:" + name);
            }
            IRODSFile irodsFile = this.instanceIRODSFile(name);
            return new IRODSFileInputStream(irodsFile, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating output stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSFileInputStream instanceIRODSFileInputStreamWithRerouting(String irodsAbsolutePath) throws JargonException {
        IRODSAccount useThisAccount = this.getIRODSAccount();
        boolean reroute = false;
        if (this.getIRODSServerProperties().isSupportsConnectionRerouting()) {
            log.info("redirects are available, check to see if I need to redirect to a resource server");
            DataObjectAO dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
            String detectedHost = dataObjectAO.getHostForGetOperation(irodsAbsolutePath, "");
            if (detectedHost == null || detectedHost.equals("thisAddress")) {
                log.info("using given resource connection");
            } else {
                useThisAccount = IRODSAccount.instanceForReroutedHost(this.getIRODSAccount(), detectedHost);
                reroute = true;
            }
        }
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), useThisAccount);
        try {
            if (log.isInfoEnabled()) {
                log.info("opening IRODSFileImpl for:" + irodsAbsolutePath);
            }
            if (reroute) {
                IRODSFileFactory rerouteFileFactory = this.getIRODSAccessObjectFactory().getIRODSFileFactory(useThisAccount);
                IRODSFile irodsFile = rerouteFileFactory.instanceIRODSFile(irodsAbsolutePath);
                return new SessionClosingIRODSFileInputStream(irodsFile, fileIOOperations);
            }
            IRODSFile irodsFile = this.instanceIRODSFile(irodsAbsolutePath);
            return new IRODSFileInputStream(irodsFile, fileIOOperations);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound creating output stream", e);
            throw new JargonException(e);
        }
    }

    @Override
    public IRODSRandomAccessFile instanceIRODSRandomAccessFile(String name) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        log.info("opening IRODSFileImpl for: {}", (Object)name);
        IRODSFile irodsFile = this.instanceIRODSFile(name);
        if (!irodsFile.exists()) {
            log.info("requested file does not exist, will be created");
            try {
                irodsFile.createNewFile();
            }
            catch (IOException e) {
                log.error("IOException creating file for IRODSRandomAccessFile will be rethrown as JargonException", e);
                throw new JargonException(e);
            }
        }
        irodsFile.open();
        return new IRODSRandomAccessFile(irodsFile, fileIOOperations);
    }

    @Override
    public IRODSRandomAccessFile instanceIRODSRandomAccessFile(IRODSFile irodsFile) throws JargonException {
        FileIOOperationsAOImpl fileIOOperations = new FileIOOperationsAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        log.info("opening IRODSFileImpl for: {}", irodsFile.getAbsoluteFile());
        if (!irodsFile.exists()) {
            log.info("requested file does not exist, will be created");
            try {
                irodsFile.createNewFile();
            }
            catch (IOException e) {
                log.error("IOException creating file for IRODSRandomAccessFile will be rethrown as JargonException", e);
                throw new JargonException(e);
            }
        }
        irodsFile.open();
        return new IRODSRandomAccessFile(irodsFile, fileIOOperations);
    }
}

