/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonFileOrCollAlreadyExistsException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSAcceptAllFileNameFilter;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSFileImpl
extends File
implements IRODSFile {
    static Logger log = LoggerFactory.getLogger(IRODSFileImpl.class);
    private IRODSFileSystemAO irodsFileSystemAO = null;
    private transient ObjStat objStat = null;
    private String fileName = "";
    private String resource = "";
    private int fileDescriptor = -1;
    private List<String> directory = new ArrayList<String>();
    private static final long serialVersionUID = -6986662136294659059L;

    @Override
    public synchronized void reset() {
        this.objStat = null;
    }

    protected IRODSFileImpl(String pathName, IRODSFileSystemAO irodsFileSystemAO) throws JargonException {
        this("", pathName, irodsFileSystemAO);
        if (pathName == null || pathName.isEmpty()) {
            throw new JargonException("path name is null or empty");
        }
    }

    protected IRODSFileImpl(String parent, String child, IRODSFileSystemAO irodsFileSystemAO) throws JargonException {
        super(parent, child);
        if (irodsFileSystemAO == null) {
            throw new IllegalArgumentException("irodsFileSystemAO is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("null or missing parent name");
        }
        if (child == null) {
            throw new IllegalArgumentException("null child name");
        }
        if (parent.isEmpty() && child.isEmpty()) {
            throw new IllegalArgumentException("both parent and child names are empty");
        }
        this.irodsFileSystemAO = irodsFileSystemAO;
        this.setDirectory(parent);
        this.setFileName(child);
        this.makePathCanonical(parent);
    }

    protected IRODSFileImpl(File parent, String child, IRODSFileSystemAO irodsFileSystemAO) throws JargonException {
        this(parent.getAbsolutePath(), child, irodsFileSystemAO);
    }

    private void makePathCanonical(String dir) {
        int i = 0;
        boolean absolutePath = false;
        String canonicalTest = null;
        if (dir == null) {
            dir = "";
        }
        if ((this.fileName.equals("/") || this.fileName.equals("")) && dir.equals("")) {
            return;
        }
        if (this.fileName.equals("") && dir.equals("")) {
            String home = this.irodsFileSystemAO.getIRODSAccount().getHomeDirectory();
            int index = home.lastIndexOf("/");
            this.setDirectory(home.substring(0, index));
            this.setFileName(home.substring(index + 1));
            return;
        }
        if (dir.startsWith("/")) {
            absolutePath = true;
        }
        if (this.directory.size() > 0 && this.directory.get(0).toString().length() == 0) {
            absolutePath = true;
        }
        if (!absolutePath) {
            String home = this.irodsFileSystemAO.getIRODSAccount().getHomeDirectory();
            int index = home.indexOf("/");
            if (index >= 0) {
                do {
                    this.directory.add(i, home.substring(0, index));
                    home = home.substring(index + 1);
                    index = home.indexOf("/");
                    ++i;
                } while (index > 0);
            }
            if (!home.equals("") && home != null) {
                this.directory.add(i, home);
            }
        }
        for (i = 0; i < this.directory.size(); ++i) {
            canonicalTest = this.directory.get(i).toString();
            if (canonicalTest.equals(".")) {
                this.directory.remove(i);
                --i;
                continue;
            }
            if (canonicalTest.equals("..") && i >= 2) {
                this.directory.remove(i);
                this.directory.remove(i - 1);
                if (--i <= 0) continue;
                --i;
                continue;
            }
            if (canonicalTest.equals("..")) {
                this.directory.remove(i);
                --i;
                continue;
            }
            if (!canonicalTest.startsWith(separator)) continue;
            while ((canonicalTest = canonicalTest.substring(1)).startsWith("/")) {
            }
            this.directory.remove(i);
            this.directory.add(i, canonicalTest);
        }
        if (this.fileName.equals(".")) {
            this.fileName = this.directory.get(this.directory.size() - 1).toString();
            this.directory.remove(this.directory.size() - 1);
        } else if (this.fileName.equals("..")) {
            if (this.directory.size() > 1) {
                this.fileName = this.directory.get(this.directory.size() - 2).toString();
                this.directory.remove(this.directory.size() - 1);
                this.directory.remove(this.directory.size() - 1);
            } else {
                this.fileName = "/";
                this.directory.remove(this.directory.size() - 1);
            }
        }
    }

    private void setDirectory(String dir) {
        String localSeparator;
        int index;
        if (this.directory == null) {
            this.directory = new ArrayList<String>();
        }
        if ((index = dir.lastIndexOf(localSeparator = System.getProperty("file.separator"))) >= 0 && dir.substring(index + 1).length() > 0) {
            dir = dir.substring(0, index) + '/' + dir.substring(index + 1);
            index = dir.lastIndexOf(localSeparator);
        }
        while (this.directory.size() > 0 && dir.startsWith("/")) {
            dir = dir.substring(1);
        }
        index = dir.indexOf(47);
        if (index >= 0) {
            do {
                this.directory.add(dir.substring(0, index));
                while ((index = (dir = dir.substring(index + 1)).indexOf("/")) == 0) {
                }
            } while (index >= 0);
        }
        if (!dir.equals("") && dir != null) {
            this.directory.add(dir);
        }
    }

    private void setFileName(String filePath) {
        int index;
        String localSeparator = System.getProperty("file.separator");
        if (filePath == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        log.info("setting file name, given path = {}", (Object)filePath);
        log.info("detected local separator = {}", (Object)localSeparator);
        if (!localSeparator.equals("/")) {
            index = filePath.lastIndexOf(localSeparator);
            while (index >= 0 && filePath.substring(index + 1).length() > 0) {
                filePath = filePath.substring(0, index) + '/' + filePath.substring(index + 1);
                index = filePath.lastIndexOf(localSeparator);
            }
        }
        this.fileName = filePath;
        if (this.fileName.length() > 1) {
            index = this.fileName.lastIndexOf(47);
            while (index == this.fileName.length() - 1 && index >= 0) {
                this.fileName = this.fileName.substring(0, index);
                index = this.fileName.lastIndexOf(47);
            }
            if (index >= 0 && this.fileName.substring(index + 1).length() > 0) {
                this.setDirectory(this.fileName.substring(0, index + 1));
                this.fileName = this.fileName.substring(index + 1);
            }
        }
        log.info("file name was set as: {}", (Object)this.fileName);
    }

    @Override
    public synchronized boolean canRead() {
        boolean canRead = false;
        try {
            this.initializeObjStatForFile();
            canRead = this.irodsFileSystemAO.isFileReadable(this);
        }
        catch (FileNotFoundException e) {
            log.warn("file not found exception, return false", e);
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return canRead;
    }

    @Override
    public synchronized boolean canWrite() {
        boolean canWrite = false;
        try {
            this.initializeObjStatForFile();
            canWrite = this.irodsFileSystemAO.isFileWriteable(this);
        }
        catch (FileNotFoundException e) {
            log.warn("file not found exception, return false", e);
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return canWrite;
    }

    @Override
    public synchronized boolean createNewFile() throws IOException {
        try {
            this.fileDescriptor = this.irodsFileSystemAO.createFile(this.getAbsolutePath(), DataObjInp.OpenFlags.READ_WRITE, 33188);
            log.debug("file descriptor from new file create: {}", this.fileDescriptor);
            this.close();
            this.openKnowingExists();
            log.debug("file now closed");
        }
        catch (JargonFileOrCollAlreadyExistsException e) {
            return false;
        }
        catch (JargonException e) {
            String msg = "JargonException caught and rethrown as IOException:" + e.getMessage();
            log.error(msg, e);
            throw new IOException(e);
        }
        return true;
    }

    @Override
    public synchronized boolean delete() {
        boolean successful = true;
        if (!this.exists()) {
            successful = true;
        } else {
            try {
                if (this.isFile()) {
                    this.irodsFileSystemAO.fileDeleteNoForce(this);
                } else if (this.isDirectory()) {
                    this.irodsFileSystemAO.directoryDeleteNoForce(this);
                }
            }
            catch (FileNotFoundException dnf) {
                log.info("file not found, treat as unsuccessful");
                successful = false;
            }
            catch (JargonException e) {
                log.error("irods error occurred on delete, this was not a data not found exception, rethrow as unchecked", e);
                throw new JargonRuntimeException("exception occurred on delete", e);
            }
        }
        this.objStat = null;
        this.fileDescriptor = -1;
        return successful;
    }

    @Override
    public synchronized boolean deleteWithForceOption() {
        boolean successful = true;
        try {
            if (this.isFile()) {
                this.irodsFileSystemAO.fileDeleteForce(this);
            } else if (this.isDirectory()) {
                this.irodsFileSystemAO.directoryDeleteForce(this);
            }
        }
        catch (FileNotFoundException fnf) {
            log.info("file not found, treat as unsuccessful");
            successful = false;
        }
        catch (JargonException e) {
            String msg = "JargonException caught and logged on delete, method will return false and continue:" + e.getMessage();
            log.error(msg, e);
            successful = false;
        }
        this.objStat = null;
        this.fileDescriptor = -1;
        return successful;
    }

    @Override
    public void deleteOnExit() {
        throw new JargonRuntimeException("delete on exit is not supported for IRODS Files, please explicitly delete the file");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof File) {
            File temp = (File)obj;
            return temp.getAbsolutePath().equals(this.getAbsolutePath());
        }
        return false;
    }

    @Override
    public synchronized boolean exists() {
        boolean isExists = false;
        try {
            isExists = this.irodsFileSystemAO.isFileExists(this);
        }
        catch (FileNotFoundException e) {
            log.warn("file not found exception, return false", e);
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return isExists;
    }

    @Override
    public File getAbsoluteFile() {
        try {
            return new IRODSFileImpl(this.getAbsolutePath(), this.irodsFileSystemAO);
        }
        catch (JargonException e) {
            String msg = "JargonException caught and rethrown as JargonRuntimeException:" + e.getMessage();
            log.error(msg, e);
            throw new JargonRuntimeException(e);
        }
    }

    @Override
    public String getAbsolutePath() {
        StringBuilder pathBuilder = new StringBuilder();
        String builtPath = "";
        if (this.directory != null && !this.directory.isEmpty()) {
            boolean firstPath = true;
            for (String element : this.directory) {
                if (!firstPath) {
                    pathBuilder.append("/");
                }
                pathBuilder.append(element);
                firstPath = false;
            }
            pathBuilder.append("/");
            pathBuilder.append(this.getName());
            builtPath = pathBuilder.toString();
        } else {
            String name = this.getName();
            if (name == null || name.equals("")) {
                builtPath = "/";
            } else if (name.equals("/")) {
                builtPath = name;
            }
        }
        return builtPath;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        String canonicalPath = this.getCanonicalPath();
        try {
            return new IRODSFileImpl(canonicalPath, this.irodsFileSystemAO);
        }
        catch (JargonException e) {
            String msg = "jargon exception in file method, rethrown as IOException to match method signature" + e.getMessage();
            log.error(msg, e);
            throw new IOException(msg, e);
        }
    }

    @Override
    public String getCanonicalPath() throws IOException {
        if (this.directory != null && !this.directory.isEmpty()) {
            int size = this.directory.size();
            StringBuilder path = new StringBuilder();
            path.append(this.directory.get(0));
            for (int i = 1; i < size; ++i) {
                path.append(separator);
                path.append(this.directory.get(i));
            }
            path.append(separator);
            path.append(this.fileName);
            return path.toString();
        }
        return this.fileName;
    }

    @Override
    public long getFreeSpace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getParentFile() {
        String parentPath = this.getParent();
        if (parentPath == null) {
            return null;
        }
        try {
            return new IRODSFileImpl(parentPath, this.irodsFileSystemAO);
        }
        catch (JargonException e) {
            String msg = "jargon exception in file method, rethrown as JargonRuntimeException to match method signature" + e.getMessage();
            log.error(msg, e);
            throw new JargonRuntimeException(msg, e);
        }
    }

    @Override
    public long getTotalSpace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getUsableSpace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return this.getAbsolutePath().toLowerCase().hashCode() ^ 0x12D591;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public synchronized boolean isDirectory() {
        log.info("isDirectory() for path:{}", (Object)this.getAbsolutePath());
        boolean isDir = false;
        try {
            if (this.objStat == null) {
                log.info("looking up objStat, not cached in file");
                this.objStat = this.irodsFileSystemAO.getObjStat(this.getAbsolutePath());
            }
            if (this.getObjStat().getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.COLLECTION || this.getObjStat().getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_DIR) {
                isDir = true;
            }
        }
        catch (FileNotFoundException fnf) {
            log.info("file not found");
        }
        catch (JargonException je) {
            log.error("jargon exception, rethrow as unchecked", je);
            throw new JargonRuntimeException(je);
        }
        return isDir;
    }

    @Override
    public synchronized boolean isFile() {
        log.info("isFile() for path:{}", (Object)this.getAbsolutePath());
        boolean isFile = false;
        try {
            if (this.objStat == null) {
                log.info("looking up objStat, not cached in file");
                this.objStat = this.irodsFileSystemAO.getObjStat(this.getAbsolutePath());
            }
            if (this.getObjStat().getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT || this.getObjStat().getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_FILE) {
                isFile = true;
            }
        }
        catch (FileNotFoundException fnf) {
            log.info("file not found");
        }
        catch (JargonException je) {
            log.error("jargon exception, rethrow as unchecked", je);
            throw new JargonRuntimeException(je);
        }
        return isFile;
    }

    @Override
    public String getPath() {
        return this.getAbsolutePath();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public synchronized long lastModified() {
        log.info("lastModified() for path:{}", (Object)this.getAbsolutePath());
        long lastMod = 0L;
        try {
            this.initializeObjStatForFile();
            lastMod = this.objStat.getModifiedAt().getTime();
        }
        catch (FileNotFoundException e) {
            log.warn("file not found exception, return 0L", e);
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return lastMod;
    }

    @Override
    public synchronized long length() {
        log.info("length() for path:{}", (Object)this.getAbsolutePath());
        long length = 0L;
        try {
            this.initializeObjStatForFile();
            length = this.objStat.getObjSize();
        }
        catch (FileNotFoundException e) {
            log.warn("file not found exception, return false", e);
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return length;
    }

    @Override
    public synchronized String[] list() {
        try {
            List<String> result = this.irodsFileSystemAO.getListInDir(this);
            String[] a = new String[result.size()];
            return result.toArray(a);
        }
        catch (DataNotFoundException e) {
            return new String[0];
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
    }

    @Override
    public synchronized String[] list(FilenameFilter filter) {
        return super.list(filter);
    }

    @Override
    public synchronized File[] listFiles() {
        try {
            List<String> result = this.irodsFileSystemAO.getListInDir(this);
            File[] a = new IRODSFileImpl[result.size()];
            int i = 0;
            for (String fileName : result) {
                IRODSFileImpl irodsFile = new IRODSFileImpl(this.getAbsolutePath(), fileName, this.irodsFileSystemAO);
                a[i++] = irodsFile;
            }
            return a;
        }
        catch (DataNotFoundException e) {
            return new IRODSFileImpl[0];
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
    }

    @Override
    public synchronized File[] listFiles(FileFilter filter) {
        try {
            List<File> result = this.irodsFileSystemAO.getListInDirWithFileFilter(this, filter);
            File[] resArray = new File[result.size()];
            return result.toArray(resArray);
        }
        catch (DataNotFoundException e) {
            return new IRODSFileImpl[0];
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            e.printStackTrace();
            throw new JargonRuntimeException(e);
        }
    }

    @Override
    public synchronized File[] listFiles(FilenameFilter filter) {
        try {
            List<String> result = this.irodsFileSystemAO.getListInDirWithFilter(this, new IRODSAcceptAllFileNameFilter());
            File[] a = new IRODSFileImpl[result.size()];
            int i = 0;
            for (String fileName : result) {
                IRODSFileImpl irodsFile = new IRODSFileImpl(fileName, this.irodsFileSystemAO);
                a[i++] = irodsFile;
            }
            return a;
        }
        catch (DataNotFoundException e) {
            return new IRODSFileImpl[0];
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
    }

    @Override
    public boolean mkdir() {
        try {
            this.irodsFileSystemAO.mkdir(this, false);
        }
        catch (DuplicateDataException e) {
            log.info("duplicate data exception, return false from mkdir", e);
            return false;
        }
        catch (JargonException e) {
            if (e.getMessage().indexOf("-809000") > -1) {
                log.warn("directory already exists");
                return false;
            }
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean mkdirs() {
        try {
            this.irodsFileSystemAO.mkdir(this, true);
        }
        catch (DuplicateDataException e) {
            log.info("duplicate data exception, return false from mkdir", e);
            return false;
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return true;
    }

    @Override
    public synchronized boolean renameTo(IRODSFile dest) {
        boolean success = false;
        if (dest == null) {
            String msg = "dest file is null";
            log.error(msg);
            throw new JargonRuntimeException(msg);
        }
        if (!(dest instanceof IRODSFileImpl)) {
            String msg = "provided dest file is not an instance of IRODSFileImpl, cannot rename";
            log.error(msg);
            throw new JargonRuntimeException(msg);
        }
        IRODSFile destIRODSFile = dest;
        if (log.isInfoEnabled()) {
            log.info("renaming:" + this.getAbsolutePath() + " to:" + destIRODSFile.getAbsolutePath());
        }
        if (!this.getAbsolutePath().equals(dest.getAbsolutePath())) {
            this.renameFileOrDirectory(destIRODSFile);
            success = true;
        } else {
            log.info("doing a physical move");
            try {
                this.irodsFileSystemAO.physicalMove(this, destIRODSFile.getResource());
                success = true;
            }
            catch (JargonException e) {
                log.error("jargon exception, rethrow as unchecked", e);
                throw new JargonRuntimeException(e);
            }
        }
        this.objStat = null;
        return success;
    }

    void renameFileOrDirectory(IRODSFile destIRODSFile) throws JargonRuntimeException {
        if (this.isDirectory()) {
            log.info("paths different, and a directory is being renamed");
            try {
                this.irodsFileSystemAO.renameDirectory(this, destIRODSFile);
            }
            catch (JargonException e) {
                log.error("jargon exception, rethrow as unchecked", e);
                throw new JargonRuntimeException(e);
            }
        }
        if (this.isFile()) {
            log.info("paths different, and a file is being renamed");
            try {
                this.irodsFileSystemAO.renameFile(this, destIRODSFile);
            }
            catch (JargonException e) {
                log.error("jargon exception, rethrow as unchecked", e);
                throw new JargonRuntimeException(e);
            }
        }
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setExecutable(boolean executable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setLastModified(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadable(boolean readable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("irods://");
        s.append(this.irodsFileSystemAO.getIRODSAccount().getUserName());
        s.append('@');
        s.append(this.irodsFileSystemAO.getIRODSAccount().getHost());
        s.append(':');
        s.append(this.irodsFileSystemAO.getIRODSAccount().getPort());
        s.append(this.getAbsolutePath());
        return s.toString();
    }

    @Override
    public URI toURI() {
        URI uri = null;
        try {
            uri = this.isDirectory() ? new URI("irods", this.irodsFileSystemAO.getIRODSAccount().getUserName(), this.irodsFileSystemAO.getIRODSAccount().getHost(), this.irodsFileSystemAO.getIRODSAccount().getPort(), this.getAbsolutePath(), null, null) : new URI("irods", this.irodsFileSystemAO.getIRODSAccount().getUserName(), this.irodsFileSystemAO.getIRODSAccount().getHost(), this.irodsFileSystemAO.getIRODSAccount().getPort(), this.getAbsolutePath(), null, null);
        }
        catch (URISyntaxException e) {
            log.error("URISyntaxException, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return uri;
    }

    @Override
    public String getResource() throws JargonException {
        return this.resource;
    }

    @Override
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public synchronized int getFileDescriptor() {
        return this.fileDescriptor;
    }

    protected synchronized void setFileDescriptor(int fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    private int openWithMode(DataObjInp.OpenFlags openFlags, boolean checkExists) throws JargonException {
        if (log.isInfoEnabled()) {
            log.info("opening irodsFile:" + this.getAbsolutePath());
        }
        if (checkExists && !this.exists()) {
            throw new JargonException("this file does not exist, so it cannot be opened.  The file should be created first!");
        }
        if (this.getFileDescriptor() > 0) {
            log.info("file is already open, use the given descriptor");
            return this.fileDescriptor;
        }
        int fileDescriptor = this.irodsFileSystemAO.openFile(this, openFlags);
        if (log.isDebugEnabled()) {
            log.debug("opened file with descriptor of:" + fileDescriptor);
        }
        this.fileDescriptor = fileDescriptor;
        return fileDescriptor;
    }

    @Override
    public synchronized int openReadOnly() throws JargonException {
        return this.openWithMode(DataObjInp.OpenFlags.READ, true);
    }

    @Override
    public synchronized int open() throws JargonException {
        return this.openWithMode(DataObjInp.OpenFlags.READ_WRITE, true);
    }

    private synchronized int openKnowingExists() throws JargonException {
        return this.openWithMode(DataObjInp.OpenFlags.READ_WRITE, false);
    }

    @Override
    public synchronized void close() throws JargonException {
        if (log.isInfoEnabled()) {
            log.info("closing irodsFile:{}", (Object)this.getAbsolutePath());
        }
        this.reset();
        if (this.getFileDescriptor() <= 0) {
            log.info("file is not open, silently ignore");
            this.setFileDescriptor(-1);
            return;
        }
        this.irodsFileSystemAO.fileClose(this.getFileDescriptor());
        this.setFileDescriptor(-1);
        this.objStat = null;
    }

    @Override
    public synchronized void closeGivenDescriptor(int fd) throws JargonException {
        if (log.isInfoEnabled()) {
            log.info("closing irodsFile given descriptor:" + fd);
        }
        if (fd <= 0) {
            log.info("file is not open, silently ignore");
            this.setFileDescriptor(-1);
            return;
        }
        this.irodsFileSystemAO.fileClose(fd);
        this.setFileDescriptor(-1);
        this.objStat = null;
    }

    @Override
    public int compareTo(IRODSFile pathname) {
        return this.getAbsolutePath().compareTo(pathname.getAbsolutePath());
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public String getParent() {
        StringBuilder pathBuilder = new StringBuilder();
        if (this.directory != null && !this.directory.isEmpty()) {
            int size = this.directory.size();
            pathBuilder.append(this.directory.get(0));
            for (int i = 1; i < size; ++i) {
                pathBuilder.append("/");
                pathBuilder.append(this.directory.get(i));
            }
            if (pathBuilder.length() == 0) {
                pathBuilder.append("/");
            }
            return pathBuilder.toString();
        }
        return null;
    }

    @Override
    public synchronized ObjStat initializeObjStatForFile() throws FileNotFoundException, JargonException {
        if (this.objStat == null) {
            this.objStat = this.irodsFileSystemAO.getObjStat(this.getAbsolutePath());
        }
        return this.objStat;
    }

    @Override
    public synchronized boolean canExecute() {
        boolean canExecute = false;
        try {
            this.initializeObjStatForFile();
            canExecute = this.irodsFileSystemAO.isFileExecutable(this);
        }
        catch (FileNotFoundException e) {
            log.warn("file not found exception, return false", e);
        }
        catch (JargonException e) {
            log.error("jargon exception, rethrow as unchecked", e);
            throw new JargonRuntimeException(e);
        }
        return canExecute;
    }

    public synchronized ObjStat getObjStat() {
        return this.objStat;
    }

    public synchronized void setObjStat(ObjStat objStat) {
        this.objStat = objStat;
    }
}

