/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.List;
import org.irods.jargon.core.query.AVUQueryOperatorEnum;
import org.irods.jargon.core.query.JargonQueryException;

public class AVUQueryElement {
    private final AVUQueryPart avuQueryPart;
    private final AVUQueryOperatorEnum operator;
    private final String value;
    private final String valueEndOfRange;
    private final List<Object> valuesTable;

    public static AVUQueryElement instanceForValueQuery(AVUQueryPart avuQueryPart, AVUQueryOperatorEnum operator, String value) throws JargonQueryException {
        return new AVUQueryElement(avuQueryPart, operator, value, null, null);
    }

    private AVUQueryElement(AVUQueryPart avuQueryPart, AVUQueryOperatorEnum operator, String value, String valueEndOfRange, List<Object> valuesTable) throws JargonQueryException {
        if (avuQueryPart == null) {
            throw new JargonQueryException("avuQueryPart is null");
        }
        if (operator == null) {
            throw new JargonQueryException("avuQueryOperator is null");
        }
        if (value == null) {
            throw new JargonQueryException("null value");
        }
        this.avuQueryPart = avuQueryPart;
        this.operator = operator;
        this.value = value.trim();
        this.valueEndOfRange = valueEndOfRange;
        this.valuesTable = null;
        if (valueEndOfRange != null) {
            throw new JargonQueryException("currently unsupported");
        }
        if (valuesTable != null) {
            throw new JargonQueryException("currently unsupported");
        }
    }

    public AVUQueryPart getAvuQueryPart() {
        return this.avuQueryPart;
    }

    public AVUQueryOperatorEnum getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueEndOfRange() {
        return this.valueEndOfRange;
    }

    public List<Object> getValuesTable() {
        return this.valuesTable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AVUQueryElement)) {
            return false;
        }
        AVUQueryElement otherObj = (AVUQueryElement)other;
        return this.avuQueryPart.equals((Object)otherObj.avuQueryPart) && this.operator.equals((Object)otherObj.operator) && this.value.equals(otherObj.value);
    }

    public int hashCode() {
        return this.avuQueryPart.hashCode() + this.operator.hashCode() + this.value.hashCode();
    }

    public static enum AVUQueryPart {
        ATTRIBUTE,
        VALUE,
        UNITS;

    }
}

