/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.ExtensibleMetaDataMapping;
import org.irods.jargon.core.query.ExtensibleMetaDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensibleMetadataPropertiesSource
implements ExtensibleMetaDataSource {
    private static Logger log = LoggerFactory.getLogger(ExtensibleMetadataPropertiesSource.class);
    private Map<String, String> extensibleMetaDataProperties = null;
    private String propertiesFileName = "";

    public ExtensibleMetadataPropertiesSource() throws JargonException {
        this("extended_icat_data.properties");
    }

    public ExtensibleMetadataPropertiesSource(String propertiesFileName) throws JargonException {
        if (propertiesFileName == null || propertiesFileName.length() == 0) {
            String msg = "no properties file name defined";
            log.error(msg);
            throw new JargonException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("using properties file:" + propertiesFileName);
        }
        this.propertiesFileName = propertiesFileName;
        this.initialize();
    }

    private void initialize() throws JargonException {
        log.debug("initializing extensible metadata properties");
        if (this.propertiesFileName == null || this.propertiesFileName.length() == 0) {
            String msg = "initialization error, no properties file name was defined";
            log.error(msg);
            throw new JargonException(msg);
        }
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream(this.propertiesFileName);
        if (in == null) {
            String msg = "no properties file found for:" + this.propertiesFileName;
            log.error(msg);
            throw new JargonException(msg);
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException ioe) {
            throw new JargonException("error loading test properties", ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        this.extensibleMetaDataProperties = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            String keyString = (String)key;
            this.extensibleMetaDataProperties.put(keyString, properties.getProperty((String)key));
        }
    }

    @Override
    public ExtensibleMetaDataMapping generateExtensibleMetaDataMapping() throws JargonException {
        log.debug("cloning the properties and building an ExtensibleMetaDataMapping");
        if (this.extensibleMetaDataProperties == null) {
            throw new JargonException("the properties I want to use to build the metadata mapping are null");
        }
        ExtensibleMetaDataMapping mapping = ExtensibleMetaDataMapping.instance(this.extensibleMetaDataProperties);
        return mapping;
    }
}

